/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.paneblacklist;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackList;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistCountFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.controller.worker.Busy;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.p2event.P2Listener;
import javafx.beans.property.BooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PanelButton {
    P2Listener listenerLoadFilmlistStart;
    P2Listener listenerLoadFilmlistFinished;

    void close() {
        ProgData.getInstance().pEventHandler.removeListener(this.listenerLoadFilmlistStart);
        ProgData.getInstance().pEventHandler.removeListener(this.listenerLoadFilmlistFinished);
    }

    void addButton(Stage stage, VBox vBox, TableView<BlackData> tableView, BooleanProperty blackDataChanged, BlackList list) {
        Button btnDel = new Button("");
        btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        btnDel.setOnAction(event -> {
            ObservableList selected = tableView.getSelectionModel().getSelectedItems();
            if (selected == null || selected.isEmpty()) {
                P2Alert.showInfoNoSelection();
            } else {
                blackDataChanged.set(true);
                list.removeBlackData(selected);
                tableView.getSelectionModel().clearSelection();
            }
        });
        Button btnNew = new Button("");
        btnNew.setGraphic(ProgIcons.ICON_BUTTON_ADD.getImageView());
        btnNew.setOnAction(event -> {
            blackDataChanged.set(true);
            BlackData blackData = new BlackData();
            list.add(blackData);
            tableView.getSelectionModel().clearSelection();
            tableView.getSelectionModel().select(blackData);
            tableView.scrollTo(blackData);
        });
        Button btnHelpCount = P2Button.helpButton(stage, "Treffer z\u00e4hlen", "Beim \"Treffer z\u00e4hlen\" wird jeder Film gegen alle Filter gepr\u00fcft und jeder Treffer wird gez\u00e4hlt.\nAnders beim Filtern der Filmliste: Dort wird nach dem ersten Treffer die weitere Suche abgebrochen. Das ist dadurch also etwas schneller.\n\n\"Putzen\" entfernt doppelte und leere Blacklist-Eintr\u00e4ge. Das wird auch automatisch beim Programmstart gemacht.");
        final Button btnCountHits = new Button("_Treffer z\u00e4hlen");
        btnCountHits.setTooltip(new Tooltip("Damit wird die Filmliste nach \"Treffern\" durchsucht.\nF\u00fcr jeden Eintrag in der Blacklist wird gez\u00e4hlt,\nwie viele Filme damit geblockt werden."));
        btnCountHits.setOnAction(a -> {
            if (ProgData.busy.isBusy()) {
                return;
            }
            ProgData.busy.busyOnFx(Busy.BUSY_SRC.PANE_BLACKLIST, "Blacklist", -1.0, false);
            new Thread(() -> {
                BlacklistCountFactory.countHits(list);
                P2TableFactory.refreshTable(tableView);
                ProgData.busy.busyOffFx();
            }).start();
        });
        Button btnAddStandards = new Button("_Standards einf\u00fcgen");
        btnAddStandards.setTooltip(new Tooltip("Die Standardeintr\u00e4ge der Liste anf\u00fcgen"));
        btnAddStandards.setOnAction(event -> {
            blackDataChanged.set(true);
            BlacklistFactory.addStandardsList(list);
        });
        Button btnCleanList = new Button("_Putzen");
        btnCleanList.setTooltip(new Tooltip("In der Liste werden doppelte und leere Eintr\u00e4ge gel\u00f6scht"));
        btnCleanList.setOnAction(event -> {
            blackDataChanged.set(true);
            list.cleanTheList();
        });
        Button btnClear = new Button("_Alle l\u00f6schen");
        btnClear.setTooltip(new Tooltip("Alle Eintr\u00e4ge in der Liste werden gel\u00f6scht"));
        btnClear.setOnAction(event -> {
            if (!list.isEmpty() && !P2Alert.showAlertOkCancel(stage, "Liste l\u00f6schen", "Sollen alle Tabelleneintr\u00e4ge gel\u00f6scht werden?", "Die Tabelle wird komplett gel\u00f6scht und alle Eintr\u00e4ge gehen verloren.")) {
                return;
            }
            blackDataChanged.set(true);
            list.clearList();
        });
        this.listenerLoadFilmlistStart = new P2Listener(PEvents.EVENT_FILMLIST_LOAD_START){

            @Override
            public void pingGui() {
                btnCountHits.setDisable(true);
            }
        };
        this.listenerLoadFilmlistFinished = new P2Listener(PEvents.EVENT_FILMLIST_LOAD_FINISHED){

            @Override
            public void pingGui() {
                btnCountHits.setDisable(false);
            }
        };
        ProgData.getInstance().pEventHandler.addListener(this.listenerLoadFilmlistStart);
        ProgData.getInstance().pEventHandler.addListener(this.listenerLoadFilmlistFinished);
        HBox hBoxButton = new HBox(5.0);
        hBoxButton.getChildren().addAll((Node[])new Node[]{btnNew, btnDel, btnClear});
        hBoxButton.getChildren().addAll((Node[])new Node[]{P2GuiTools.getHBoxGrower(), btnCountHits, btnAddStandards, btnCleanList});
        hBoxButton.getChildren().addAll((Node[])new Node[]{btnHelpCount});
        VBox.setVgrow(tableView, Priority.ALWAYS);
        VBox vb = new VBox(5.0);
        vb.getChildren().addAll((Node[])new Node[]{hBoxButton});
        vBox.getChildren().add(vb);
    }
}

