/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.paneblacklist;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackList;
import de.p2tools.mtplayer.controller.load.LoadAudioFactory;
import de.p2tools.mtplayer.controller.load.LoadFilmFactory;
import de.p2tools.mtplayer.controller.worker.Busy;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.mtplayer.gui.configdialog.paneblacklist.PanelButton;
import de.p2tools.mtplayer.gui.configdialog.paneblacklist.PanelFilterGrid;
import de.p2tools.mtplayer.gui.configdialog.paneblacklist.PanelMoveButton;
import de.p2tools.mtplayer.gui.tools.table.Table;
import de.p2tools.mtplayer.gui.tools.table.TableBlacklist;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2MenuButton;
import de.p2tools.p2lib.guitools.P2RowFactory;
import de.p2tools.p2lib.guitools.P2Text;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneBlackList {
    private final RadioButton rbBlackFilm = new RadioButton("Blacklist");
    private final RadioButton rbWhiteFilm = new RadioButton("Whitelist");
    private final RadioButton rbOffFilm = new RadioButton("Alles anzeigen");
    private final RadioButton rbBlackAudio = new RadioButton("Blacklist");
    private final RadioButton rbWhiteAudio = new RadioButton("Whitelist");
    private final RadioButton rbOffAudio = new RadioButton("Alles anzeigen");
    public final RadioButton rbFilm = new RadioButton("Film");
    public final RadioButton rbAudio = new RadioButton("Audio");
    public final RadioButton rbFilmAudio = new RadioButton("Film und Audio");
    private SplitPane splitPane;
    private final TableBlacklist tableView;
    private final GridPane gridPane = new GridPane();
    private final P2ToggleSwitch tglActive = new P2ToggleSwitch("Aktiv:");
    private final P2MenuButton mbChannel;
    private final StringProperty mbChannelProp = new SimpleStringProperty();
    private final P2ToggleSwitch tgThemeExact = new P2ToggleSwitch("exakt:");
    private final TextField txtTheme = new TextField();
    private final TextField txtTitle = new TextField();
    private final TextField txtThemeTitle = new TextField();
    private final BlackList list;
    private final SortedList<BlackData> sortedList;
    private BlackData blackData = null;
    private final BooleanProperty blackDataChanged;
    private boolean selectedBlackDataChanged = false;
    private final boolean controlBlackListNotFilmFilter;
    private final PanelButton panelButton;
    private final PanelFilterGrid panelFilterGrid;
    private final Stage stage;
    private final ProgData progData;
    private final ToggleGroup toggleGroupList = new ToggleGroup();
    private final ChangeListener<Toggle> changeListener = (u, o, n) -> {
        if (this.blackData != null) {
            if (this.rbFilmAudio.isSelected()) {
                this.blackData.setList(0);
            } else if (this.rbFilm.isSelected()) {
                this.blackData.setList(1);
            } else {
                this.blackData.setList(2);
            }
        }
    };

    public PaneBlackList(Stage stage, ProgData progData, boolean controlBlackListNotFilmFilter, BooleanProperty blackDataChanged) {
        this.stage = stage;
        this.progData = progData;
        this.controlBlackListNotFilmFilter = controlBlackListNotFilmFilter;
        this.blackDataChanged = blackDataChanged;
        this.panelButton = new PanelButton();
        this.mbChannel = new P2MenuButton(this.mbChannelProp, ThemeListFactory.allChannelListFilm, true);
        if (controlBlackListNotFilmFilter) {
            this.tableView = new TableBlacklist(Table.TABLE_ENUM.BLACKLIST);
            Table.setTable(this.tableView);
            this.sortedList = progData.blackList.getSortedList();
            this.list = progData.blackList;
        } else {
            this.tableView = new TableBlacklist(Table.TABLE_ENUM.FILMFILTER);
            Table.setTable(this.tableView);
            this.sortedList = progData.filmListFilter.getSortedList();
            this.list = progData.filmListFilter;
        }
        this.panelFilterGrid = new PanelFilterGrid(this.tableView, this.list, controlBlackListNotFilmFilter ? progData.blackListFilterBlackList : progData.blackListFilterFilmList);
    }

    public void close() {
        this.list.getUndoList().clear();
        this.panelButton.close();
        this.panelFilterGrid.close();
        if (this.controlBlackListNotFilmFilter) {
            Table.saveTable(this.tableView, Table.TABLE_ENUM.BLACKLIST);
            ((SplitPane.Divider)this.splitPane.getDividers().get(0)).positionProperty().unbindBidirectional(ProgConfig.CONFIG_DIALOG_BLACKLIST_SPLITPANE);
        } else {
            Table.saveTable(this.tableView, Table.TABLE_ENUM.FILMFILTER);
            ((SplitPane.Divider)this.splitPane.getDividers().get(0)).positionProperty().unbindBidirectional(ProgConfig.CONFIG_DIALOG_FILMLIST_FILTER_SPLITPANE);
        }
    }

    public void make(Collection<TitledPane> result) {
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        vBox.setAlignment(Pos.TOP_RIGHT);
        this.makeConfigBlackList(vBox);
        this.initTable();
        this.splitPane = this.panelFilterGrid.addFilterGrid(vBox, this.controlBlackListNotFilmFilter);
        this.panelButton.addButton(this.stage, vBox, this.tableView, this.blackDataChanged, this.list);
        PanelMoveButton.addMoveButton(this.stage, vBox, this.tableView, this.progData, this.controlBlackListNotFilmFilter, this.blackDataChanged, this.list);
        this.addConfigs(vBox);
        Button btnLoadAudio = new Button("_Audioliste mit diesen Einstellungen neu laden");
        btnLoadAudio.setTooltip(new Tooltip("Eine komplette neue Audioliste laden.\nGe\u00e4nderte Einstellungen f\u00fcr das Laden der Audioliste werden so sofort \u00fcbernommen"));
        btnLoadAudio.setOnAction(event -> LoadAudioFactory.loadAudioListFromWeb(true, true));
        btnLoadAudio.setMaxWidth(Double.MAX_VALUE);
        btnLoadAudio.disableProperty().bind(ProgConfig.SYSTEM_USE_AUDIOLIST.not());
        HBox.setHgrow(btnLoadAudio, Priority.ALWAYS);
        Button btnLoadFilm = new Button("_Filmliste mit diesen Einstellungen neu laden");
        btnLoadFilm.setTooltip(new Tooltip("Eine komplette neue Filmliste laden.\nGe\u00e4nderte Einstellungen f\u00fcr das Laden der Filmliste werden so sofort \u00fcbernommen"));
        btnLoadFilm.setOnAction(event -> LoadFilmFactory.loadFilmListFromWeb(true, true));
        btnLoadFilm.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(btnLoadFilm, Priority.ALWAYS);
        HBox hBoxBtn = new HBox(5.0);
        hBoxBtn.setAlignment(Pos.CENTER_RIGHT);
        hBoxBtn.getChildren().addAll((Node[])new Node[]{btnLoadAudio, btnLoadFilm});
        if (!this.controlBlackListNotFilmFilter) {
            vBox.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVBoxGrower(), hBoxBtn});
        }
        vBox.getChildren().add(ProgData.busy.getBusyHbox(Busy.BUSY_SRC.PANE_BLACKLIST));
        TitledPane tpBlack = new TitledPane(this.controlBlackListNotFilmFilter ? "Blacklist" : "Beitr\u00e4ge ausschlie\u00dfen", vBox);
        result.add(tpBlack);
        tpBlack.setMaxHeight(Double.MAX_VALUE);
    }

    private void makeConfigBlackList(VBox vBox) {
        Button btnHelp = P2Button.helpButton(this.stage, "Blacklist / Whitelist", "Die Funktion \"Blacklist\" blendet alle Beitr\u00e4ge aus, die den Angaben in mindestens einer Zeile in der Tabelle entsprechen. Bei der \"Whitelist\" ist es umgekehrt, es werden nur Beitr\u00e4ge angezeigt, die den Angaben in mindestens einer Zeile entsprechen. Beim Umschalten zwischen Blacklist und Whitelist wird also die Auswahl der angezeigten Beitr\u00e4ge invertiert.\n\nMit den Textfeldern kann nach einem w\u00f6rtlichen Suchtext (Suchtext muss enthalten sein/oder darf nicht enthalten sein) oder nach regul\u00e4ren Ausdr\u00fccken (RegExp) gesucht werden.\n\nGro\u00df- und Kleinschreibung wird bei beiden Arten der Suche nicht unterschieden.\n\n-- W\u00f6rtlicher Suchtext muss enthalten sein --\nEin w\u00f6rtlicher Suchtext findet alle Dateien bei denen der Suchtext an beliebiger Stelle im durchsuchten Bereich enthalten ist.\n\nW\u00f6rtlicher Suchtext muss in \" angegeben werden. Dann wird alles gefunden, was im durchsuchten Bereich den Inhalt zwischen den \" enth\u00e4lt. Hier sind auch \",\" und \":\" erlaubt. Der gesamte Suchtext muss aber in \" eingeschlossen werden, z.B.\n\"das, das und das wird gesucht\"\nDann muss der durchsuchte Bereich genau das \"das, das und das wird gesucht\" enthalten (ohne die \").\nEine Suche mit RegEx, z.B. \"#:.*pass,+.*\" kann damit verk\u00fcrzt werden: \"pass,\". Das ist k\u00fcrzer und l\u00e4uft im Programm auch schneller.\n\nUm mehrere Begriffe zu suchen m\u00fcssen diese durch Komma oder Doppelpunkt getrennt werden. Das Komma verkn\u00fcpft die Begriffe mit ODER (=> mindestens einer der Begriffe muss vorkommen), der Doppelpunkt mit UND (=> alle Begriffe m\u00fcssen vorkommen).\n\n\n-- W\u00f6rtlicher Suchtext darf nicht enthalten sein --\nDer Suchtext muss mit '!:' (ohne die ' ') beginnen.\nEin w\u00f6rtlicher Suchtext schlie\u00dft alle Dateien aus, bei denen der Suchtext an beliebiger Stelle im durchsuchten Bereich enthalten ist.\n\nUm mehrere Begriffe auszuschlie\u00dfen, m\u00fcssen diese durch Komma oder Doppelpunkt getrennt werden. Das Komma verkn\u00fcpft die Begriffe mit ODER (=> mindestens einer der Begriffe muss enthalten sein) und der Doppelpunkt verkn\u00fcpft die Begriffe mit UND (=> alle Begriffe m\u00fcssen enthalten sein, damit der Beitrag ausgeschlossen wird).\n\n\nSuchtext und Suchbegriffe d\u00fcrfen Leerzeichen enthalten, aber kein Komma und keinen Doppelpunkt (wenn der gesamte Suchtext nicht in \" eingeschlossen ist.)\n\nBeispiele:\n'Tagesschau' findet u.a. 'Tagesschau, 12:00 Uhr', 'ARD Tagesschau Livestream', 'Bei Logo und der Tagesschau'.\n'Sport,Fussball' (Komma-getrennt) findet Filme bei denen 'Sport' oder 'Fussball' oder beides vorkommt, u.a. 'Wintersport im Mumintal' und 'Wie wird man Fussballprofi?'.\n'Sport:Fussball' (Doppelpunkt-getrennt) findet nur Dateien bei denen beides ('Sport' und 'Fussball') vorkommt, z.B. 'Wintersport, Fussball und Formel 1'.\n\n'!:Auto,Motorrad', es werden nur Beitr\u00e4ge gefunden, die weder \"Auto\" noch \"Motorrad\" enthalten.\n'!:Auto:Motorrad', es werden Beitr\u00e4ge gefunden, die \"Auto\" *und* \"Motorrad\" *nicht* enthalten.\n\n-- Regul\u00e4re Ausdr\u00fccke --\nEin Suchtext aus regul\u00e4ren Ausdr\u00fccken (RegExp) muss mit '#:' (ohne die ' ') beginnen.\n\nBeliebige Zeichen mit in die Suche aufnehmen (als '.+', '.*' oder '.?'') macht einen Unterschied!\n\nBeispiele:\n'#:Burger' oder '#:^burger$' -- beide finden 'Burger' und 'burger' und nichts sonst.\n'#:Burger.+' findet nicht 'Burger', aber alles was nach 'Burger' noch Zeichen enth\u00e4lt (z.B. 'Burger f\u00fcr die Straubing Tigers').\n'#:.+burger' findet alles was auf 'burger' oder 'Burger' endet (z.B. 'Der Hamburger' und '1. Burger').\n\nMehr zu regul\u00e4ren Ausdr\u00fccken:\nhttps://de.wikipedia.org/wiki/Regul%C3%A4rer_Ausdruck\n\n\n-- Besonderheiten --\nWenn bei \"Thema\" der Schalter \"Exakt\" eingeschaltet ist, darf der Suchtext nicht \"an beliebiger Stelle darin enthalten\" sein, sondern muss das gesamte Feld darstellen.\nBeispiele:\n\"Exakt\" eingeschaltet: 'Dokumentation' erfasst nur 'Dokumentation' oder 'dokumentation', nichts sonst.\n\"Exakt\" ausgeschaltet: 'Dokumentation' erfasst u.a. 'Dokumentationen und Reportagen', 'Reportage & Dokumentation', 'Geschichtsdokumentationen'.\n\n[Thema-Titel] durchsucht in der Filmliste THEMA und TITEL.\nBei einer Suche nach mehreren Suchbegriffen m\u00fcssen hier alle Suchbegriffe im selben Bereich vorkommen. Ein Film mit 'Sport' in THEMA und 'Fussball' in TITEL wird von 'Sport:Fussball' nicht erfasst.\n\n");
        ToggleGroup toggleGroupFilm = new ToggleGroup();
        this.rbBlackFilm.setToggleGroup(toggleGroupFilm);
        this.rbWhiteFilm.setToggleGroup(toggleGroupFilm);
        this.rbOffFilm.setToggleGroup(toggleGroupFilm);
        toggleGroupFilm.selectedToggleProperty().addListener((u, o, n) -> this.setBlackPropOnOff());
        ToggleGroup toggleGroupAudio = new ToggleGroup();
        this.rbBlackAudio.setToggleGroup(toggleGroupAudio);
        this.rbWhiteAudio.setToggleGroup(toggleGroupAudio);
        this.rbOffAudio.setToggleGroup(toggleGroupAudio);
        toggleGroupAudio.selectedToggleProperty().addListener((u, o, n) -> this.setBlackPropOnOff());
        this.rbFilmAudio.setToggleGroup(this.toggleGroupList);
        this.rbFilm.setToggleGroup(this.toggleGroupList);
        this.rbAudio.setToggleGroup(this.toggleGroupList);
        this.progData.filterWorkerFilm.getActFilterSettings().blacklistOnOffProperty().addListener((u, o, n) -> this.setBlackOnOff());
        this.progData.filterWorkerAudio.getActFilterSettings().blacklistOnOffProperty().addListener((u, o, n) -> this.setBlackOnOff());
        this.setBlackOnOff();
        GridPane gridPaneBlack = new GridPane();
        gridPaneBlack.setHgap(20.0);
        gridPaneBlack.setVgap(10.0);
        gridPaneBlack.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        GridPane.setValignment(btnHelp, VPos.TOP);
        GridPane.setHalignment(btnHelp, HPos.RIGHT);
        gridPaneBlack.add(P2Text.getTextBold("Filme:"), 0, 0);
        gridPaneBlack.add(this.rbBlackFilm, 1, 0);
        gridPaneBlack.add(this.rbWhiteFilm, 2, 0);
        gridPaneBlack.add(this.rbOffFilm, 3, 0);
        gridPaneBlack.add(btnHelp, 4, 0, 1, 2);
        if (this.controlBlackListNotFilmFilter) {
            gridPaneBlack.add(P2Text.getTextBold("Audios:"), 0, 1);
            gridPaneBlack.add(this.rbBlackAudio, 1, 1);
            gridPaneBlack.add(this.rbWhiteAudio, 2, 1);
            gridPaneBlack.add(this.rbOffAudio, 3, 1);
        }
        vBox.getChildren().add(gridPaneBlack);
    }

    private void initTable() {
        this.tableView.setRowFactory(new P2RowFactory());
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                ContextMenu contextMenu = this.getContextMenu(this.list);
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.setOnMouseClicked(event -> {
            ObservableList<TablePosition> cells;
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2 && (cells = this.tableView.getSelectionModel().getSelectedCells()) != null && !cells.isEmpty()) {
                String cel;
                switch (cel = ((TablePosition)cells.get(0)).getTableColumn().getText()) {
                    case "Liste": {
                        if (this.rbFilmAudio.isSelected()) {
                            this.rbFilm.setSelected(true);
                            break;
                        }
                        if (this.rbFilm.isSelected()) {
                            this.rbAudio.setSelected(true);
                            break;
                        }
                        this.rbFilmAudio.setSelected(true);
                        break;
                    }
                    case "Sender": {
                        this.mbChannel.requestFocus();
                        this.mbChannel.show();
                        break;
                    }
                    case "Thema": {
                        this.txtTheme.requestFocus();
                        break;
                    }
                    case "Thema exakt": {
                        this.tgThemeExact.setSelected(!this.tgThemeExact.isSelected());
                        break;
                    }
                    case "Titel": {
                        this.txtTitle.requestFocus();
                        break;
                    }
                    case "Thema-Titel": {
                        this.txtThemeTitle.requestFocus();
                        break;
                    }
                    case "Aktiv": {
                        this.tglActive.setSelected(!this.tglActive.isSelected());
                        break;
                    }
                    default: {
                        this.txtTheme.requestFocus();
                    }
                }
            }
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> this.setActBlackData());
        this.sortedList.comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.setItems(this.sortedList);
    }

    private ContextMenu getContextMenu(BlackList list) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem miUndo = new MenuItem("Gel\u00f6schte wieder anlegen");
        miUndo.setOnAction(a -> list.undoBlackData());
        miUndo.setDisable(list.getUndoList().isEmpty());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miUndo});
        MenuItem resetTable = new MenuItem("Tabelle zur\u00fccksetzen");
        resetTable.setOnAction(e -> this.tableView.resetTable());
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{resetTable});
        return contextMenu;
    }

    private void addConfigs(VBox vBox) {
        this.gridPane.getStyleClass().add("extra-pane");
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(2.0);
        this.gridPane.setPadding(new Insets(10.0));
        int row = 0;
        HBox hBoxChannel = new HBox(10.0);
        hBoxChannel.setAlignment(Pos.CENTER_LEFT);
        hBoxChannel.getChildren().addAll((Node[])new Node[]{this.mbChannel, P2GuiTools.getVDistance(50), this.tglActive, P2GuiTools.getHBoxGrower(), this.rbFilmAudio, this.rbFilm, this.rbAudio});
        this.gridPane.add(new Label("Sender:"), 0, row);
        this.gridPane.add(hBoxChannel, 1, row);
        this.gridPane.add(new Label("Thema:"), 0, ++row);
        HBox hBoxTheme = new HBox(10.0);
        hBoxTheme.getChildren().addAll((Node[])new Node[]{this.txtTheme, this.tgThemeExact});
        HBox.setHgrow(this.txtTheme, Priority.ALWAYS);
        this.gridPane.add(hBoxTheme, 1, row);
        this.gridPane.add(new Label("Titel:"), 0, ++row);
        this.gridPane.add(this.txtTitle, 1, row);
        this.gridPane.add(new Label("Thema-Titel:"), 0, ++row);
        this.gridPane.add(this.txtThemeTitle, 1, row);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        this.gridPane.setDisable(true);
        this.gridPane.disableProperty().bind(this.tableView.getSelectionModel().selectedItemProperty().isNull());
        this.toggleGroupList.selectedToggleProperty().addListener((o, u, n) -> this.setChanged());
        this.mbChannel.textProperty().addListener((observable2, oldValue, newValue) -> this.setChanged());
        this.txtTheme.textProperty().addListener((observable2, oldValue, newValue) -> this.setChanged());
        this.tgThemeExact.selectedProperty().addListener((observable2, oldValue, newValue) -> this.setChanged());
        this.txtTitle.textProperty().addListener((observable2, oldValue, newValue) -> this.setChanged());
        this.txtThemeTitle.textProperty().addListener((observable2, oldValue, newValue) -> this.setChanged());
        this.tglActive.selectedProperty().addListener((observable2, oldValue, newValue) -> this.setChanged());
        vBox.getChildren().add(this.gridPane);
    }

    private void setChanged() {
        if (this.selectedBlackDataChanged) {
            this.blackDataChanged.set(true);
        }
    }

    private void setBlackOnOff() {
        if (this.controlBlackListNotFilmFilter) {
            switch (this.progData.filterWorkerFilm.getActFilterSettings().getBlacklistOnOff()) {
                case 0: {
                    this.rbOffFilm.setSelected(true);
                    break;
                }
                case 1: {
                    this.rbBlackFilm.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbWhiteFilm.setSelected(true);
                }
            }
            switch (this.progData.filterWorkerAudio.getActFilterSettings().getBlacklistOnOff()) {
                case 0: {
                    this.rbOffAudio.setSelected(true);
                    break;
                }
                case 1: {
                    this.rbBlackAudio.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbWhiteAudio.setSelected(true);
                }
            }
        } else {
            switch (ProgConfig.SYSTEM_FILMLIST_FILTER.getValue()) {
                case 0: {
                    this.rbOffFilm.setSelected(true);
                    break;
                }
                case 1: {
                    this.rbBlackFilm.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbWhiteFilm.setSelected(true);
                }
            }
        }
    }

    private void setBlackPropOnOff() {
        if (this.controlBlackListNotFilmFilter) {
            if (this.rbBlackFilm.isSelected()) {
                this.progData.filterWorkerFilm.getActFilterSettings().setBlacklistOnOff(1);
            } else if (this.rbWhiteFilm.isSelected()) {
                this.progData.filterWorkerFilm.getActFilterSettings().setBlacklistOnOff(2);
            } else {
                this.progData.filterWorkerFilm.getActFilterSettings().setBlacklistOnOff(0);
            }
            if (this.rbBlackAudio.isSelected()) {
                this.progData.filterWorkerAudio.getActFilterSettings().setBlacklistOnOff(1);
            } else if (this.rbWhiteAudio.isSelected()) {
                this.progData.filterWorkerAudio.getActFilterSettings().setBlacklistOnOff(2);
            } else {
                this.progData.filterWorkerAudio.getActFilterSettings().setBlacklistOnOff(0);
            }
        } else if (this.rbBlackFilm.isSelected()) {
            ProgConfig.SYSTEM_FILMLIST_FILTER.setValue(1);
        } else if (this.rbWhiteFilm.isSelected()) {
            ProgConfig.SYSTEM_FILMLIST_FILTER.setValue(2);
        } else {
            ProgConfig.SYSTEM_FILMLIST_FILTER.setValue(0);
        }
    }

    private void setActBlackData() {
        this.selectedBlackDataChanged = false;
        BlackData blackDataAct = (BlackData)this.tableView.getSelectionModel().getSelectedItem();
        if (blackDataAct == this.blackData) {
            return;
        }
        this.toggleGroupList.selectedToggleProperty().removeListener(this.changeListener);
        if (this.blackData != null) {
            this.mbChannelProp.unbindBidirectional(this.blackData.channelProperty());
            this.tgThemeExact.selectedProperty().unbindBidirectional(this.blackData.themeExactProperty());
            this.txtTheme.textProperty().unbindBidirectional(this.blackData.themeProperty());
            this.txtTitle.textProperty().unbindBidirectional(this.blackData.titleProperty());
            this.txtThemeTitle.textProperty().unbindBidirectional(this.blackData.themeTitleProperty());
            this.tglActive.selectedProperty().unbindBidirectional(this.blackData.activeProperty());
            this.txtTheme.setText("");
            this.txtTitle.setText("");
            this.txtThemeTitle.setText("");
        }
        this.blackData = blackDataAct;
        if (this.blackData != null) {
            this.rbFilmAudio.setSelected(this.blackData.getList() == 0);
            this.rbFilm.setSelected(this.blackData.getList() == 1);
            this.rbAudio.setSelected(this.blackData.getList() == 2);
            this.toggleGroupList.selectedToggleProperty().addListener(this.changeListener);
            this.mbChannelProp.bindBidirectional(this.blackData.channelProperty());
            this.txtTheme.textProperty().bindBidirectional(this.blackData.themeProperty());
            this.tgThemeExact.selectedProperty().bindBidirectional(this.blackData.themeExactProperty());
            this.txtTitle.textProperty().bindBidirectional(this.blackData.titleProperty());
            this.txtThemeTitle.textProperty().bindBidirectional(this.blackData.themeTitleProperty());
            this.tglActive.selectedProperty().bindBidirectional(this.blackData.activeProperty());
            this.selectedBlackDataChanged = true;
        }
    }
}

