/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.paneblacklist;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneBlack {
    private final ProgData progData;
    private final Slider slSize = new Slider();
    private final Label lblSize = new Label("");
    private final Slider slDays = new Slider();
    private final Label lblDays = new Label("");
    private final P2ToggleSwitch tglAbo = new P2ToggleSwitch("Die Blacklist beim Suchen der Abos ber\u00fccksichtigen");
    private final P2ToggleSwitch tglFuture = new P2ToggleSwitch("Filme mit Datum in der Zukunft nicht anzeigen");
    private final P2ToggleSwitch tglGeo = new P2ToggleSwitch("Filme, die per Geoblocking gesperrt sind, nicht anzeigen");
    private final P2ToggleSwitch tglDouble = new P2ToggleSwitch("Doppelte Filme nicht anzeigen");
    private final BooleanProperty blackChanged;
    private Stage stage;

    public PaneBlack(Stage stage, BooleanProperty blackChanged) {
        this.stage = stage;
        this.blackChanged = blackChanged;
        this.progData = ProgData.getInstance();
    }

    public void close() {
        this.tglAbo.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_BLACKLIST_SHOW_ABO);
        this.tglFuture.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_FUTURE);
        this.tglGeo.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_GEO);
        this.tglDouble.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_DOUBLE);
        this.slDays.valueProperty().unbindBidirectional(ProgConfig.SYSTEM_BLACKLIST_MAX_FILM_DAYS);
        this.slSize.valueProperty().unbindBidirectional(ProgConfig.SYSTEM_BLACKLIST_MIN_FILM_DURATION);
    }

    public void makeBlack(Collection<TitledPane> result) {
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        this.makeBlack(vBox);
        TitledPane tpBlack = new TitledPane("Blacklist allgemein", vBox);
        result.add(tpBlack);
        tpBlack.setMaxHeight(Double.MAX_VALUE);
    }

    private void makeBlack(VBox vBox) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        this.tglAbo.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_BLACKLIST_SHOW_ABO);
        this.tglAbo.selectedProperty().addListener((observable2, oldValue, newValue) -> this.blackChanged.set(true));
        Button btnHelp = P2Button.helpButton(this.stage, "Blacklist", "Einschalten, wenn auch die von Abos gefundenen Downloads mit der Blacklist/Whitelist gefiltert werden sollen.\n");
        this.tglFuture.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_FUTURE);
        this.tglFuture.selectedProperty().addListener((observable2, oldValue, newValue) -> this.blackChanged.set(true));
        Button btnHelpFuture = P2Button.helpButton(this.stage, "Blacklist", "Filme mit Datum in der Zukunft sind meist nur Trailer.\n");
        this.tglGeo.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_GEO);
        this.tglGeo.selectedProperty().addListener((observable2, oldValue, newValue) -> this.blackChanged.set(true));
        Button btnHelpGeo = P2Button.helpButton(this.stage, "Blacklist", "Einschalten, um geogeblockte Filme von Anzeige und Abo-Download auszuschlie\u00dfen.\nEs wird der in den Einstellungen unter \"Allgemein\" angegebene Standort verwendet.\n");
        this.tglDouble.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_DOUBLE);
        this.tglDouble.selectedProperty().addListener((observable2, oldValue, newValue) -> this.blackChanged.set(true));
        Button btnHelpDouble = P2Button.helpButton(this.stage, "Blacklist", "Einschalten, um doppelte Filme von Anzeige und Abo-Download auszuschlie\u00dfen.\n");
        this.initDays();
        Button btnHelpSize = P2Button.helpButton(this.stage, "Blacklist", "Filme ohne L\u00e4ngenangabe werden immer angezeigt und ggf. von Abos als Download angelegt.\n\nKurze Filme sind oft nur Trailer.\n\nWenn die Filmliste hiermit verk\u00fcrzt wird kann das Arbeiten mit den Filmen schneller werden.\n");
        Button btnHelpDays = P2Button.helpButton(this.stage, "Blacklist", "Filme ohne Datum werden immer angezeigt und ggf. von Abos als Download angelegt.\n\nWenn die Filmliste hiermit verk\u00fcrzt wird kann das Arbeiten mit den Filmen schneller werden.\n");
        this.lblDays.setMinWidth(Double.NEGATIVE_INFINITY);
        this.lblSize.setMinWidth(Double.NEGATIVE_INFINITY);
        int row = 0;
        gridPane.add(this.tglAbo, 0, row, 3, 1);
        gridPane.add(btnHelp, 3, row);
        gridPane.add(this.tglFuture, 0, ++row, 3, 1);
        gridPane.add(btnHelpFuture, 3, row);
        gridPane.add(this.tglGeo, 0, ++row, 3, 1);
        gridPane.add(btnHelpGeo, 3, row);
        gridPane.add(this.tglDouble, 0, ++row, 3, 1);
        gridPane.add(btnHelpDouble, 3, row);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(new Label("Nur Filme der letzten Tage anzeigen:"), 0, ++row, 2, 1);
        Label lbl = new Label("Filme anzeigen:");
        gridPane.add(lbl, 0, ++row);
        gridPane.add(this.slDays, 1, row);
        gridPane.add(this.lblDays, 2, row);
        gridPane.add(btnHelpDays, 3, row);
        GridPane.setHgrow(this.slDays, Priority.ALWAYS);
        GridPane.setValignment(lbl, VPos.TOP);
        GridPane.setValignment(this.slDays, VPos.TOP);
        GridPane.setValignment(this.lblDays, VPos.TOP);
        GridPane.setValignment(btnHelpDays, VPos.TOP);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(new Label("Nur Filme mit Mindestl\u00e4nge anzeigen:"), 0, ++row, 2, 1);
        lbl = new Label("Filme anzeigen:");
        gridPane.add(lbl, 0, ++row);
        gridPane.add(this.slSize, 1, row);
        gridPane.add(this.lblSize, 2, row);
        gridPane.add(btnHelpSize, 3, row);
        GridPane.setHgrow(this.slSize, Priority.ALWAYS);
        GridPane.setValignment(lbl, VPos.TOP);
        GridPane.setValignment(this.slSize, VPos.TOP);
        GridPane.setValignment(this.lblSize, VPos.TOP);
        GridPane.setValignment(btnHelpSize, VPos.TOP);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().add(gridPane);
    }

    private void initDays() {
        this.slDays.setMin(0.0);
        this.slDays.setMax(300.0);
        this.slDays.setMinorTickCount(4);
        this.slDays.setMajorTickUnit(100.0);
        this.slDays.setBlockIncrement(10.0);
        this.slDays.setShowTickLabels(true);
        this.slDays.setShowTickMarks(true);
        this.slDays.valueProperty().bindBidirectional(ProgConfig.SYSTEM_BLACKLIST_MAX_FILM_DAYS);
        this.slDays.valueProperty().addListener((observable2, oldValue, newValue) -> {
            this.setValueSlider();
            this.blackChanged.set(true);
        });
        this.slSize.setMin(0.0);
        this.slSize.setMax(100.0);
        this.slSize.setMinorTickCount(4);
        this.slSize.setMajorTickUnit(25.0);
        this.slSize.setBlockIncrement(10.0);
        this.slSize.setShowTickLabels(true);
        this.slSize.setShowTickMarks(true);
        this.slSize.valueProperty().bindBidirectional(ProgConfig.SYSTEM_BLACKLIST_MIN_FILM_DURATION);
        this.slSize.valueProperty().addListener((observable2, oldValue, newValue) -> {
            this.setValueSlider();
            this.blackChanged.set(true);
        });
        this.setValueSlider();
    }

    private void setValueSlider() {
        int min = (int)this.slSize.getValue();
        this.lblSize.setText((String)(min == 0 ? "alles anzeigen" : "nur Filme mit\nmindestens " + min + " Minuten L\u00e4nge"));
        min = (int)this.slDays.getValue();
        this.lblDays.setText((String)(min == 0 ? "alles anzeigen" : "nur Filme der\nletzten " + min + " Tage"));
    }
}

