/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneProxy {
    private final P2ToggleSwitch tglProxy = new P2ToggleSwitch("Einen Proxy verwenden");
    private final Stage stage;
    private final TextField txtServer = new TextField();
    private final TextField txtPort = new TextField();
    private final TextField txtUser = new TextField();
    private final TextField txtPwd = new TextField();

    public PaneProxy(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.tglProxy.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_USE_PROXY);
        this.txtServer.textProperty().unbindBidirectional(ProgConfig.SYSTEM_PROXY_HOST);
        this.txtPort.textProperty().unbindBidirectional(ProgConfig.SYSTEM_PROXY_PORT);
        this.txtUser.textProperty().unbindBidirectional(ProgConfig.SYSTEM_PROXY_USER);
        this.txtPwd.textProperty().unbindBidirectional(ProgConfig.SYSTEM_PROXY_PWD);
    }

    public TitledPane make(Collection<TitledPane> result) {
        this.tglProxy.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_USE_PROXY);
        Button btnHelpGeo = P2Button.helpButton(this.stage, "Proxy", "Hier kann ein Proxy-Server angegeben werden. Ist \"Proxy verwenden\" eingeschaltet, wird der gesamte Datenverkehr (Laden der Filmliste, Speichern von Filmen, ..) \u00fcber den Proxy-Server geleitet. Beim Download von Filmen mit externen Programmen, muss im externen Programm selbst die Einstellung f\u00fcr den Proxy vorgenommen werden!\n");
        this.txtServer.textProperty().bindBidirectional(ProgConfig.SYSTEM_PROXY_HOST);
        this.txtPort.textProperty().bindBidirectional(ProgConfig.SYSTEM_PROXY_PORT);
        this.txtUser.textProperty().bindBidirectional(ProgConfig.SYSTEM_PROXY_USER);
        this.txtPwd.textProperty().bindBidirectional(ProgConfig.SYSTEM_PROXY_PWD);
        this.txtServer.disableProperty().bind(this.tglProxy.selectedProperty().not());
        this.txtPort.disableProperty().bind(this.tglProxy.selectedProperty().not());
        this.txtUser.disableProperty().bind(this.tglProxy.selectedProperty().not());
        this.txtPwd.disableProperty().bind(this.tglProxy.selectedProperty().not());
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        int row = 0;
        gridPane.add(this.tglProxy, 0, row, 2, 1);
        gridPane.add(btnHelpGeo, 2, row);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(new Label("Host:"), 0, ++row);
        gridPane.add(this.txtServer, 1, row);
        gridPane.add(new Label("Port:"), 0, ++row);
        gridPane.add(this.txtPort, 1, row);
        gridPane.add(new Label("User:"), 0, ++row);
        gridPane.add(this.txtUser, 1, row);
        gridPane.add(new Label("Passwort:"), 0, ++row);
        gridPane.add(this.txtPwd, 1, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        HBox hBox = new HBox();
        hBox.getStyleClass().add("extra-pane");
        hBox.setPadding(new Insets(10.0));
        hBox.setMaxWidth(Double.MAX_VALUE);
        hBox.getChildren().add(new Label("\u00c4nderungen in diesem Tab\nwirken sich erst nach dem Neustart des Programms aus"));
        hBox.setMinHeight(Double.NEGATIVE_INFINITY);
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        vBox.getChildren().addAll((Node[])new Node[]{gridPane, hBox});
        VBox.setVgrow(gridPane, Priority.ALWAYS);
        TitledPane tpConfig = new TitledPane("Proxy", vBox);
        if (result != null) {
            result.add(tpConfig);
        }
        return tpConfig;
    }
}

