/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.ProgSave;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.P2ShutDown;
import java.util.Collection;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneProgs {
    private TextField txtFileManager = new TextField();
    private TextField txtFileManagerVideo = new TextField();
    private TextField txtFileManagerWeb = new TextField();
    private TextField txtSystemCall = new TextField();
    private CheckBox cbxSystemCallOn = new CheckBox("Den Systemaufruf nach der Wartezeit und dem Programmende, aufrufen");
    private final Stage stage;

    public PaneProgs(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.txtFileManager.textProperty().unbindBidirectional(ProgConfig.SYSTEM_PROG_OPEN_DIR);
        this.txtFileManagerVideo.textProperty().unbindBidirectional(ProgConfig.SYSTEM_PROG_PLAY_FILME);
        this.txtFileManagerWeb.textProperty().unbindBidirectional(ProgConfig.SYSTEM_PROG_OPEN_URL);
        this.txtSystemCall.textProperty().unbindBidirectional(ProgConfig.SYSTEM_SHUT_DOWN_CALL);
        this.cbxSystemCallOn.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SHUT_DOWN_CALL_ON);
    }

    public void make(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Programme", gridPane);
        result.add(tpConfig);
        this.addFilemanager(gridPane, 0);
        this.addVideoPlayer(gridPane, 1);
        this.addWebbrowser(gridPane, 2);
        this.addSystemCall(gridPane, 3);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow()});
    }

    private void addFilemanager(GridPane gridPane, int row) {
        this.txtFileManager.textProperty().bindBidirectional(ProgConfig.SYSTEM_PROG_OPEN_DIR);
        Button btnFile = new Button();
        btnFile.setOnAction(event -> P2DirFileChooser.FileChooserOpenFile(ProgData.getInstance().primaryStage, this.txtFileManager));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Einen Dateimanager manuell ausw\u00e4hlen"));
        Button btnHelp = P2Button.helpButton(this.stage, "Dateimanager", "In der Ansicht \"Downloads\" kann man \u00fcber das Kontextmen\u00fc den Downloadordner (Zielordner) des jeweiligen Downloads \u00f6ffnen. Normalerweise wird daf\u00fcr der Dateimanager des Betriebssystems gefunden und ge\u00f6ffnet. Klappt das nicht, kann hier ein Programm daf\u00fcr angegeben werden.\n");
        VBox vBox = new VBox(2.0);
        HBox hBox = new HBox(5.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.txtFileManager, btnFile, btnHelp});
        HBox.setHgrow(this.txtFileManager, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("Dateimanager zum \u00d6ffnen des Downloadordners"), hBox});
        gridPane.add(vBox, 0, row);
    }

    private void addVideoPlayer(GridPane gridPane, int row) {
        this.txtFileManagerVideo.textProperty().bindBidirectional(ProgConfig.SYSTEM_PROG_PLAY_FILME);
        Button btnFile = new Button();
        btnFile.setOnAction(event -> P2DirFileChooser.FileChooserOpenFile(ProgData.getInstance().primaryStage, this.txtFileManagerVideo));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Einen Videoplayer zum Abspielen der gespeicherten Filme ausw\u00e4hlen"));
        Button btnHelp = P2Button.helpButton(this.stage, "Videoplayer", "In der Ansicht \"Downloads\" kann man \u00fcber das Kontextmen\u00fc den gespeicherten Film in einem Videoplayer \u00f6ffnen. Normalerweise wird der Videoplayer des Betriebssystems gefunden und ge\u00f6ffnet. Klappt das nicht, kann hier ein Programm daf\u00fcr angegeben werden.\n");
        VBox vBox = new VBox(2.0);
        HBox hBox = new HBox(5.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.txtFileManagerVideo, btnFile, btnHelp});
        HBox.setHgrow(this.txtFileManagerVideo, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("Videoplayer zum Abspielen gespeicherter Filme"), hBox});
        gridPane.add(vBox, 0, row);
    }

    private void addWebbrowser(GridPane gridPane, int row) {
        this.txtFileManagerWeb.textProperty().bindBidirectional(ProgConfig.SYSTEM_PROG_OPEN_URL);
        Button btnFile = new Button();
        btnFile.setOnAction(event -> P2DirFileChooser.FileChooserOpenFile(ProgData.getInstance().primaryStage, this.txtFileManagerWeb));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Einen Webbrowser zum \u00d6ffnen von URLs ausw\u00e4hlen"));
        Button btnHelp = P2Button.helpButton(this.stage, "Webbrowser", "Wenn das Programm versucht, einen Link zu \u00f6ffnen (z.B. \"Anleitung im Web\" im Programm-Men\u00fc unter \"Hilfe\") und der Standardbrowser nicht startet, kann damit ein Programm (Firefox, Chromium, \u2026) ausgew\u00e4hlt und fest zugeordnet werden.\n");
        VBox vBox = new VBox(2.0);
        HBox hBox = new HBox(5.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.txtFileManagerWeb, btnFile, btnHelp});
        HBox.setHgrow(this.txtFileManagerWeb, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("Webbrowser zum \u00d6ffnen von URLs"), hBox});
        gridPane.add(vBox, 0, row);
    }

    private void addSystemCall(GridPane gridPane, int row) {
        this.txtSystemCall.textProperty().bindBidirectional(ProgConfig.SYSTEM_SHUT_DOWN_CALL);
        this.cbxSystemCallOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SHUT_DOWN_CALL_ON);
        Button btnHelp = P2Button.helpButton(this.stage, "Webbrowser", "Wird das Programm bei noch laufenden Downloads beendet, erscheint der \"Auf Downloads warten\" Dialog. Hier kann dann ausgew\u00e4hlt werden:\n\n-> Nicht beenden\n-> Beenden\n-> Warten\n\nWird \"Warten\" ausgew\u00e4hlt, beendet sich das Programm erst wenn alle Downloads erledigt sind. Nach dem Warten ist es dann m\u00f6glich, einen Systemaufruf abzusetzen. Gedacht ist das, um nach der Wartezeit das Programm zu beenden und den Rechner herunterzufahren. F\u00fcr Linux und Windows bringt das Programm die Standard-Befehle daf\u00fcr mit.\n\nDiese k\u00f6nnen aber auch angepasst werden. So ist es z.B. auch m\u00f6glich, einen ganz anderen Befehl oder ein eigenes Skript nach dem Warten auf die Downloads und dem Programmende, auszuf\u00fchren.\n");
        Button btnTest = new Button("Testen");
        btnTest.setOnAction(a -> {
            ProgSave.saveAll();
            P2ShutDown.shutDown(ProgConfig.SYSTEM_SHUT_DOWN_CALL.getValueSafe());
        });
        Button btnStandard = new Button("Standard setzen");
        btnStandard.setOnAction(a -> this.txtSystemCall.setText(P2ShutDown.getShutDownCommand()));
        VBox vBox = new VBox(2.0);
        HBox hBox = new HBox(5.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.txtSystemCall, btnTest, btnStandard, btnHelp});
        HBox.setHgrow(this.txtSystemCall, Priority.ALWAYS);
        HBox hBoxOn = new HBox();
        hBoxOn.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(20), this.cbxSystemCallOn});
        vBox.getChildren().addAll((Node[])new Node[]{new Label("Systemaufruf nach dem \"Auf Downloads warten\" Dialog"), hBox, hBoxOn});
        gridPane.add(vBox, 0, row);
    }
}

