/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.mediadb.MediaCollectionData;
import de.p2tools.mtplayer.controller.mediadb.MediaDataWorker;
import de.p2tools.mtplayer.gui.tools.HelpText;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2RowFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.binding.Bindings;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneMediaDataPath {
    private final TableView<MediaCollectionData> tableView = new TableView();
    private final boolean external;
    private final TextField txtCollectionName = new TextField();
    private final TextField txtPath = new TextField();
    private final Button btnPath = new Button("");
    private final ProgData progData;
    private final Stage stage;
    private MediaCollectionData collectionDataOld = null;
    private boolean mediaChanged = false;

    public PaneMediaDataPath(Stage stage, boolean external) {
        this.stage = stage;
        this.external = external;
        this.progData = ProgData.getInstance();
    }

    public void make(Collection<TitledPane> result) {
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane(this.external ? "Externe Medien" : "Interne Medien", vBox);
        result.add(tpConfig);
        this.initTable(vBox);
        this.makeButton(vBox);
        this.makeGrid(vBox);
    }

    public void close() {
        this.progData.mediaCollectionDataList.clearUndoList();
        if (this.mediaChanged) {
            MediaDataWorker.createMediaDb();
        }
    }

    private void initTable(VBox vBox) {
        this.tableView.setMinHeight(200.0);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.tableView.setEditable(true);
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellValueFactory(new PropertyValueFactory("collectionName"));
        TableColumn pathColumn = new TableColumn("Pfad");
        pathColumn.setCellValueFactory(new PropertyValueFactory("path"));
        TableColumn countColumn = new TableColumn("Anzahl");
        countColumn.setCellValueFactory(new PropertyValueFactory("count"));
        countColumn.getStyleClass().add("alignCenterRightPadding_25");
        nameColumn.prefWidthProperty().bind(this.tableView.widthProperty().multiply(0.3));
        pathColumn.prefWidthProperty().bind(this.tableView.widthProperty().multiply(0.4));
        countColumn.prefWidthProperty().bind(this.tableView.widthProperty().multiply(0.2));
        this.tableView.getColumns().addAll(nameColumn, pathColumn, countColumn);
        SortedList<MediaCollectionData> sortedList = this.external ? this.progData.mediaCollectionDataList.getSortedListExternal() : this.progData.mediaCollectionDataList.getSortedListInternal();
        sortedList.comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.setItems(sortedList);
        this.txtCollectionName.disableProperty().bind(this.tableView.getSelectionModel().selectedItemProperty().isNull());
        this.txtPath.disableProperty().bind(this.tableView.getSelectionModel().selectedItemProperty().isNull());
        this.btnPath.disableProperty().bind(this.tableView.getSelectionModel().selectedItemProperty().isNull());
        this.tableView.setRowFactory(new P2RowFactory());
        this.tableView.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> {
            if (this.collectionDataOld != null) {
                this.txtCollectionName.textProperty().unbindBidirectional(this.collectionDataOld.collectionNameProperty());
                this.txtPath.textProperty().unbindBidirectional(this.collectionDataOld.pathProperty());
                this.txtCollectionName.setText("");
                this.txtPath.setText("");
            }
            if (n != null) {
                this.collectionDataOld = n;
                this.txtCollectionName.textProperty().bindBidirectional(n.collectionNameProperty());
                this.txtPath.textProperty().bindBidirectional(n.pathProperty());
            }
        });
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                ContextMenu contextMenu = this.getContextMenu();
                this.tableView.setContextMenu(contextMenu);
            }
        });
        VBox.setVgrow(this.tableView, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{this.tableView});
    }

    private ContextMenu getContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem miUndo = new MenuItem("Gel\u00f6schte wieder anlegen");
        miUndo.setOnAction(a -> ProgData.getInstance().mediaCollectionDataList.undoData(this.external));
        miUndo.setDisable(ProgData.getInstance().mediaCollectionDataList.getUndoList(this.external).isEmpty());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miUndo});
        return contextMenu;
    }

    private void makeButton(VBox vBox) {
        HBox hBox = new HBox(5.0);
        Button btnHelp = P2Button.helpButton(this.stage, this.external ? "Externe Mediensammlungen verwalten" : "Interne Mediensammlungen verwalten", this.external ? HelpText.EXTERN_MEDIA_COLLECTION : HelpText.INTERN_MEDIA_COLLECTION);
        Button btnDel = new Button("");
        btnDel.setTooltip(new Tooltip("Die markierte Sammlung wird gel\u00f6scht."));
        btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        btnDel.disableProperty().bind(Bindings.isEmpty(this.tableView.getSelectionModel().getSelectedItems()).or(this.progData.mediaDataList.searchingProperty()));
        btnDel.setOnAction(a -> this.delete());
        Button btnAdd = new Button("");
        btnAdd.setGraphic(ProgIcons.ICON_BUTTON_ADD.getImageView());
        if (this.external) {
            btnAdd.setTooltip(new Tooltip("Eine neue Sammlung wird angelegt und vom angegebenen Pfad eingelesen."));
        } else {
            btnAdd.setTooltip(new Tooltip("Eine neue Sammlung wird angelegt."));
        }
        btnAdd.setOnAction(a -> this.add());
        Button btnUpdate = new Button("");
        btnUpdate.setTooltip(new Tooltip("Die markierte Sammlung wird neu eingelesen."));
        btnUpdate.setGraphic(ProgIcons.ICON_BUTTON_RESET.getImageView());
        btnUpdate.disableProperty().bind(Bindings.isEmpty(this.tableView.getSelectionModel().getSelectedItems()).or(this.progData.mediaDataList.searchingProperty()));
        btnUpdate.setOnAction(a -> this.update());
        hBox.getChildren().addAll((Node[])new Node[]{btnUpdate});
        hBox.getChildren().addAll((Node[])new Node[]{btnDel, btnAdd, P2GuiTools.getHBoxGrower(), btnHelp});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
    }

    private void update() {
        MediaCollectionData mediaCollectionData = (MediaCollectionData)this.tableView.getSelectionModel().getSelectedItem();
        File file = new File(mediaCollectionData.getPath());
        if (!file.exists()) {
            P2Alert.showErrorAlert("Pfad existiert nicht!", "Der Pfad der Sammlung:" + P2LibConst.LINE_SEPARATOR + mediaCollectionData.getPath() + P2LibConst.LINE_SEPARATOR + "existiert nicht. Die Sammlung kann nicht eingelesen werden");
            return;
        }
        MediaDataWorker.updateCollection(mediaCollectionData);
    }

    private void makeGrid(VBox vBox) {
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add("extra-pane");
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        this.btnPath.setTooltip(new Tooltip("Einen Pfad zum Einlesen einer neuen Sammlung ausw\u00e4hlen."));
        this.btnPath.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        this.btnPath.setOnAction(event -> {
            P2DirFileChooser.DirChooser(ProgData.getInstance().primaryStage, this.txtPath);
            if (this.txtCollectionName.getText().isEmpty()) {
                this.txtCollectionName.setText(this.txtPath.getText());
            }
        });
        int row = 0;
        gridPane.add(new Label("Name:"), 0, row);
        gridPane.add(this.txtCollectionName, 1, row);
        gridPane.add(new Label("Pfad:"), 0, ++row);
        gridPane.add(this.txtPath, 1, row);
        gridPane.add(this.btnPath, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().addAll((Node[])new Node[]{gridPane});
    }

    private void delete() {
        ArrayList<MediaCollectionData> sels = new ArrayList<MediaCollectionData>(this.tableView.getSelectionModel().getSelectedItems());
        if (sels.isEmpty()) {
            P2Alert.showInfoNoSelection();
            return;
        }
        MediaDataWorker.removeMediaCollection(sels, this.external);
        this.tableView.getSelectionModel().clearSelection();
    }

    private void add() {
        MediaCollectionData mediaCollectionData = this.progData.mediaCollectionDataList.addNewMediaCollectionData(this.external);
        this.tableView.getSelectionModel().clearSelection();
        this.tableView.getSelectionModel().select(mediaCollectionData);
        this.tableView.scrollTo(mediaCollectionData);
        if (!this.external) {
            this.mediaChanged = true;
        }
    }
}

