/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.mediadb.MediaDataWorker;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.io.File;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.StringConverter;

public class PaneMediaConfig {
    private final RadioButton rbWithOutSuff = new RadioButton("keine Dateien mit diesem Suffix (z.B.: txt,xml,jpg)");
    private final RadioButton rbWithSuff = new RadioButton("nur Dateien mit diesem Suffix (z.B.: mp4, m4v)");
    private final TextField txtSuff = new TextField();
    private final P2ToggleSwitch tglNoHiddenFiles = new P2ToggleSwitch("keine versteckten Dateien suchen:");
    private final Slider slFileSize = new Slider();
    private final Label lblFileSize = new Label();
    private final String TXT_ALL = "alle Dateien";
    private int intValue = 0;
    private final TextField txtExport = new TextField();
    private final Button btnExport = new Button("exportieren");
    private final Button btnExportFile = new Button("");
    private final RadioButton rbIntern = new RadioButton("interne");
    private final RadioButton rbExtern = new RadioButton("externe");
    private final RadioButton rbInternExtern = new RadioButton("beide");
    BooleanProperty propExportIntern = ProgConfig.MEDIA_DB_EXPORT_INTERN;
    BooleanProperty propExportExtern = ProgConfig.MEDIA_DB_EXPORT_EXTERN;
    BooleanProperty propExportInternExtern = ProgConfig.MEDIA_DB_EXPORT_INTERN_EXTERN;
    StringProperty propExportFile = ProgConfig.MEDIA_DB_EXPORT_FILE;
    BooleanProperty propSuff = ProgConfig.MEDIA_DB_WITH_OUT_SUFFIX;
    StringProperty propSuffStr = ProgConfig.MEDIA_DB_SUFFIX;
    BooleanProperty propNoHiddenFiles = ProgConfig.MEDIA_DB_NO_HIDDEN_FILES;
    private final ProgData progData;
    private final Stage stage;

    public PaneMediaConfig(Stage stage) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
    }

    public void make(Collection<TitledPane> result) {
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Allgemein", vBox);
        result.add(tpConfig);
        Button btnHelp = P2Button.helpButton(this.stage, "Mediensammlungen verwalten", "Hier kann eine Mediensammlung angelegt werden. Das ist eine Liste der bereits vorhandenen Filme.\n\nVor dem Download eines Films kann darin der Filmtitel gesucht werden, um doppelte Downloads zu vermeiden. Bei Filmen in den Ansichten \"Filme\" und \"Downloads\" geht dies mit dem Kontextmen\u00fc \"Titel in der Mediensammlung suchen\". Ein Dialog listet dann gefundene Filmtitel aus der Mediensammlung auf.\nIm Tab Filme/Download werden die Medien auch unter der Tabelle mit angezeigt.\n\nHier im Konfigurations-Dialog werden die Ordner angegeben, deren Filmdateien in die Mediensammlung aufgenommen werden.\n\n\"Interne Medien\": Die angegebenen Pfade werden beim Programmstart durchsucht, sie m\u00fcssen deshalb verf\u00fcgbar sein, w\u00e4hrend das Programm l\u00e4uft. Die Mediensammlung ist daher f\u00fcr interne Medien immer aktuell.\n\n\"Externe Medien\": Ihr Inhalt an Mediendateien wird beim Hinzuf\u00fcgen zur Liste hinzugef\u00fcgt und steht dann dauerhaft im Programm und bei der Suche in der Mediensammlung zur Verf\u00fcgung. Es ist daher nicht n\u00f6tig, dass externe Medien beim Programmstart vorhanden sind.\n\n\"Keine Dateien mit diesem Suffix\" oder \"nur Dateien mit diesem Suffix\": Bestimmt durch die angegebenen Suffixe welche Dateien in die Mediensammlung aufgenommen werden. Mehrere Suffixe k\u00f6nnen durch Komma getrennt angegeben werden, z.B. 'txt,xml'. Ist die Zeile leer, werden alle Dateien aufgenommen.\n\n\"Keine versteckten Dateien suchen:\" Unabh\u00e4ngig vom Suffix werden versteckte Dateien nicht in die Mediensammlung aufgenommen.\n\n\"Nur Dateien mit Mindestgr\u00f6\u00dfe suchen:\" Kleinere Dateien werden nicht in die Mediensammlung aufgenommen.\n\nMit dem \"Export\"-Button kann die komplette Mediensammlung in eine Textdatei geschrieben werden.\n");
        this.btnExportFile.setTooltip(new Tooltip("Einen Ordner f\u00fcr den Export ausw\u00e4hlen"));
        this.btnExportFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        ToggleGroup tg = new ToggleGroup();
        this.rbWithOutSuff.setToggleGroup(tg);
        this.rbWithSuff.setToggleGroup(tg);
        ToggleGroup tgExport = new ToggleGroup();
        this.rbIntern.setToggleGroup(tgExport);
        this.rbExtern.setToggleGroup(tgExport);
        this.rbInternExtern.setToggleGroup(tgExport);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        int row = 0;
        gridPane.add(this.rbWithOutSuff, 0, row);
        gridPane.add(btnHelp, 1, row);
        GridPane.setHalignment(btnHelp, HPos.RIGHT);
        gridPane.add(this.rbWithSuff, 0, ++row);
        gridPane.add(this.txtSuff, 0, ++row, 2, 1);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(this.tglNoHiddenFiles, 0, ++row, 2, 1);
        Label lbl = new Label("alle Dateien");
        lbl.setVisible(false);
        gridPane.add(lbl, 1, ++row);
        gridPane.add(new Label("nur Dateien mit Mindestgr\u00f6\u00dfe suchen:"), 0, ++row);
        gridPane.add(this.lblFileSize, 1, row);
        GridPane.setHalignment(this.lblFileSize, HPos.RIGHT);
        gridPane.add(this.slFileSize, 0, ++row, 2, 1);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(new Label(" "), 0, ++row);
        HBox hBox = new HBox(5.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow(this.txtExport, Priority.ALWAYS);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("Datei:"), this.txtExport, this.btnExportFile});
        gridPane.add(new Label("Mediensammlung in eine Datei exportieren:"), 0, ++row);
        gridPane.add(hBox, 0, ++row, 2, 1);
        HBox hBoxExport = new HBox(5.0);
        Label lblExport = new Label("Datei:");
        lblExport.setVisible(false);
        hBoxExport.getChildren().addAll((Node[])new Node[]{lblExport, this.rbIntern, this.rbExtern, this.rbInternExtern});
        gridPane.add(hBoxExport, 0, ++row);
        gridPane.add(this.btnExport, 1, row);
        GridPane.setHalignment(this.btnExport, HPos.RIGHT);
        for (int i = 0; i < gridPane.getRowCount(); ++i) {
            RowConstraints rowC = new RowConstraints();
            rowC.setValignment(VPos.CENTER);
            gridPane.getRowConstraints().add(rowC);
        }
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        vBox.getChildren().addAll((Node[])new Node[]{gridPane});
        this.initFileSizeSlider();
        this.initProp();
        this.initAction();
    }

    public void close() {
        this.rbWithOutSuff.selectedProperty().unbindBidirectional(this.propSuff);
        this.tglNoHiddenFiles.selectedProperty().unbindBidirectional(this.propNoHiddenFiles);
        this.rbIntern.selectedProperty().unbindBidirectional(this.propExportIntern);
        this.rbExtern.selectedProperty().unbindBidirectional(this.propExportExtern);
        this.rbInternExtern.selectedProperty().unbindBidirectional(this.propExportInternExtern);
        this.txtSuff.textProperty().unbindBidirectional(this.propSuffStr);
        this.txtExport.textProperty().unbindBidirectional(this.propExportFile);
    }

    private void initProp() {
        this.rbWithSuff.setSelected(this.propSuff.getValue() == false);
        this.rbWithOutSuff.selectedProperty().bindBidirectional(this.propSuff);
        this.rbIntern.setSelected(this.propExportIntern.getValue());
        this.rbIntern.selectedProperty().bindBidirectional(this.propExportIntern);
        this.rbExtern.setSelected(this.propExportExtern.getValue());
        this.rbExtern.selectedProperty().bindBidirectional(this.propExportExtern);
        this.rbInternExtern.setSelected(this.propExportInternExtern.getValue());
        this.rbInternExtern.selectedProperty().bindBidirectional(this.propExportInternExtern);
        if (this.propExportFile.getValueSafe().isBlank()) {
            File initFile = new File(System.getProperty("user.home"), "MediaDB.txt");
            this.propExportFile.setValue(initFile.getAbsolutePath());
        }
        this.txtExport.textProperty().bindBidirectional(this.propExportFile);
        this.txtSuff.textProperty().bindBidirectional(this.propSuffStr);
        this.tglNoHiddenFiles.selectedProperty().bindBidirectional(this.propNoHiddenFiles);
    }

    private void initAction() {
        this.btnExportFile.setOnAction(event -> P2DirFileChooser.FileChooserSaveFile(ProgData.getInstance().primaryStage, this.txtExport));
        this.btnExport.setOnAction(a -> MediaDataWorker.exportMediaDB(this.progData.mediaDataList, this.txtExport.getText(), this.rbIntern.isSelected(), this.rbExtern.isSelected()));
    }

    private void initFileSizeSlider() {
        this.slFileSize.setPadding(new Insets(0.0, 10.0, 0.0, 5.0));
        this.slFileSize.setMin(0.0);
        this.slFileSize.setMax(20.0);
        this.slFileSize.setShowTickLabels(true);
        this.slFileSize.setMajorTickUnit(5.0);
        this.slFileSize.setMinorTickCount(2);
        this.slFileSize.setBlockIncrement(5.0);
        this.slFileSize.setLabelFormatter(new StringConverter<Double>(){

            @Override
            public String toString(Double x) {
                if (x == 0.0) {
                    return "alles";
                }
                return "" + x.intValue();
            }

            @Override
            public Double fromString(String string) {
                return null;
            }
        });
        this.slFileSize.setValue(ProgConfig.MEDIA_DB_FILE_SIZE_MBYTE.getValue().intValue());
        this.slFileSize.valueChangingProperty().addListener((observable2, oldvalue, newvalue) -> {
            if (!newvalue.booleanValue()) {
                ProgConfig.MEDIA_DB_FILE_SIZE_MBYTE.setValue(this.intValue);
            }
        });
        this.slFileSize.valueProperty().addListener((observable2, oldValue, newValue) -> {
            this.intValue = (int)Math.round(this.slFileSize.getValue());
            this.setLabelSlider();
        });
        this.setLabelSlider();
    }

    private void setLabelSlider() {
        if (this.intValue == 0) {
            this.lblFileSize.setText("alle Dateien");
        } else {
            this.lblFileSize.setText(this.intValue + " MB");
        }
    }
}

