/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.offer.OfferData;
import de.p2tools.mtplayer.controller.data.offer.PCellCheckBoxOfferData;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneFilter {
    private final TextField txtOffer = new TextField();
    private final CheckBox chkActive = new CheckBox();
    private final Label lblActive = new Label();
    private final GridPane gridPane = new GridPane();
    private final TableView<OfferData> tableView = new TableView();
    private final ObjectProperty<OfferData> offerDateProp = new SimpleObjectProperty<Object>(null);
    private final P2ToggleSwitch tglOffer = new P2ToggleSwitch("Vorschl\u00e4ge anzeigen");
    private final P2ToggleSwitch tglRegEx = new P2ToggleSwitch("Bei der Suche mit RegEx muss der Suchtext nur enthalten sein");
    private final Stage stage;

    public PaneFilter(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        ProgData.getInstance().offerList.getUndoList().clear();
        this.unbindText();
        this.tglOffer.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_USE_OFFERTABLE);
        this.tglRegEx.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_FILTER_REG_EX_ONLY_CONTAIN);
    }

    public void make(Collection<TitledPane> result) {
        VBox vBox = new VBox(10.0);
        vBox.setFillWidth(true);
        vBox.setPadding(new Insets(10.0));
        this.make(vBox);
        this.initTable(vBox);
        this.initBtn(vBox);
        this.addConfigs(vBox);
        TitledPane tpOffer = new TitledPane("Filter", vBox);
        result.add(tpOffer);
        tpOffer.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(tpOffer, Priority.ALWAYS);
    }

    private void make(VBox vBox) {
        Button btnHelp = P2Button.helpButton(this.stage, "Filtervorschl\u00e4ge", "Hier k\u00f6nnen Filter angelegt werden, die dann als Vorschlag bei einem Doppelklick auf ein Filterfeld eingetragen werden.\nIst nur ein Vorschlag vorhanden, wird er sofort eingetragen. Sind mehrere Vorschl\u00e4ge vorhanden, kann man in einem Dialog einen ausw\u00e4hlen.\n");
        Button btnHelpRegEx = P2Button.helpButton(this.stage, "Suche mit RegEx", "Suche mit RegEx\n-----------------\nNormalerweise muss bei der Suche mit RegEx der Filter genau mit dem gesuchten Text \u00fcbereinstimmen. Ist diese Option eingeschaltet, muss der Filter nur noch in dem gesuchten Text enthalten sein.\nIch suche nach \"#:Sport\", dann muss der gesuchte Text genau \"Sport\" sein. Mit dieser Option werden aber alle Texte gefunden, die \"Sport\" enthalten (z.B.: sportlich).\n");
        this.tglOffer.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_USE_OFFERTABLE);
        this.tglRegEx.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_FILTER_REG_EX_ONLY_CONTAIN);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        gridPane.add(this.tglRegEx, 0, 0);
        gridPane.add(btnHelpRegEx, 1, 0);
        gridPane.add(new Label(), 0, 1);
        gridPane.add(this.tglOffer, 0, 2);
        gridPane.add(btnHelp, 1, 2);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }

    private void initTable(VBox vBox) {
        TableColumn offerColumn = new TableColumn("Vorschlag");
        offerColumn.setCellValueFactory(new PropertyValueFactory("offer"));
        TableColumn activeColumn = new TableColumn("Aktiv");
        activeColumn.setCellValueFactory(new PropertyValueFactory("active"));
        activeColumn.setCellFactory(new PCellCheckBoxOfferData<S, T>().cellFactory);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.setMinHeight(200.0);
        this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.tableView.getColumns().addAll(offerColumn, activeColumn);
        this.tableView.setItems(ProgData.getInstance().offerList);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> Platform.runLater(this::setActOfferData));
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                ContextMenu contextMenu = this.getContextMenu();
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.disableProperty().bind(ProgConfig.SYSTEM_USE_OFFERTABLE.not());
        VBox.setVgrow(this.tableView, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{this.tableView});
    }

    private void initBtn(VBox vBox) {
        this.chkActive.selectedProperty().addListener((u, o, n) -> this.setLblText());
        Button btnDel = new Button("");
        btnDel.setTooltip(new Tooltip("Eintrag l\u00f6schen"));
        btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        btnDel.setOnAction(event -> {
            ObservableList sels = this.tableView.getSelectionModel().getSelectedItems();
            if (sels == null || sels.isEmpty()) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                ProgData.getInstance().offerList.addDataToUndoList(sels);
                ProgData.getInstance().offerList.removeAll(sels);
                this.tableView.getSelectionModel().clearSelection();
            }
        });
        Button btnNew = new Button("");
        btnNew.setTooltip(new Tooltip("Einen neuen Eintrag erstellen"));
        btnNew.setGraphic(ProgIcons.ICON_BUTTON_ADD.getImageView());
        btnNew.setOnAction(event -> {
            OfferData offerData = new OfferData();
            ProgData.getInstance().offerList.add(offerData);
            this.tableView.getSelectionModel().clearSelection();
            this.tableView.getSelectionModel().select(offerData);
            this.tableView.scrollTo(offerData);
        });
        Button btnUp = new Button("");
        btnUp.setTooltip(new Tooltip("Eintrag nach oben schieben"));
        btnUp.setGraphic(ProgIcons.ICON_BUTTON_MOVE_UP.getImageView());
        btnUp.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                int res = ProgData.getInstance().offerList.up(sel, true);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(res);
                this.tableView.scrollTo(res);
            }
        });
        Button btnDown = new Button("");
        btnDown.setTooltip(new Tooltip("Eintrag nach unten schieben"));
        btnDown.setGraphic(ProgIcons.ICON_BUTTON_MOVE_DOWN.getImageView());
        btnDown.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                int res = ProgData.getInstance().offerList.up(sel, false);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(res);
                this.tableView.scrollTo(res);
            }
        });
        Button btnTop = new Button();
        btnTop.setTooltip(new Tooltip("Eintrag an den Anfang verschieben"));
        btnTop.setGraphic(ProgIcons.ICON_BUTTON_MOVE_TOP.getImageView());
        btnTop.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                int res = ProgData.getInstance().offerList.top(sel, true);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(res);
                this.tableView.scrollTo(res);
            }
        });
        Button btnBottom = new Button();
        btnBottom.setTooltip(new Tooltip("Eintrag an das Ende verschieben"));
        btnBottom.setGraphic(ProgIcons.ICON_BUTTON_MOVE_BOTTOM.getImageView());
        btnBottom.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                int res = ProgData.getInstance().offerList.top(sel, false);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(res);
                this.tableView.scrollTo(res);
            }
        });
        Button btnReset = new Button("_Tabelle zur\u00fccksetzen");
        btnReset.setTooltip(new Tooltip("Alle Eintr\u00e4ge l\u00f6schen und Standardeintr\u00e4ge wieder herstellen"));
        btnReset.setOnAction(event -> {
            if (P2Alert.BUTTON.YES.equals((Object)P2Alert.showAlert_yes_no(this.stage, "Tabelle l\u00f6schen", "Alle Eintr\u00e4ge in der Tabelle werden gel\u00f6scht!", "Soll die Tabelle gel\u00f6scht und die Standardeintr\u00e4ge wieder eingef\u00fcgt werden?"))) {
                ProgData.getInstance().offerList.init();
            }
        });
        HBox hBox = new HBox();
        hBox.setSpacing(5.0);
        hBox.disableProperty().bind(ProgConfig.SYSTEM_USE_OFFERTABLE.not());
        hBox.getChildren().addAll((Node[])new Node[]{btnNew, btnDel, P2GuiTools.getVDistance(10), btnTop, btnUp, btnDown, btnBottom, P2GuiTools.getHBoxGrower(), btnReset});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
    }

    private ContextMenu getContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem miUndo = new MenuItem("Gel\u00f6schte wieder anlegen");
        miUndo.setOnAction(a -> ProgData.getInstance().offerList.undoData());
        miUndo.setDisable(ProgData.getInstance().offerList.getUndoList().isEmpty());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miUndo});
        return contextMenu;
    }

    private void addConfigs(VBox vBox) {
        this.gridPane.getStyleClass().add("extra-pane");
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(10.0));
        int row = 0;
        this.gridPane.add(new Label("Vorschlag: "), 0, row);
        this.gridPane.add(this.txtOffer, 1, row);
        this.gridPane.setAlignment(Pos.CENTER_RIGHT);
        this.gridPane.add(new Label("Aktiv:"), 0, ++row);
        HBox hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.chkActive, this.lblActive});
        this.gridPane.add(hBox, 1, row);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().add(this.gridPane);
        this.gridPane.setDisable(true);
        this.gridPane.disableProperty().bind(Bindings.createBooleanBinding(() -> this.offerDateProp.getValue() == null, this.offerDateProp).or(ProgConfig.SYSTEM_USE_OFFERTABLE.not()));
    }

    private void setActOfferData() {
        OfferData selectedItem = (OfferData)this.tableView.getSelectionModel().getSelectedItem();
        if (selectedItem == this.offerDateProp.getValue()) {
            return;
        }
        this.unbindText();
        this.offerDateProp.setValue(selectedItem);
        if (this.offerDateProp.getValue() != null) {
            this.txtOffer.textProperty().bindBidirectional(((OfferData)this.offerDateProp.getValue()).offerProperty());
            this.chkActive.selectedProperty().bindBidirectional(((OfferData)this.offerDateProp.getValue()).activeProperty());
        }
        this.setLblText();
    }

    private void unbindText() {
        if (this.offerDateProp.getValue() != null) {
            this.txtOffer.textProperty().unbindBidirectional(((OfferData)this.offerDateProp.getValue()).offerProperty());
            this.chkActive.selectedProperty().unbindBidirectional(((OfferData)this.offerDateProp.getValue()).activeProperty());
        }
        this.txtOffer.setText("");
        this.chkActive.setSelected(false);
    }

    private void setLblText() {
        if (this.offerDateProp.getValue() != null) {
            this.lblActive.setText(((OfferData)this.offerDateProp.getValue()).isActive() ? "" : "Der Eintrag wird nicht verwendet");
        } else {
            this.lblActive.setText("");
        }
    }
}

