/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.utdata.UtData;
import de.p2tools.mtplayer.controller.load.LoadAudioFactory;
import de.p2tools.mtplayer.controller.load.LoadFilmFactory;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneFilmUt {
    private final P2ToggleSwitch tglRemove;
    private final ComboBox<String> cboSender = new ComboBox();
    private final TextField txtTitle = new TextField();
    private final GridPane gridPane = new GridPane();
    private final TableView<UtData> tableView = new TableView();
    private final ObjectProperty<UtData> utDateProp = new SimpleObjectProperty<Object>(null);
    private final ChangeListener<String> changeListener;
    private final Stage stage;
    private final boolean ut;

    public PaneFilmUt(Stage stage, boolean ut) {
        this.stage = stage;
        this.ut = ut;
        this.tglRemove = new P2ToggleSwitch(ut ? "Filme mit Untertitel markieren" : "Filme markieren");
        this.changeListener = (observableValue, s, t1) -> {
            if (this.utDateProp.getValue() != null) {
                ((UtData)this.utDateProp.getValue()).setChannel((String)this.cboSender.getValue());
            }
        };
    }

    public void close() {
        this.cboSender.getSelectionModel().selectedItemProperty().removeListener(this.changeListener);
        if (this.ut) {
            ProgData.getInstance().utDataList.getUndoList().clear();
        } else {
            ProgData.getInstance().markDataList.getUndoList().clear();
        }
        this.unbindText();
        this.tglRemove.selectedProperty().unbindBidirectional(this.ut ? ProgConfig.SYSTEM_FILMLIST_MARK_UT : ProgConfig.SYSTEM_FILMLIST_MARK);
        this.cleanList();
    }

    public void make(Collection<TitledPane> result) {
        VBox vBox = new VBox(10.0);
        vBox.setFillWidth(true);
        vBox.setPadding(new Insets(10.0));
        this.initTop(vBox);
        this.initTable(vBox);
        this.initButton(vBox);
        this.initConfigs(vBox);
        this.addLoadFilmList(vBox);
        TitledPane tpReplace = new TitledPane(this.ut ? "Beitr\u00e4ge mit Untertitel markieren" : "Beitr\u00e4ge markieren", vBox);
        result.add(tpReplace);
        tpReplace.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(tpReplace, Priority.ALWAYS);
    }

    private void cleanList() {
        if (this.ut) {
            ProgData.getInstance().utDataList.removeIf(utData -> utData.getTitle().isEmpty());
        } else {
            ProgData.getInstance().markDataList.removeIf(utData -> utData.getTitle().isEmpty());
        }
    }

    private void initTop(VBox vBox) {
        Button btnHelpMark;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        if (this.ut) {
            this.tglRemove.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_FILMLIST_MARK_UT);
            btnHelpMark = P2Button.helpButton(this.stage, "Filme mit Untertitel markieren", "In der Filmliste sind Filme die keine Untertitel-Datei haben. Bei denen ist der Untertitel im Film selbst eingetragen. Diese Filme k\u00f6nnen auch als UT markiert werden. Hier kann vorgegeben werden, welche Filmtitel als UT markiert werden sollen. Mit dem Filmfilter \"UT\" werden dann auch diese Filme gefunden.\n\nDas Feld \"Sender\" darf leer sein, im \"Titel\" muss immer etwas eingetragen sein. Der in den Feldern eingetragene Text muss dann im jeweiligen Film (Sender, Titel) enthalten sein. \"ARTE\" sucht in allen ARTE-Sendern, \"ARTE.DE\" nur in ARTE.DE. Gro\u00df- und Kleinschreibung wird mit ausgewertet, muss also passen!");
        } else {
            this.tglRemove.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_FILMLIST_MARK);
            btnHelpMark = P2Button.helpButton(this.stage, "Filme markieren", "Hier kann vorgegeben werden, welche Filmtitel markiert werden sollen. Z.B. mit dem Filmfilter \"Geb\u00e4rdensprache\" werden dann diese Filme markiert und gefunden.\n\nDas Feld \"Sender\" darf leer sein, im \"Titel\" muss immer etwas eingetragen sein. Der in den Feldern eingetragene Text muss dann im jeweiligen Film (Sender, Titel) enthalten sein. \"ARTE\" sucht in allen ARTE-Sendern, \"ARTE.DE\" nur in ARTE.DE. Gro\u00df- und Kleinschreibung wird mit ausgewertet, muss also passen!");
        }
        int row = 0;
        gridPane.add(this.tglRemove, 0, row, 2, 1);
        gridPane.add(btnHelpMark, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
        vBox.setPadding(new Insets(10.0));
        vBox.getChildren().addAll((Node[])new Node[]{gridPane});
    }

    private void initTable(VBox vBox) {
        ScrollPane scrollPane = new ScrollPane();
        TableColumn channelColumn = new TableColumn("Sender");
        channelColumn.setCellValueFactory(new PropertyValueFactory("channel"));
        TableColumn titleColumn = new TableColumn("Titel");
        titleColumn.setCellValueFactory(new PropertyValueFactory("title"));
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.setMinHeight(200.0);
        this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.tableView.getColumns().addAll(channelColumn, titleColumn);
        this.tableView.setItems(this.ut ? ProgData.getInstance().utDataList : ProgData.getInstance().markDataList);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> Platform.runLater(this::setActReplaceData));
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                ContextMenu contextMenu = this.getContextMenu();
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.disableProperty().bind(this.ut ? ProgConfig.SYSTEM_FILMLIST_MARK_UT.not() : ProgConfig.SYSTEM_FILMLIST_MARK.not());
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setContent(this.tableView);
        VBox.setVgrow(scrollPane, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{scrollPane});
    }

    private void initButton(VBox vBox) {
        Button btnDel = new Button("");
        btnDel.setTooltip(new Tooltip("Eintrag l\u00f6schen"));
        btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        btnDel.setOnAction(event -> {
            ObservableList sels = this.tableView.getSelectionModel().getSelectedItems();
            if (sels == null || sels.isEmpty()) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                if (this.ut) {
                    ProgData.getInstance().utDataList.addDataToUndoList(sels);
                    ProgData.getInstance().utDataList.removeAll(sels);
                } else {
                    ProgData.getInstance().markDataList.addDataToUndoList(sels);
                    ProgData.getInstance().markDataList.removeAll(sels);
                }
                this.tableView.getSelectionModel().clearSelection();
            }
        });
        Button btnNew = new Button("");
        btnNew.setTooltip(new Tooltip("Einen neuen Eintrag erstellen"));
        btnNew.setGraphic(ProgIcons.ICON_BUTTON_ADD.getImageView());
        btnNew.setOnAction(event -> {
            UtData utData = new UtData();
            if (this.ut) {
                ProgData.getInstance().utDataList.add(utData);
            } else {
                ProgData.getInstance().markDataList.add(utData);
            }
            this.tableView.getSelectionModel().clearSelection();
            this.tableView.getSelectionModel().select(utData);
            this.tableView.scrollTo(utData);
        });
        Button btnUp = new Button("");
        btnUp.setTooltip(new Tooltip("Eintrag nach oben schieben"));
        btnUp.setGraphic(ProgIcons.ICON_BUTTON_MOVE_UP.getImageView());
        btnUp.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                int res = this.ut ? ProgData.getInstance().utDataList.up(sel, true) : ProgData.getInstance().markDataList.up(sel, true);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(res);
                this.tableView.scrollTo(res);
            }
        });
        Button btnDown = new Button("");
        btnDown.setTooltip(new Tooltip("Eintrag nach unten schieben"));
        btnDown.setGraphic(ProgIcons.ICON_BUTTON_MOVE_DOWN.getImageView());
        btnDown.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                int res = this.ut ? ProgData.getInstance().utDataList.up(sel, false) : ProgData.getInstance().markDataList.up(sel, false);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(res);
                this.tableView.scrollTo(res);
            }
        });
        Button btnClean = new Button("Tabelle _aufr\u00e4umen");
        btnClean.setTooltip(new Tooltip("Eintr\u00e4ge mit leerem Titel werden gel\u00f6scht"));
        btnClean.setOnAction(a -> this.cleanList());
        Button btnReset = new Button("_Tabelle zur\u00fccksetzen");
        btnReset.setTooltip(new Tooltip("Alle Eintr\u00e4ge l\u00f6schen und Standardeintr\u00e4ge wieder herstellen"));
        btnReset.setOnAction(event -> {
            if (this.ut) {
                ProgData.getInstance().utDataList.init(true);
            } else {
                ProgData.getInstance().markDataList.init(false);
            }
        });
        HBox hBox = new HBox();
        hBox.setSpacing(5.0);
        if (this.ut) {
            hBox.disableProperty().bind(ProgConfig.SYSTEM_FILMLIST_MARK_UT.not());
        } else {
            hBox.disableProperty().bind(ProgConfig.SYSTEM_FILMLIST_MARK.not());
        }
        hBox.getChildren().addAll((Node[])new Node[]{btnNew, btnDel, P2GuiTools.getVDistance(10), btnUp, btnDown, P2GuiTools.getHBoxGrower(), btnClean, btnReset});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
    }

    private ContextMenu getContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem miUndo = new MenuItem("Gel\u00f6schte wieder anlegen");
        if (this.ut) {
            miUndo.setOnAction(a -> ProgData.getInstance().utDataList.undoData());
            miUndo.setDisable(ProgData.getInstance().utDataList.getUndoList().isEmpty());
        } else {
            miUndo.setOnAction(a -> ProgData.getInstance().markDataList.undoData());
            miUndo.setDisable(ProgData.getInstance().markDataList.getUndoList().isEmpty());
        }
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miUndo});
        return contextMenu;
    }

    private void initConfigs(VBox vBox) {
        this.cboSender.setItems(ThemeListFactory.allChannelListFilm);
        this.cboSender.getSelectionModel().select(0);
        this.cboSender.setEditable(true);
        this.cboSender.getSelectionModel().selectedItemProperty().addListener(this.changeListener);
        this.gridPane.getStyleClass().add("extra-pane");
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(10.0));
        this.gridPane.add(new Label("Sender: "), 0, 0);
        this.gridPane.add(this.cboSender, 1, 0);
        this.gridPane.add(new Label("Titel: "), 0, 1);
        this.gridPane.add(this.txtTitle, 1, 1);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().add(this.gridPane);
        this.gridPane.setDisable(true);
        if (this.ut) {
            this.gridPane.disableProperty().bind(Bindings.createBooleanBinding(() -> this.utDateProp.getValue() == null, this.utDateProp).or(ProgConfig.SYSTEM_FILMLIST_MARK_UT.not()));
        } else {
            this.gridPane.disableProperty().bind(Bindings.createBooleanBinding(() -> this.utDateProp.getValue() == null, this.utDateProp).or(ProgConfig.SYSTEM_FILMLIST_MARK.not()));
        }
    }

    private void addLoadFilmList(VBox vBox) {
        Button btnLoadAudio = new Button("_Audioliste mit diesen Einstellungen neu laden");
        btnLoadAudio.setTooltip(new Tooltip("Eine komplette neue Audioliste laden.\nGe\u00e4nderte Einstellungen f\u00fcr das Laden der Audioliste werden so sofort \u00fcbernommen"));
        btnLoadAudio.setOnAction(event -> LoadAudioFactory.loadAudioListFromWeb(true, true));
        btnLoadAudio.setMaxWidth(Double.MAX_VALUE);
        btnLoadAudio.disableProperty().bind(ProgConfig.SYSTEM_USE_AUDIOLIST.not());
        HBox.setHgrow(btnLoadAudio, Priority.ALWAYS);
        Button btnLoadFilm = new Button("_Filmliste mit diesen Einstellungen neu laden");
        btnLoadFilm.setTooltip(new Tooltip("Eine komplette neue Filmliste laden.\nGe\u00e4nderte Einstellungen f\u00fcr das Laden der Filmliste werden so sofort \u00fcbernommen"));
        btnLoadFilm.setOnAction(event -> LoadFilmFactory.loadFilmListFromWeb(true, true));
        btnLoadFilm.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(btnLoadFilm, Priority.ALWAYS);
        HBox hBoxBtn = new HBox(5.0);
        hBoxBtn.setAlignment(Pos.CENTER_RIGHT);
        hBoxBtn.getChildren().addAll((Node[])new Node[]{btnLoadAudio, btnLoadFilm});
        vBox.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVBoxGrower(), hBoxBtn});
    }

    private void setActReplaceData() {
        UtData utData = (UtData)this.tableView.getSelectionModel().getSelectedItem();
        if (utData == this.utDateProp.getValue()) {
            return;
        }
        this.unbindText();
        this.utDateProp.setValue(utData);
        if (this.utDateProp.getValue() != null) {
            this.cboSender.getSelectionModel().select(((UtData)this.utDateProp.getValue()).getChannel());
            this.cboSender.getEditor().textProperty().bindBidirectional(((UtData)this.utDateProp.getValue()).channelProperty());
            this.txtTitle.textProperty().bindBidirectional(((UtData)this.utDateProp.getValue()).titleProperty());
        }
    }

    private void unbindText() {
        if (this.utDateProp.getValue() != null) {
            this.txtTitle.textProperty().unbindBidirectional(((UtData)this.utDateProp.getValue()).titleProperty());
            this.cboSender.getEditor().textProperty().unbindBidirectional(((UtData)this.utDateProp.getValue()).channelProperty());
        }
        this.txtTitle.setText("");
    }
}

