/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.load.LoadAudioFactory;
import de.p2tools.mtplayer.controller.load.LoadFilmFactory;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2Text;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneFilmLoad {
    private final P2ToggleSwitch tglUseLive = new P2ToggleSwitch("");
    private final P2ToggleSwitch tglUseAudio = new P2ToggleSwitch("");
    private final P2ToggleSwitch tglLoadFilm = new P2ToggleSwitch("Filmliste/Audioliste beim Programmstart neu laden");
    private final P2ToggleSwitch tglLoadNewList = new P2ToggleSwitch("Neue Filmlisten immer sofort laden");
    private final BooleanProperty diacriticChanged;
    private final ProgData progData;
    private final Stage stage;

    public PaneFilmLoad(Stage stage, ProgData progData, BooleanProperty diacriticChanged) {
        this.stage = stage;
        this.diacriticChanged = diacriticChanged;
        this.progData = progData;
    }

    public void close() {
        this.tglUseLive.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_USE_LIVE);
        this.tglUseAudio.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_USE_AUDIOLIST);
        this.tglLoadFilm.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_ON_PROGRAMSTART);
        this.tglLoadNewList.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_LOAD_NEW_FILMLIST_IMMEDIATELY);
    }

    public TitledPane make(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        this.tglUseLive.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_USE_LIVE);
        this.tglUseAudio.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_USE_AUDIOLIST);
        this.tglLoadFilm.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_ON_PROGRAMSTART);
        this.tglLoadNewList.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_LOAD_NEW_FILMLIST_IMMEDIATELY);
        this.tglLoadNewList.disableProperty().bind(this.tglLoadFilm.selectedProperty().not());
        this.tglLoadFilm.selectedProperty().addListener((u, o, n) -> {
            if (!this.tglLoadFilm.isSelected()) {
                this.tglLoadNewList.setSelected(false);
            }
        });
        Button btnHelpLive = P2Button.helpButton(this.stage, "Live-Suche im Programm verwenden", "Hier kann festgelegt werden, ob die Live-Suche im Programm verwendet werden soll. Der Tab f\u00fcr die Live-Suche wird dann ein/ausgeblendet.\n");
        Button btnHelpUse = P2Button.helpButton(this.stage, "Audioliste im Programm verwenden", "Hier kann festgelegt werden, ob die Beitr\u00e4ge der ARD-Audiothek im Programm angezeigt/verwendet werden sollen. Der Tab f\u00fcr die Audiothek wird dann ein/ausgeblendet und es werden keine Beitr\u00e4ge daraus geladen.\n");
        Button btnHelpLoadFilm = P2Button.helpButton(this.stage, "Filmliste/Audioliste laden", "Audioliste\nDie Audioliste wird beim Programmstart automatisch geladen, wenn sie nicht von \"heute\" ist. Sie kann auch \u00fcber den Button \"Filmliste\" aktualisiert werden.\n\nFilmliste\nDie Filmliste wird beim Programmstart automatisch geladen, wenn sie \u00e4lter als 3 Stunden ist. Sie kann auch \u00fcber den Button \"Filmliste\" aktualisiert werden.\n\nZum Update werden dann nur noch Differenzlisten geladen (diese enthalten nur neu hinzugekommene Filme).\n");
        Button btnHelpNewList = P2Button.helpButton(this.stage, "Filmliste laden", "Wenn es eine neue Filmliste gibt, wird sie automatisch sofort geladen. Die Filmliste wird also sofort aktualisiert wenn es ein Update gibt.\n");
        P2ToggleSwitch tglRemoveDiacritic = new P2ToggleSwitch("Diakritische Zeichen \u00e4ndern");
        tglRemoveDiacritic.setMaxWidth(Double.MAX_VALUE);
        tglRemoveDiacritic.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_REMOVE_DIACRITICS);
        tglRemoveDiacritic.selectedProperty().addListener((u, o, n) -> this.diacriticChanged.setValue(true));
        Button btnHelpDia = P2Button.helpButton(this.stage, "Diakritische Zeichen", "\"Diakritische Zeichen \u00e4ndern\" meint, dass bestimmte Zeichen in den Filmfeldern: \"Titel, Thema und Beschreibung\" angepasst werden. Aus z.B.\n\"\u00e4\u00f6\u00fc \u0144 \u01f9 \u0148 \u00f1 \u1e45 \u0146 \u1e47 \u1e4b \u00e7 \u010d c\" wird dann\n\"\u00e4\u00f6\u00fc n n n n n n n n c c c\".\n\nDas Programm arbeitet dann mit der angepassten Filmliste. Beim Suchen nach Filmen, Downloads und Abos werden die *angepassten Zeichen* in Titel, Thema und Beschreibung verwendet. Dann werden z.B. \"Dvo\u0159ak\", \"No\u00ebl\" und \"Ni\u00f1o\" nicht mehr gefunden, aber stattdessen \"Dvorak\", \"Noel\" und \"Nino\".\n\nBeim Suchen und Anlegen von Abos, muss also klar sein, ob die Funktion ein/ausgeschaltet ist, ob man die Funktion nutzt oder nicht.\n\nDas \u00c4ndern wird sofort nach Beenden des Dialogs gemacht. Sollen Diakritische Zeichen aber wieder eingeschaltet (also angezeigt) werden, muss dazu eine neue Filmliste geladen werden!\n");
        Button btnLoadAudio = new Button("_Audioliste mit diesen Einstellungen neu laden");
        btnLoadAudio.setTooltip(new Tooltip("Eine komplette neue Audioliste laden.\nGe\u00e4nderte Einstellungen f\u00fcr das Laden der Audioliste werden so sofort \u00fcbernommen"));
        btnLoadAudio.setOnAction(event -> LoadAudioFactory.loadAudioListFromWeb(true, true));
        btnLoadAudio.setMaxWidth(Double.MAX_VALUE);
        btnLoadAudio.disableProperty().bind(this.tglUseAudio.selectedProperty().not());
        HBox.setHgrow(btnLoadAudio, Priority.ALWAYS);
        Button btnLoadFilm = new Button("_Filmliste mit diesen Einstellungen neu laden");
        btnLoadFilm.setTooltip(new Tooltip("Eine komplette neue Filmliste laden.\nGe\u00e4nderte Einstellungen f\u00fcr das Laden der Filmliste werden so sofort \u00fcbernommen"));
        btnLoadFilm.setOnAction(event -> LoadFilmFactory.loadFilmListFromWeb(true, true));
        btnLoadFilm.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(btnLoadFilm, Priority.ALWAYS);
        HBox hBoxBtn = new HBox(5.0);
        hBoxBtn.setAlignment(Pos.CENTER_RIGHT);
        hBoxBtn.getChildren().addAll((Node[])new Node[]{btnLoadAudio, btnLoadFilm});
        Separator sp2 = new Separator();
        sp2.getStyleClass().add("pseperator2");
        sp2.setMinHeight(0.0);
        int row = 0;
        gridPane.add(P2Text.getTextBold("ARD-Audiothek im Programm verwenden"), 0, row, 2, 1);
        gridPane.add(this.tglUseAudio, 1, row);
        gridPane.add(btnHelpUse, 2, row);
        gridPane.add(P2Text.getTextBold("Live-Suche im Programm verwenden"), 0, ++row, 2, 1);
        gridPane.add(this.tglUseLive, 1, row);
        gridPane.add(btnHelpLive, 2, row);
        gridPane.add(new Label(), 0, ++row, 2, 1);
        gridPane.add(this.tglLoadFilm, 0, ++row, 2, 1);
        gridPane.add(btnHelpLoadFilm, 2, row);
        gridPane.add(this.tglLoadNewList, 0, ++row, 2, 1);
        gridPane.add(btnHelpNewList, 2, row);
        gridPane.add(tglRemoveDiacritic, 0, ++row, 2, 1);
        gridPane.add(btnHelpDia, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
        HBox hBox = new HBox();
        hBox.getStyleClass().add("extra-pane");
        hBox.setPadding(new Insets(10.0));
        hBox.setMaxWidth(Double.MAX_VALUE);
        hBox.setMinHeight(Double.NEGATIVE_INFINITY);
        hBox.getChildren().add(new Label("\u00c4nderungen in diesem Tab\nwirken sich erst nach dem Neuladen einer Film/Audio-Liste aus"));
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        vBox.getChildren().addAll((Node[])new Node[]{hBox, gridPane, P2GuiTools.getVBoxGrower(), hBoxBtn});
        TitledPane tpConfig = new TitledPane("Filme/Audios laden", vBox);
        result.add(tpConfig);
        return tpConfig;
    }
}

