/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneAbo {
    private final P2ToggleSwitch tglSearchAbo = new P2ToggleSwitch("Downloads aus Abos automatisch suchen:");
    private final P2ToggleSwitch tglStartDownload = new P2ToggleSwitch("Nach dem Suchen Downloads sofort starten:");
    private final ToggleGroup groupOnlyStop = new ToggleGroup();
    private final RadioButton rbOnlyStopAsk = new RadioButton("Vor dem L\u00f6schen fragen");
    private final RadioButton rbOnlyStopDelete = new RadioButton("Abo sofort l\u00f6schen ohne zu fragen");
    private final Stage stage;
    private final VBox vBoxAll = new VBox();

    public PaneAbo(Stage stage) {
        this.stage = stage;
        this.initRadio();
    }

    public void close() {
        this.tglSearchAbo.selectedProperty().unbindBidirectional(ProgConfig.ABO_SEARCH_NOW);
        this.tglStartDownload.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_START_NOW);
    }

    public void make(Collection<TitledPane> result) {
        TitledPane tpConfig = new TitledPane("Abo", this.vBoxAll);
        result.add(tpConfig);
        this.vBoxAll.setSpacing(10.0);
        this.addGridPane();
    }

    private void addGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        this.vBoxAll.getChildren().add(gridPane);
        this.tglSearchAbo.selectedProperty().bindBidirectional(ProgConfig.ABO_SEARCH_NOW);
        Button btnHelpAbo = P2Button.helpButton(this.stage, "Downloads aus Abos automatisch suchen", "Nach dem Neuladen einer Filmliste (und beim Programmstart) oder beim Anlegen/\u00c4ndern eines Abos wird automatisch nach neuen Downloads aus Abos gesucht. Wenn dies ausgeschaltet ist, muss man die Suche manuell ansto\u00dfen, dazu in der Ansicht \"Downloads\" auf \"Downloads aktualisieren\" klicken.\n");
        this.tglStartDownload.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_START_NOW);
        Button btnHelpDownload = P2Button.helpButton(this.stage, "Nach dem Suchen Downloads sofort starten", "Nach dem Suchen von Downloads werden diese sofort gestartet. Das kann beim Programmstart sein, nach dem Neuladen einer Filmliste oder beim manuellem Suchen nach Abos. Sind auch manuell angelegte Downloads vorhanden, werden diese dann auch gestartet.\n");
        Button btnHelpStop = P2Button.helpButton(this.stage, "Abos l\u00f6schen", "Soll ein Abo gel\u00f6scht werden, kann hier ausgew\u00e4hlt werden, was gemacht werden soll:\n\n* Jedes mal vorher fragen\n* Abo sofort l\u00f6schen ohne zu fragen.\n");
        GridPane.setValignment(btnHelpStop, VPos.TOP);
        int row = 0;
        gridPane.add(this.tglSearchAbo, 0, row);
        gridPane.add(btnHelpAbo, 1, row);
        gridPane.add(this.tglStartDownload, 0, ++row);
        gridPane.add(btnHelpDownload, 1, row);
        gridPane.add(new Label(""), 0, ++row);
        gridPane.add(new Label("Abos l\u00f6schen"), 0, ++row);
        gridPane.add(btnHelpStop, 1, row, 1, 2);
        String LEER = "     ";
        VBox vBox = new VBox(5.0);
        HBox hBox = new HBox(20.0);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("     "), this.rbOnlyStopAsk});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
        hBox = new HBox(20.0);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("     "), this.rbOnlyStopDelete});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
        ++row;
        gridPane.add(vBox, 0, ++row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }

    private void initRadio() {
        this.setRadio();
        this.rbOnlyStopAsk.setToggleGroup(this.groupOnlyStop);
        this.rbOnlyStopDelete.setToggleGroup(this.groupOnlyStop);
        ProgConfig.ABO_ONLY_STOP.addListener((v, o, n) -> this.setRadio());
        this.rbOnlyStopAsk.setOnAction(a -> ProgConfig.ABO_ONLY_STOP.setValue(0));
        this.rbOnlyStopDelete.setOnAction(a -> ProgConfig.ABO_ONLY_STOP.setValue(1));
    }

    private void setRadio() {
        switch (ProgConfig.ABO_ONLY_STOP.getValue()) {
            case 1: {
                this.rbOnlyStopDelete.setSelected(true);
                break;
            }
            default: {
                this.rbOnlyStopAsk.setSelected(true);
            }
        }
    }
}

