/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.chart;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.gui.chart.BandwidthData;
import de.p2tools.mtplayer.gui.chart.BandwidthDataFactory;
import de.p2tools.mtplayer.gui.chart.ChartData;
import de.p2tools.mtplayer.gui.chart.ChartDataFactory;
import de.p2tools.p2lib.p2event.P2EventHandler;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;

public class ChartGenerateFactory {
    public static final int GEN_CHART_SHOW_ALL = 0;
    public static final int GEN_CHART_SHOW_DOWN = 1;
    public static final int GEN_CHART_SHOW_SUM = 2;
    public static final String CHART_LINE_NAME_SUM = "Summe";
    public static final int POS_LINE_SUM = 0;

    private ChartGenerateFactory() {
    }

    public static synchronized void generateChartData(LineChart<Number, Number> lineChart, ChartData chartData) {
        ChartDataFactory.genActShowingTimeValues(chartData);
        ChartGenerateFactory.generateChartSeries(chartData);
        ChartGenerateFactory.colorChartName(lineChart, chartData);
    }

    public static synchronized void generateChartSeries(ChartData chartData) {
        int sumChartSeries;
        Object line;
        int countChartSeries = 0;
        if (ProgConfig.DOWNLOAD_CHART_SHOW_WHAT.getValue() == 0 || ProgConfig.DOWNLOAD_CHART_SHOW_WHAT.getValue() == 2) {
            if (chartData.getChartSeriesList().isEmpty()) {
                XYChart.Series<Number, Number> chartSeries = new XYChart.Series<Number, Number>(FXCollections.observableArrayList());
                ChartDataFactory.initChartSeries(chartSeries);
                chartData.getChartSeriesList().add(chartSeries);
            }
            ChartGenerateFactory.fillSumDate(chartData);
            ((XYChart.Series)chartData.getChartSeriesList().get(0)).setName(CHART_LINE_NAME_SUM);
            line = ((XYChart.Series)chartData.getChartSeriesList().get(0)).getNode().lookup(".chart-series-line");
            if (line != null) {
                ((Node)line).setStyle("-fx-stroke-width: 2px; -fx-effect: null; -fx-stroke-dash-array: 10 5 2 5;");
            }
            ++countChartSeries;
        } else if (!chartData.getChartSeriesList().isEmpty() && (line = ((XYChart.Series)chartData.getChartSeriesList().get(0)).getNode().lookup(".chart-series-line")) != null) {
            ((Node)line).setStyle("");
        }
        if (ProgConfig.DOWNLOAD_CHART_SHOW_WHAT.getValue() == 0 || ProgConfig.DOWNLOAD_CHART_SHOW_WHAT.getValue() == 1) {
            for (BandwidthData bandwidthData : chartData.getBandwidthDataList()) {
                XYChart.Series chartSeries;
                if (!bandwidthData.isShowing()) continue;
                if (chartData.getChartSeriesList().size() <= countChartSeries) {
                    chartSeries = new XYChart.Series("", FXCollections.observableArrayList());
                    ChartDataFactory.initChartSeries(chartSeries);
                    chartData.getChartSeriesList().add(chartSeries);
                }
                chartSeries = (XYChart.Series)chartData.getChartSeriesList().get(countChartSeries);
                ChartGenerateFactory.fillDownloadData(chartData, bandwidthData, chartSeries);
                ++countChartSeries;
            }
        }
        if ((sumChartSeries = chartData.getChartSeriesList().size()) > countChartSeries) {
            chartData.getChartSeriesList().remove(countChartSeries, sumChartSeries);
        }
    }

    private static synchronized void fillSumDate(ChartData chartData) {
        double secondsPerPixel = chartData.getSecondsPerPixel();
        double dataPerPixel = chartData.getDataPerPixel();
        for (int chartPos = 0; chartPos < BandwidthDataFactory.CHART_SUM_PIXEL; ++chartPos) {
            long yValue = 0L;
            double actTimeMin = ChartGenerateFactory.getActTime(secondsPerPixel, chartPos);
            for (BandwidthData bandwidthData : chartData.getBandwidthDataList()) {
                long value = ChartGenerateFactory.getValue(bandwidthData, chartPos, dataPerPixel);
                yValue += value;
            }
            ChartGenerateFactory.setValues((XYChart.Series)chartData.getChartSeriesList().get(0), chartPos, yValue, actTimeMin);
        }
    }

    private static void fillDownloadData(ChartData chartData, BandwidthData bandwidthData, XYChart.Series<Number, Number> chartSeries) {
        double secondsPerPixel = chartData.getSecondsPerPixel();
        double dataPerPixel = chartData.getDataPerPixel();
        chartSeries.setName(bandwidthData.getName());
        for (int chartPos = 0; chartPos < BandwidthDataFactory.CHART_SUM_PIXEL; ++chartPos) {
            double actTimeMin = ChartGenerateFactory.getActTime(secondsPerPixel, chartPos);
            long yValue = ChartGenerateFactory.getValue(bandwidthData, chartPos, dataPerPixel);
            ChartGenerateFactory.setValues(chartSeries, chartPos, yValue, actTimeMin);
        }
    }

    private static double getActTime(double secondsPerPixel, int chartPos) {
        return ((double)P2EventHandler.countRunningTimeSeconds - secondsPerPixel * (double)chartPos - (double)BandwidthDataFactory.GET_DATA_COUNT) / (BandwidthDataFactory.SHOW_MINUTES.getValue() != false ? 60.0 : 1.0);
    }

    private static void setValues(XYChart.Series<Number, Number> chartSeries, int chartPos, double yValue, double actTimeMin) {
        if (actTimeMin <= 0.0) {
            ((XYChart.Data)chartSeries.getData().get(chartPos)).setYValue(0);
            ((XYChart.Data)chartSeries.getData().get(chartPos)).setXValue(0);
            return;
        }
        ((XYChart.Data)chartSeries.getData().get(chartPos)).setYValue(yValue / (double)ProgData.getInstance().chartData.getyScale());
        ((XYChart.Data)chartSeries.getData().get(chartPos)).setXValue(actTimeMin);
    }

    private static long getValue(BandwidthData bandwidthData, int chartPos, double dataPerPixel) {
        int dataPos = (int)Math.round((double)BandwidthDataFactory.MAX_DATA - (double)chartPos * dataPerPixel);
        dataPos = Math.max(dataPos, 0);
        dataPos = Math.min(dataPos, BandwidthDataFactory.MAX_DATA - 1);
        return Math.round(bandwidthData.getData()[dataPos]);
    }

    private static synchronized void colorChartName(LineChart<Number, Number> lineChart, ChartData chartData) {
        for (int bi = 0; bi < chartData.getBandwidthDataList().size(); ++bi) {
            BandwidthData bandwidthData = (BandwidthData)chartData.getBandwidthDataList().get(bi);
            ChartGenerateFactory.setColor(lineChart, bandwidthData);
        }
    }

    private static synchronized void setColor(LineChart<Number, Number> lineChart, BandwidthData bandwidthData) {
        String cRed = ProgConfig.SYSTEM_DARK_THEME.getValue() != false ? "#ff0000" : "#de0000";
        String cGreen = ProgConfig.SYSTEM_DARK_THEME.getValue() != false ? "#00ff00" : "#00aa00";
        Set<Node> items = lineChart.lookupAll("Label.chart-legend-item");
        block4: for (Node item : items) {
            Label label = (Label)item;
            if (!label.getText().equals(bandwidthData.getName())) continue;
            switch (bandwidthData.getDownloadState()) {
                case 4: {
                    label.setStyle(" -fx-text-fill: " + cGreen + ";");
                    continue block4;
                }
                case 5: {
                    label.setStyle(" -fx-text-fill: " + cRed + ";");
                    continue block4;
                }
            }
            label.setStyle("");
        }
    }
}

