/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.chart;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.gui.chart.BandwidthData;
import de.p2tools.mtplayer.gui.chart.BandwidthDataFactory;
import de.p2tools.mtplayer.gui.chart.ChartData;
import de.p2tools.mtplayer.gui.chart.ChartFactory;
import de.p2tools.mtplayer.gui.chart.ChartGenerateFactory;
import de.p2tools.p2lib.p2event.P2EventHandler;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;

public class ChartDataFactory {
    private ChartDataFactory() {
    }

    public static synchronized void runChart(LineChart<Number, Number> lineChart) {
        BandwidthDataFactory.setsBandwidthDataShowingOrNot(ProgData.getInstance().chartData);
        ChartFactory.generateYScale(lineChart, ProgData.getInstance().chartData);
        ChartGenerateFactory.generateChartData(lineChart, ProgData.getInstance().chartData);
        ChartFactory.zoomXAxis(lineChart, ProgData.getInstance().chartData);
    }

    public static void initChartSeries(XYChart.Series<Number, Number> chartSeries) {
        chartSeries.getData().clear();
        for (int i = 0; i < BandwidthDataFactory.CHART_SUM_PIXEL; ++i) {
            chartSeries.getData().add(new XYChart.Data<Integer, Integer>(i, 0));
        }
    }

    public static void genActShowingTimeValues(ChartData chartData) {
        int oldest = 0;
        for (int bi = 0; bi < chartData.getBandwidthDataList().size(); ++bi) {
            BandwidthData bandwidthData = (BandwidthData)chartData.getBandwidthDataList().get(bi);
            if (bandwidthData.isEmpty() || (long)oldest <= bandwidthData.getStartTimeSec()) continue;
            oldest = (int)bandwidthData.getStartTimeSec();
        }
        long timeToShowSeconds = P2EventHandler.countRunningTimeSeconds - (long)oldest;
        int maxTimeSelectedSeconds = ProgConfig.DOWNLOAD_CHART_MAX_TIME_TO_SHOW_MIN.get() * 60;
        int maxTimeToShowSeconds = (long)maxTimeSelectedSeconds < timeToShowSeconds ? maxTimeSelectedSeconds : (timeToShowSeconds < 60L ? 60 : (timeToShowSeconds < 120L ? 120 : (timeToShowSeconds < 600L ? 600 : (timeToShowSeconds < 1800L ? 1800 : (timeToShowSeconds < 3600L ? 3600 : (timeToShowSeconds < 6000L ? 6000 : (timeToShowSeconds < 7200L ? 7200 : (timeToShowSeconds < 9000L ? 9000 : (timeToShowSeconds < 12000L ? 12000 : BandwidthDataFactory.MAX_SECONDS_SHOWING)))))))));
        BandwidthDataFactory.SHOW_MINUTES.setValue(timeToShowSeconds >= 120L);
        chartData.setSecondsPerPixel(1.0 * (double)maxTimeToShowSeconds / (double)BandwidthDataFactory.CHART_SUM_PIXEL);
        chartData.setDataPerPixel(chartData.getSecondsPerPixel() / (double)BandwidthDataFactory.DATA_ALL_SECONDS);
    }
}

