/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.chart;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.gui.chart.BandwidthData;
import de.p2tools.mtplayer.gui.chart.ChartData;
import de.p2tools.p2lib.tools.duration.P2Duration;
import java.util.ListIterator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class BandwidthDataFactory {
    public static int MAX_SECONDS_SHOWING = 15000;
    public static int DATA_ALL_SECONDS = 5;
    public static int MAX_DATA = MAX_SECONDS_SHOWING / DATA_ALL_SECONDS;
    public static int GET_DATA_COUNT = 0;
    public static int CHART_SUM_PIXEL = 500;
    public static BooleanProperty SHOW_MINUTES = new SimpleBooleanProperty(false);
    private static int count = 0;

    private BandwidthDataFactory() {
    }

    public static synchronized void addBandwidthData() {
        ProgData progData = ProgData.getInstance();
        if (progData.downloadList.size() > 1000) {
            if (count < 2) {
                ++count;
                return;
            }
            count = 0;
        }
        P2Duration.counterStart("addBandwidthData");
        BandwidthDataFactory.inputDownloadsAndBandwidthValue(progData);
        P2Duration.counterStop("addBandwidthData");
    }

    private static synchronized void inputDownloadsAndBandwidthValue(ProgData progData) {
        for (BandwidthData bandwidthData : progData.chartData.getBandwidthDataList()) {
            bandwidthData.setDownloading(false);
        }
        for (DownloadData download : progData.downloadList) {
            boolean foundDownload = false;
            for (BandwidthData bandwidthData : progData.chartData.getBandwidthDataList()) {
                if (bandwidthData.getDownload() == null || !bandwidthData.getDownload().equals(download)) continue;
                bandwidthData.setDownloading(true);
                foundDownload = true;
                break;
            }
            if (foundDownload || !download.isStateStartedRun()) continue;
            BandwidthData bwd = new BandwidthData(download);
            progData.chartData.getBandwidthDataList().add(bwd);
        }
        BandwidthDataFactory.cleanBandwidthDate(progData);
        BandwidthDataFactory.readBandwidthDate(progData);
        if (++GET_DATA_COUNT >= DATA_ALL_SECONDS) {
            GET_DATA_COUNT = 0;
        }
    }

    private static void cleanBandwidthDate(ProgData progData) {
        ListIterator it = progData.chartData.getBandwidthDataList().listIterator();
        while (it.hasNext()) {
            BandwidthData bandwidthData = (BandwidthData)it.next();
            if (bandwidthData.isDownloading()) continue;
            bandwidthData.setDownload(null);
            if (!bandwidthData.isEmpty()) continue;
            it.remove();
        }
    }

    private static void readBandwidthDate(ProgData progData) {
        for (BandwidthData bandwidthData : progData.chartData.getBandwidthDataList()) {
            DownloadData download = bandwidthData.getDownload();
            if (download != null && download.isStateStartedRun()) {
                long bandwidth = download.getBandwidth();
                bandwidthData.addData(bandwidth);
            } else {
                bandwidthData.addData(0L);
            }
            if (download != null && download.getNo() != Integer.MAX_VALUE) {
                bandwidthData.setName(String.valueOf(download.getNo()));
                continue;
            }
            if (download == null) continue;
            bandwidthData.setName("[" + download.getFilmNo() + "]");
        }
    }

    private static synchronized void inputDownloadsAndBandwidthValue_(ProgData progData) {
        for (DownloadData download : progData.downloadList) {
            boolean foundDownload = false;
            for (BandwidthData bandwidthData : progData.chartData.getBandwidthDataList()) {
                if (bandwidthData.getDownload() == null || !bandwidthData.getDownload().equals(download)) continue;
                foundDownload = true;
                break;
            }
            if (foundDownload || !download.isStarted()) continue;
            BandwidthData bwd = new BandwidthData(download);
            progData.chartData.getBandwidthDataList().add(bwd);
        }
        BandwidthDataFactory.readBandwidthDate(progData);
        if (++GET_DATA_COUNT >= DATA_ALL_SECONDS) {
            GET_DATA_COUNT = 0;
        }
    }

    private static synchronized void cleanUpBandwidthData(ProgData progData) {
        ListIterator it = progData.chartData.getBandwidthDataList().listIterator();
        while (it.hasNext()) {
            boolean foundDownload = false;
            BandwidthData bandwidthData = (BandwidthData)it.next();
            for (DownloadData download : ProgData.getInstance().downloadList) {
                if (bandwidthData.getDownload() == null || !bandwidthData.getDownload().equals(download)) continue;
                foundDownload = true;
                break;
            }
            if (foundDownload) continue;
            bandwidthData.setDownload(null);
            if (!bandwidthData.isEmpty()) continue;
            it.remove();
        }
    }

    public static synchronized void setsBandwidthDataShowingOrNot(ChartData chartData) {
        for (BandwidthData bandwidthData : chartData.getBandwidthDataList()) {
            boolean downExist;
            if (bandwidthData.allValuesEmpty()) {
                bandwidthData.setShowing(false);
                continue;
            }
            boolean downRunning = bandwidthData.getDownload() != null && bandwidthData.getDownload().isStateStartedRun();
            boolean bl = downExist = bandwidthData.getDownload() != null;
            if (!downRunning && ProgConfig.DOWNLOAD_CHART_ONLY_RUNNING.getValue().booleanValue()) {
                bandwidthData.setShowing(false);
                continue;
            }
            if (!downExist && ProgConfig.DOWNLOAD_CHART_ONLY_EXISTING.getValue().booleanValue()) {
                bandwidthData.setShowing(false);
                continue;
            }
            bandwidthData.setShowing(true);
        }
    }
}

