/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadInfosFactory;
import de.p2tools.mtplayer.controller.worker.Busy;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;

public class StatusBarController
extends AnchorPane {
    private final Label lblSelFilm = new Label();
    private final Label lblLeftFilm = new Label();
    private final Label lblRightFilm = new Label();
    private final Circle circleFilm = new Circle(6.0);
    private final HBox hBoxCircleFilm = new HBox(0.0);
    private final Label lblSelAudio = new Label();
    private final Label lblLeftAudio = new Label();
    private final Label lblRightAudio = new Label();
    private final Circle circleAudio = new Circle(6.0);
    private final HBox hBoxCircleAudio = new HBox(0.0);
    private final Label lblSelLive = new Label();
    private final Label lblLeftLive = new Label();
    private final Label lblRightLive = new Label();
    private final Circle circleLive = new Circle(6.0);
    private final HBox hBoxCircleLive = new HBox(0.0);
    private final Label lblSelDownload = new Label();
    private final Label lblLeftDownload = new Label();
    private final Label lblRightDownload = new Label();
    private final Circle circleDownload = new Circle(6.0);
    private final HBox hBoxCircleDownload = new HBox(0.0);
    private final Label lblSelAbo = new Label();
    private final Label lblLeftAbo = new Label();
    private final Label lblRightAbo = new Label();
    private final Circle circleAbo = new Circle(6.0);
    private final HBox hBoxCircleAbo = new HBox(0.0);
    private final StackPane stackPane = new StackPane();
    private final Pane paneFilm;
    private final Pane paneAudio;
    private final Pane paneLive;
    private final Pane paneDownload;
    private final Pane paneAbo;
    private final ProgData progData;
    private boolean stopTimer = false;
    private boolean halfSecond = false;
    private boolean blink = false;

    public StatusBarController(ProgData progData) {
        this.progData = progData;
        StackPane stackPaneBusy = new StackPane();
        this.getChildren().addAll((Node[])new Node[]{stackPaneBusy});
        AnchorPane.setLeftAnchor(stackPaneBusy, 0.0);
        AnchorPane.setBottomAnchor(stackPaneBusy, 0.0);
        AnchorPane.setRightAnchor(stackPaneBusy, 0.0);
        AnchorPane.setTopAnchor(stackPaneBusy, 0.0);
        this.lblSelFilm.setTooltip(new Tooltip("Anzahl markierter Filme"));
        this.lblSelAudio.setTooltip(new Tooltip("Anzahl markierter Audios"));
        this.lblSelLive.setTooltip(new Tooltip("Anzahl markierter Filme"));
        this.lblSelDownload.setTooltip(new Tooltip("Anzahl markierter Downloads"));
        this.lblSelAbo.setTooltip(new Tooltip("Anzahl markierter Abos"));
        this.hBoxCircleFilm.getChildren().add(this.circleFilm);
        this.hBoxCircleAudio.getChildren().add(this.circleAudio);
        this.hBoxCircleLive.getChildren().add(this.circleLive);
        this.hBoxCircleDownload.getChildren().add(this.circleDownload);
        this.hBoxCircleAbo.getChildren().add(this.circleAbo);
        this.paneFilm = this.getHBox(this.lblSelFilm, this.lblLeftFilm, this.hBoxCircleFilm, this.lblRightFilm);
        this.paneAudio = this.getHBox(this.lblSelAudio, this.lblLeftAudio, this.hBoxCircleAudio, this.lblRightAudio);
        this.paneLive = this.getHBox(this.lblSelLive, this.lblLeftLive, this.hBoxCircleLive, this.lblRightLive);
        this.paneDownload = this.getHBox(this.lblSelDownload, this.lblLeftDownload, this.hBoxCircleDownload, this.lblRightDownload);
        this.paneAbo = this.getHBox(this.lblSelAbo, this.lblLeftAbo, this.hBoxCircleAbo, this.lblRightAbo);
        HBox hBusy = ProgData.busy.getBusyHbox(Busy.BUSY_SRC.GUI);
        hBusy.setStyle("-fx-background-color: -fx-background;");
        stackPaneBusy.getChildren().addAll((Node[])new Node[]{this.stackPane, hBusy});
        this.stackPane.toFront();
        ProgData.busy.busyProperty().addListener((u, o, n) -> {
            if (ProgData.busy.isBusy()) {
                hBusy.toFront();
            } else {
                this.stackPane.toFront();
            }
        });
        this.make();
        this.setVisProp();
    }

    private HBox getHBox(Label lblSel, Label lblLeft, HBox hBoxCircle, Label lblRight) {
        HBox hBox = new HBox();
        hBoxCircle.setAlignment(Pos.CENTER);
        hBoxCircle.setPadding(new Insets(0.0, 15.0, 0.0, 15.0));
        hBox.setPadding(new Insets(2.0, 5.0, 2.0, 5.0));
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        lblSel.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        lblSel.getStyleClass().add("lblSelectedLines");
        lblLeft.getStyleClass().add("lblInfo");
        hBox.setStyle("-fx-background-color: -fx-background;");
        hBox.getChildren().addAll((Node[])new Node[]{lblSel, lblLeft, hBoxCircle, P2GuiTools.getHBoxGrower(), lblRight});
        return hBox;
    }

    private void setVisProp() {
        this.lblSelFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblSelFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblLeftFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblLeftFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblRightFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.lblRightFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.hBoxCircleFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.hBoxCircleFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.lblSelAudio.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblSelAudio.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblLeftAudio.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblLeftAudio.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblRightAudio.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.lblRightAudio.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.hBoxCircleAudio.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.hBoxCircleAudio.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.lblSelLive.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblSelLive.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblLeftLive.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblLeftLive.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblRightLive.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.lblRightLive.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.hBoxCircleLive.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.hBoxCircleLive.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.lblSelDownload.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblSelDownload.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblLeftDownload.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblLeftDownload.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblRightDownload.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.lblRightDownload.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.hBoxCircleDownload.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.hBoxCircleDownload.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.lblSelAbo.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblSelAbo.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblLeftAbo.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblLeftAbo.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblRightAbo.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.lblRightAbo.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.hBoxCircleAbo.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.hBoxCircleAbo.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
    }

    private void make() {
        this.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                ContextMenu contextMenu = new ContextMenu();
                this.getMenu(contextMenu);
                contextMenu.show(ProgData.getInstance().primaryStage, m.getScreenX(), m.getScreenY());
            }
        });
        this.stackPane.getChildren().addAll((Node[])new Node[]{this.paneFilm, this.paneAudio, this.paneLive, this.paneDownload, this.paneAbo});
        this.stackPane.setPadding(new Insets(0.0));
        this.paneFilm.toFront();
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_START){

            @Override
            public void pingGui() {
                StatusBarController.this.stopTimer = true;
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_FINISHED){

            @Override
            public void pingGui() {
                StatusBarController.this.stopTimer = false;
                StatusBarController.this.setStatusbarIndex();
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_TIMER_SECOND){

            @Override
            public void pingGui() {
                StatusBarController.this.halfSecond = !StatusBarController.this.halfSecond;
                try {
                    if (!StatusBarController.this.stopTimer) {
                        StatusBarController.this.setStatusbarIndex();
                    }
                }
                catch (Exception ex) {
                    P2Log.errorLog(936251087, ex);
                }
            }
        });
    }

    private void getMenu(ContextMenu contextMenu) {
        CheckMenuItem miOn = new CheckMenuItem("Statusleiste anzeigen");
        miOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_ON);
        CheckMenuItem miSelOn = new CheckMenuItem("Anzeige der Anzahl der markierten Zeilen");
        miSelOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        CheckMenuItem miLeftOn = new CheckMenuItem("Anzeige des Infobereichs links");
        miLeftOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        CheckMenuItem miDotOn = new CheckMenuItem("Anzeige des Farbpunktes f\u00fcr die Downloads");
        miDotOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        CheckMenuItem miRightOn = new CheckMenuItem("Anzeige der Infos \u00fcber die Filmliste");
        miRightOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miOn, miSelOn, miLeftOn, miDotOn, miRightOn});
    }

    public void setStatusbarIndex() {
        if (MTPlayerController.TAB_FILM_ON.get()) {
            this.paneFilm.toFront();
            this.setInfoFilm();
            this.setTextForRightDisplayFilm();
        } else if (MTPlayerController.TAB_AUDIO_ON.get()) {
            this.paneAudio.toFront();
            this.setInfoAudio();
            this.setTextForRightDisplayAudio();
        } else if (MTPlayerController.TAB_LIVE_ON.get()) {
            this.paneLive.toFront();
            this.setInfoLiveFilm();
            this.setTextForRightDisplayFilm();
        } else if (MTPlayerController.TAB_DOWNLOAD_ON.get()) {
            this.paneDownload.toFront();
            this.setInfoDownload();
            this.setTextForRightDisplayFilm();
        } else if (MTPlayerController.TAB_ABO_ON.get()) {
            this.paneAbo.toFront();
            this.setInfoAbo();
            this.setTextForRightDisplayFilm();
        }
    }

    private void setInfoFilm() {
        this.setCircleStyle();
        this.lblLeftFilm.setText(DownloadInfosFactory.getStatusInfosFilm());
        int selCount = this.progData.filmGuiController.getSelCount();
        this.lblSelFilm.setText((String)(selCount > 0 ? "" + selCount : " "));
    }

    private void setInfoAudio() {
        this.setCircleStyle();
        this.lblLeftAudio.setText(DownloadInfosFactory.getStatusInfosAudio());
        int selCount = this.progData.audioGuiController.getSelCount();
        this.lblSelAudio.setText((String)(selCount > 0 ? "" + selCount : " "));
    }

    private void setInfoLiveFilm() {
        this.setCircleStyle();
        this.lblLeftLive.setText(DownloadInfosFactory.getStatusInfosLiveFilm());
        int selCount = this.progData.liveFilmGuiController.getSelCount();
        this.lblSelLive.setText((String)(selCount > 0 ? "" + selCount : " "));
    }

    private void setInfoDownload() {
        this.setCircleStyle();
        this.lblLeftDownload.setText(DownloadInfosFactory.getStatusInfosDownload());
        int selCount = this.progData.downloadGuiController.getSelCount();
        this.lblSelDownload.setText((String)(selCount > 0 ? "" + selCount : " "));
    }

    private void setInfoAbo() {
        this.setCircleStyle();
        this.lblLeftAbo.setText(DownloadInfosFactory.getStatusInfosAbo());
        int selCount = this.progData.aboGuiController.getSelCount();
        this.lblSelAbo.setText((String)(selCount > 0 ? "" + selCount : " "));
    }

    private void setCircleStyle() {
        if (this.halfSecond && this.blink) {
            this.circleFilm.setVisible(false);
            this.circleAudio.setVisible(false);
            this.circleLive.setVisible(false);
            this.circleDownload.setVisible(false);
            this.circleAbo.setVisible(false);
        } else {
            this.circleFilm.setVisible(true);
            this.circleAudio.setVisible(true);
            this.circleLive.setVisible(true);
            this.circleDownload.setVisible(true);
            this.circleAbo.setVisible(true);
        }
        boolean bl = this.blink = this.progData.downloadInfos.getNotStarted() > 0;
        if (this.progData.downloadInfos.getFinishedError() > 0) {
            this.circleFilm.setFill(Paint.valueOf("red"));
            this.circleAudio.setFill(Paint.valueOf("red"));
            this.circleLive.setFill(Paint.valueOf("red"));
            this.circleDownload.setFill(Paint.valueOf("red"));
            this.circleAbo.setFill(Paint.valueOf("red"));
        } else if (this.progData.downloadInfos.getLoading() > 0) {
            this.circleFilm.setFill(Paint.valueOf("green"));
            this.circleAudio.setFill(Paint.valueOf("green"));
            this.circleLive.setFill(Paint.valueOf("green"));
            this.circleDownload.setFill(Paint.valueOf("green"));
            this.circleAbo.setFill(Paint.valueOf("green"));
        } else {
            this.circleFilm.setFill(Paint.valueOf(ProgConfig.SYSTEM_DARK_THEME.getValue() != false ? "#c1c1c1" : "#666666"));
            this.circleAudio.setFill(Paint.valueOf(ProgConfig.SYSTEM_DARK_THEME.getValue() != false ? "#c1c1c1" : "#666666"));
            this.circleLive.setFill(Paint.valueOf(ProgConfig.SYSTEM_DARK_THEME.getValue() != false ? "#c1c1c1" : "#666666"));
            this.circleDownload.setFill(Paint.valueOf(ProgConfig.SYSTEM_DARK_THEME.getValue() != false ? "#c1c1c1" : "#666666"));
            this.circleAbo.setFill(Paint.valueOf(ProgConfig.SYSTEM_DARK_THEME.getValue() != false ? "#c1c1c1" : "#666666"));
        }
    }

    private void setTextForRightDisplayFilm() {
        Object strText = "Filmliste erstellt: ";
        strText = (String)strText + this.progData.filmList.genDate();
        strText = (String)strText + " Uhr  ";
        int second = this.progData.filmList.getAge();
        if (second != 0) {
            strText = (String)strText + "||  Alter: ";
            int minute = second / 60;
            Object strSecond = String.valueOf(second % 60);
            Object strMinute = String.valueOf(minute % 60);
            Object strHour = String.valueOf(minute / 60);
            if (((String)strSecond).length() < 2) {
                strSecond = "0" + (String)strSecond;
            }
            if (((String)strMinute).length() < 2) {
                strMinute = "0" + (String)strMinute;
            }
            if (((String)strHour).length() < 2) {
                strHour = "0" + (String)strHour;
            }
            strText = (String)strText + (String)strHour + ":" + (String)strMinute + ":" + (String)strSecond + " ";
        }
        this.lblRightFilm.setText((String)strText);
        this.lblRightLive.setText((String)strText);
        this.lblRightDownload.setText((String)strText);
        this.lblRightAbo.setText((String)strText);
    }

    private void setTextForRightDisplayAudio() {
        Object strText = "Audioliste erstellt: ";
        strText = (String)strText + this.progData.audioList.genDate();
        strText = (String)strText + " Uhr  ";
        int second = this.progData.audioList.getAge();
        if (second != 0) {
            strText = (String)strText + "||  Alter: ";
            int minute = second / 60;
            Object strSecond = String.valueOf(second % 60);
            Object strMinute = String.valueOf(minute % 60);
            Object strHour = String.valueOf(minute / 60);
            if (((String)strSecond).length() < 2) {
                strSecond = "0" + (String)strSecond;
            }
            if (((String)strMinute).length() < 2) {
                strMinute = "0" + (String)strMinute;
            }
            if (((String)strHour).length() < 2) {
                strHour = "0" + (String)strHour;
            }
            strText = (String)strText + (String)strHour + ":" + (String)strMinute + ":" + (String)strSecond + " ";
        }
        this.lblRightAudio.setText((String)strText);
    }
}

