/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.gui.AboMenu;
import de.p2tools.mtplayer.gui.AudioMenu;
import de.p2tools.mtplayer.gui.DownloadMenu;
import de.p2tools.mtplayer.gui.FilmMenu;
import de.p2tools.mtplayer.gui.LiveFilmMenu;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;

public class MenuController
extends ScrollPane {
    public MenuController(StartupMode sm) {
        VBox vb = new VBox();
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.setFitToHeight(true);
        this.setFitToWidth(true);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setContent(vb);
        vb.setPadding(new Insets(5.0));
        vb.setSpacing(15.0);
        vb.setAlignment(Pos.TOP_CENTER);
        switch (sm) {
            case Film: {
                new FilmMenu(vb).init();
                this.visibleProperty().bind(ProgConfig.FILM_GUI_SHOW_MENU);
                this.managedProperty().bind(ProgConfig.FILM_GUI_SHOW_MENU);
                break;
            }
            case AUDIO: {
                new AudioMenu(vb).init();
                this.visibleProperty().bind(ProgConfig.AUDIO_GUI_SHOW_MENU);
                this.managedProperty().bind(ProgConfig.AUDIO_GUI_SHOW_MENU);
                break;
            }
            case LIVE_FILM: {
                new LiveFilmMenu(vb).init();
                this.visibleProperty().bind(ProgConfig.LIVE_FILM_GUI_SHOW_MENU);
                this.managedProperty().bind(ProgConfig.LIVE_FILM_GUI_SHOW_MENU);
                break;
            }
            case DOWNLOAD: {
                new DownloadMenu(vb).init();
                this.visibleProperty().bind(ProgConfig.DOWNLOAD_GUI_SHOW_MENU);
                this.managedProperty().bind(ProgConfig.DOWNLOAD_GUI_SHOW_MENU);
                break;
            }
            case ABO: {
                new AboMenu(vb).init();
                this.visibleProperty().bind(ProgConfig.ABO_GUI_SHOW_MENU);
                this.managedProperty().bind(ProgConfig.ABO_GUI_SHOW_MENU);
            }
        }
    }

    public static enum StartupMode {
        Film,
        AUDIO,
        LIVE_FILM,
        DOWNLOAD,
        ABO;

    }
}

