/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.MTPlayerFactory;
import de.p2tools.mtplayer.controller.config.PShortKeyFactory;
import de.p2tools.mtplayer.controller.config.PShortcut;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.data.film.FilmSaveFactory;
import de.p2tools.mtplayer.controller.filter.FilmFilter;
import de.p2tools.mtplayer.gui.ToolBarButton;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.shortcut.P2ShortcutWorker;
import java.util.Optional;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;

public class LiveFilmMenu {
    private final VBox vBox;
    private final ProgData progData;
    private FilmFilter storedActFilterSettings = null;
    private static final String FILM_FILTER_BOOKMARK_TEXT = "Alle angelegte Bookmarks anzeigen\nder zweite Klick stellt den\neingestellten Filter wieder her";

    public LiveFilmMenu(VBox vBox) {
        this.vBox = vBox;
        this.progData = ProgData.getInstance();
    }

    public void init() {
        this.vBox.getChildren().clear();
        this.initFilmMenu();
        this.initButton();
    }

    private void initButton() {
        VBox vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(0.0);
        vBoxSpace.setMinHeight(0.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btPlay = new ToolBarButton(this.vBox, "Abspielen", "Markierten Film abspielen", ProgIcons.ICON_TOOLBAR_START.getImageView());
        ToolBarButton btPlayAll = new ToolBarButton(this.vBox, "Alle Abspielen", "Alle markierten Filme abspielen", ProgIcons.ICON_TOOLBAR_START_ALL.getImageView());
        ToolBarButton btSave = new ToolBarButton(this.vBox, "Speichern", "Markierte Filme speichern", ProgIcons.ICON_TOOLBAR_REC.getImageView());
        btPlay.setOnAction(a -> {
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().liveFilmGuiController.getSel(true, true);
            if (filmSelection.isPresent()) {
                FilmPlayFactory.playFilm(false, filmSelection.get());
                this.progData.filmGuiController.tableView.refresh();
                this.progData.filmGuiController.tableView.requestFocus();
            }
        });
        btPlayAll.setOnAction(a -> {
            FilmPlayFactory.playFilmList(false, ProgData.getInstance().liveFilmGuiController.getSelList(true));
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        btSave.setOnAction(a -> {
            FilmSaveFactory.saveFilmList(false, ProgData.getInstance().liveFilmGuiController.getSelList(true), null);
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        this.vBox.getChildren().add(P2GuiTools.getVDistance(10));
    }

    private void initFilmMenu() {
        MenuButton mb = new MenuButton("");
        mb.setTooltip(new Tooltip("Live-Filmmen\u00fc anzeigen"));
        mb.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        mb.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-0"});
        MenuItem mbPlay = new MenuItem("Film abspielen");
        mbPlay.setOnAction(a -> {
            if (!MTPlayerController.TAB_LIVE_ON.get()) {
                return;
            }
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().liveFilmGuiController.getSel(true, true);
            filmSelection.ifPresent(film -> FilmPlayFactory.playFilm(false, film));
        });
        P2ShortcutWorker.addShortCut(mbPlay, PShortcut.SHORTCUT_PLAY_FILM);
        MenuItem mbPlayAll = new MenuItem("Alle markierten Film abspielen");
        mbPlayAll.setOnAction(a -> {
            if (!MTPlayerController.TAB_LIVE_ON.get()) {
                return;
            }
            FilmPlayFactory.playFilmList(false, ProgData.getInstance().liveFilmGuiController.getSelList(true));
        });
        P2ShortcutWorker.addShortCut(mbPlayAll, PShortcut.SHORTCUT_PLAY_FILM_ALL);
        MenuItem mbSave = new MenuItem("Film speichern");
        mbSave.setOnAction(e -> {
            if (!MTPlayerController.TAB_LIVE_ON.get()) {
                return;
            }
            FilmSaveFactory.saveFilmList();
        });
        P2ShortcutWorker.addShortCut(mbSave, PShortcut.SHORTCUT_SAVE_FILM);
        mb.getItems().addAll((MenuItem[])new MenuItem[]{mbPlay, mbPlayAll, mbSave});
        MenuItem miFilmInfo = new MenuItem("Filminformation anzeigen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_INFO_FILM.getActShortcut());
        miFilmInfo.setOnAction(a -> this.progData.filmGuiController.showFilmInfo());
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miFilmInfo, LiveFilmMenu.copyInfos(this.progData)});
        MenuItem miFilmMediaCollection = new MenuItem("Film in der Mediensammlung suchen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SEARCH_FILM_IN_MEDIACOLLECTION.getActShortcut());
        miFilmMediaCollection.setOnAction(a -> this.progData.filmGuiController.searchFilmInMediaCollection());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miFilmMediaCollection});
        MenuItem miShowFilter = new MenuItem("Filter ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_FILTER.getActShortcut());
        miShowFilter.disableProperty().bind(ProgConfig.LIVE_FILM__FILTER_IS_RIP);
        miShowFilter.setOnAction(a -> MTPlayerFactory.setFilter());
        MenuItem miShowInfo = new MenuItem("Infos ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_INFOS.getActShortcut());
        miShowInfo.disableProperty().bind(ProgConfig.LIVE_FILM__INFO_PANE_IS_RIP.and(ProgConfig.LIVE_FILM__BUTTON_PANE_IS_RIP).and(ProgConfig.LIVE_FILM__MEDIA_PANE_IS_RIP));
        miShowInfo.setOnAction(a -> MTPlayerFactory.setInfos());
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miShowFilter, miShowInfo});
        this.vBox.getChildren().add(mb);
    }

    public static Menu copyInfos(ProgData progData) {
        Menu subMenuURL = new Menu("Film-Infos kopieren");
        MenuItem miCopyTheme = new MenuItem("Thema");
        miCopyTheme.setOnAction(a -> progData.liveFilmGuiController.copyFilmThemeTitle(true));
        MenuItem miCopyName = new MenuItem("Titel");
        miCopyName.setOnAction(a -> progData.liveFilmGuiController.copyFilmThemeTitle(false));
        MenuItem miCopyWeb = new MenuItem("Website-URL");
        miCopyWeb.setOnAction(a -> progData.liveFilmGuiController.copyWebsite());
        MenuItem miCopyHd = new MenuItem("URL in HD-Aufl\u00f6sung");
        miCopyHd.setOnAction(a -> progData.liveFilmGuiController.copyUrl("hd"));
        MenuItem miCopyUrl = new MenuItem("URL in hoher Aufl\u00f6sung");
        miCopyUrl.setOnAction(a -> progData.liveFilmGuiController.copyUrl("normal"));
        MenuItem miCopyLow = new MenuItem("URL in kleiner Aufl\u00f6sung");
        miCopyLow.setOnAction(a -> progData.liveFilmGuiController.copyUrl("small"));
        subMenuURL.getItems().addAll((MenuItem[])new MenuItem[]{miCopyTheme, miCopyName, miCopyWeb});
        subMenuURL.getItems().add(new SeparatorMenuItem());
        subMenuURL.getItems().addAll((MenuItem[])new MenuItem[]{miCopyHd, miCopyUrl, miCopyLow});
        return subMenuURL;
    }
}

