/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.mtplayer.controller.data.abo.AboListFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFactory;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.data.film.FilmSaveFactory;
import de.p2tools.mtplayer.controller.data.setdata.SetDataList;
import de.p2tools.mtplayer.controller.starter.StartDownloadFactory;
import de.p2tools.mtplayer.gui.FilmGuiController;
import de.p2tools.mtplayer.gui.tools.table.TableFilm;
import de.p2tools.p2lib.tools.P2ToolsFactory;
import java.util.Optional;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class FilmTableContextMenu {
    private final ProgData progData;
    private final FilmGuiController filmGuiController;
    private final TableFilm tableView;

    public FilmTableContextMenu(ProgData progData, FilmGuiController filmGuiController, TableFilm tableView) {
        this.progData = progData;
        this.filmGuiController = filmGuiController;
        this.tableView = tableView;
    }

    public ContextMenu getContextMenu(FilmDataMTP film) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem miStart = new MenuItem("Film abspielen");
        miStart.setOnAction(a -> {
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().filmGuiController.getSel(true, true);
            filmSelection.ifPresent(f -> FilmPlayFactory.playFilm(false, f));
        });
        MenuItem miSave = new MenuItem("Film speichern");
        miSave.setOnAction(a -> FilmSaveFactory.saveFilmList());
        miStart.setDisable(film == null);
        miSave.setDisable(film == null);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miStart, miSave});
        Menu mFilter = this.addFilter(film);
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{mFilter});
        Menu mStartFilm = FilmTableContextMenu.startFilmWithSet(this.progData, film);
        if (mStartFilm != null) {
            contextMenu.getItems().add(mStartFilm);
        }
        Menu mCopyUrl = FilmTableContextMenu.copyInfos(film);
        Menu mFilm = this.addFilm(film);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{mCopyUrl, mFilm});
        Menu mAddAbo = this.addAbo(film);
        Menu mBlacklist = this.addBlacklist(film);
        Menu mBookmark = this.addBookmark(film);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{new SeparatorMenuItem(), mAddAbo, mBlacklist, mBookmark});
        contextMenu.getItems().add(new SeparatorMenuItem());
        CheckMenuItem smallTableRow = new CheckMenuItem("Nur kleine Button anzeigen");
        smallTableRow.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SMALL_TABLE_ROW_FILM);
        CheckMenuItem toolTipTable = new CheckMenuItem("Infos beim \u00dcberfahren einer Zeile anzeigen");
        toolTipTable.selectedProperty().bindBidirectional(ProgConfig.FILM_GUI_SHOW_TABLE_TOOL_TIP);
        MenuItem resetTable = new MenuItem("Tabelle zur\u00fccksetzen");
        resetTable.setOnAction(a -> this.tableView.resetTable());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{smallTableRow, toolTipTable, resetTable});
        return contextMenu;
    }

    private Menu addFilter(FilmDataMTP film) {
        Menu submenuFilter = new Menu("Filter");
        MenuItem miFilterChannel = new MenuItem("nach Sender filtern");
        miFilterChannel.setOnAction(event -> this.progData.filterWorkerFilm.getActFilterSettings().setChannelAndVis(film.getChannel()));
        MenuItem miFilterTheme = new MenuItem("nach Thema filtern");
        miFilterTheme.setOnAction(event -> this.progData.filterWorkerFilm.getActFilterSettings().setThemeAndVis(film.getTheme(), false));
        MenuItem miFilterChannelTheme = new MenuItem("nach Sender und Thema filtern");
        miFilterChannelTheme.setOnAction(event -> {
            this.progData.filterWorkerFilm.getActFilterSettings().setChannelAndVis(film.getChannel());
            this.progData.filterWorkerFilm.getActFilterSettings().setThemeAndVis(film.getTheme(), false);
        });
        MenuItem miFilterChannelThemeTitle = new MenuItem("nach Sender, Thema und Titel filtern");
        miFilterChannelThemeTitle.setOnAction(event -> {
            this.progData.filterWorkerFilm.getActFilterSettings().setChannelAndVis(film.getChannel());
            this.progData.filterWorkerFilm.getActFilterSettings().setThemeAndVis(film.getTheme(), false);
            this.progData.filterWorkerFilm.getActFilterSettings().setTitleAndVis(film.getTitle());
        });
        miFilterChannel.setDisable(film == null);
        miFilterTheme.setDisable(film == null);
        miFilterChannelTheme.setDisable(film == null);
        miFilterChannelThemeTitle.setDisable(film == null);
        submenuFilter.getItems().addAll((MenuItem[])new MenuItem[]{miFilterChannel, miFilterTheme, miFilterChannelTheme, miFilterChannelThemeTitle});
        return submenuFilter;
    }

    private Menu addAbo(FilmDataMTP film) {
        AboData aboData;
        Menu submenuAbo = new Menu("Abo");
        MenuItem miAboAddFilter = new MenuItem("aus dem Filter ein Abo erstellen");
        MenuItem miAboAddChannelTheme = new MenuItem("Abo mit Sender und Thema anlegen");
        MenuItem miAboAddChannelThemeTitle = new MenuItem("Abo mit Sender und Thema und Titel anlegen");
        MenuItem miAboChange = new MenuItem("Abo \u00e4ndern");
        MenuItem miAboDel = new MenuItem("Abo l\u00f6schen");
        miAboAddChannelTheme.setDisable(film == null);
        miAboAddChannelThemeTitle.setDisable(film == null);
        miAboChange.setDisable(film == null);
        miAboDel.setDisable(film == null);
        miAboAddFilter.setOnAction(a -> AboListFactory.addNewAboFromFilterButton(false));
        AboData aboData2 = aboData = film == null ? null : AboFactory.findAbo(false, film);
        if (aboData == null) {
            miAboAddChannelTheme.setOnAction(a -> AboListFactory.addNewAbo(1, film.getTheme(), film.getChannel(), film.getTheme(), ""));
            miAboAddChannelThemeTitle.setOnAction(a -> AboListFactory.addNewAbo(1, film.getTheme(), film.getChannel(), film.getTheme(), film.getTitle()));
            miAboChange.setDisable(true);
            miAboDel.setDisable(true);
        } else {
            miAboAddChannelTheme.setDisable(true);
            miAboAddChannelThemeTitle.setDisable(true);
            miAboChange.setOnAction(event -> AboListFactory.editAbo(aboData));
            miAboDel.setOnAction(event -> AboListFactory.deleteAbo(aboData));
        }
        submenuAbo.getItems().addAll((MenuItem[])new MenuItem[]{miAboAddChannelTheme, miAboAddChannelThemeTitle, miAboAddFilter, miAboChange, miAboDel});
        return submenuAbo;
    }

    public static Menu startFilmWithSet(ProgData progData, FilmDataMTP film) {
        SetDataList list = progData.setDataList.getSetDataListButton();
        if (!list.isEmpty()) {
            Menu submenuSet = new Menu("Film mit Set starten");
            list.forEach(setData -> {
                MenuItem item = new MenuItem(setData.getVisibleName());
                item.setDisable(film == null);
                item.setOnAction(event -> FilmPlayFactory.playFilmListWithSet(false, setData, ProgData.getInstance().filmGuiController.getSelList(true)));
                submenuSet.getItems().add(item);
            });
            return submenuSet;
        }
        return null;
    }

    private Menu addBlacklist(FilmDataMTP film) {
        Menu submenuBlacklist = new Menu("Blacklist");
        MenuItem miBlack = new MenuItem("Blacklist-Eintrag f\u00fcr den Film erstellen");
        miBlack.setOnAction(event -> BlacklistFactory.addBlackFilm(BlacklistFactory.BLACK_SRC.FILM));
        MenuItem miBlackSenderTheme = new MenuItem("Sender und Thema direkt in die Blacklist einf\u00fcgen");
        miBlackSenderTheme.setOnAction(event -> BlacklistFactory.addBlack(1, film.getChannel(), film.getTheme(), ""));
        MenuItem miBlackTheme = new MenuItem("Thema direkt in die Blacklist einf\u00fcgen");
        miBlackTheme.setOnAction(event -> BlacklistFactory.addBlack(1, "", film.getTheme(), ""));
        MenuItem miBlackTitle = new MenuItem("Titel direkt in die Blacklist einf\u00fcgen");
        miBlackTitle.setOnAction(event -> BlacklistFactory.addBlack(1, "", "", film.getTitle()));
        miBlack.setDisable(film == null);
        miBlackSenderTheme.setDisable(film == null);
        miBlackTheme.setDisable(film == null);
        miBlackTitle.setDisable(film == null);
        submenuBlacklist.getItems().addAll((MenuItem[])new MenuItem[]{miBlack, miBlackSenderTheme, miBlackTheme, miBlackTitle});
        return submenuBlacklist;
    }

    private Menu addBookmark(FilmDataMTP film) {
        Menu submenuBookmark = new Menu("Bookmark");
        MenuItem miBookmarkAdd = new MenuItem("neues Bookmark anlegen");
        MenuItem miBookmarkDel = new MenuItem("Bookmark l\u00f6schen");
        MenuItem miBookmarkDelAll = new MenuItem("alle Bookmarks l\u00f6schen");
        if (film != null && film.isBookmark()) {
            miBookmarkDel.setOnAction(a -> BookmarkFactory.removeBookmark(film));
            miBookmarkAdd.setDisable(true);
        } else {
            miBookmarkDel.setDisable(true);
            miBookmarkAdd.setOnAction(a -> BookmarkFactory.addBookmark(false, film));
        }
        miBookmarkDelAll.setOnAction(a -> BookmarkFactory.deleteAll(this.progData.primaryStage));
        miBookmarkAdd.setDisable(film == null);
        miBookmarkDel.setDisable(film == null);
        miBookmarkDelAll.setDisable(film == null);
        submenuBookmark.getItems().addAll((MenuItem[])new MenuItem[]{miBookmarkAdd, miBookmarkDel, new SeparatorMenuItem(), miBookmarkDelAll});
        return submenuBookmark;
    }

    private Menu addFilm(FilmDataMTP film) {
        MenuItem miFilmsSetShown;
        Menu submenuFilm = new Menu("Film");
        MenuItem miLoadUt = new MenuItem("Untertitel speichern");
        miLoadUt.setDisable(film == null || film.getUrlSubtitle().isEmpty());
        miLoadUt.setOnAction(a -> StartDownloadFactory.downloadSubtitle(false, film, true));
        MenuItem miLoadTxt = new MenuItem("Info-Datei speichern");
        miLoadTxt.setDisable(film == null);
        miLoadTxt.setOnAction(a -> StartDownloadFactory.downloadSubtitle(false, film, false));
        if (film != null && film.isShown()) {
            miFilmsSetShown = new MenuItem("Filme als ungesehen markieren");
            miFilmsSetShown.setOnAction(a -> this.filmGuiController.setFilmShown(false));
        } else {
            miFilmsSetShown = new MenuItem("Filme als gesehen markieren");
            miFilmsSetShown.setOnAction(a -> this.filmGuiController.setFilmShown(true));
        }
        miFilmsSetShown.setDisable(film == null);
        MenuItem miFilmInfo = new MenuItem("Filminformation anzeigen");
        miFilmInfo.setDisable(film == null);
        miFilmInfo.setOnAction(a -> this.filmGuiController.showFilmInfo());
        MenuItem miMediaDb = new MenuItem("Film in der Mediensammlung suchen");
        miMediaDb.setDisable(film == null);
        miMediaDb.setOnAction(a -> this.filmGuiController.searchFilmInMediaCollection());
        submenuFilm.getItems().addAll((MenuItem[])new MenuItem[]{miLoadUt, miLoadTxt, miFilmsSetShown, miFilmInfo, miMediaDb});
        return submenuFilm;
    }

    public static Menu copyInfos(FilmDataMTP film) {
        String uSub;
        Menu subMenuURL = new Menu("Film-Infos kopieren");
        subMenuURL.setDisable(film == null);
        MenuItem miCopyTheme = new MenuItem("Thema");
        miCopyTheme.setDisable(film == null);
        miCopyTheme.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getTheme()));
        MenuItem miCopyName = new MenuItem("Titel");
        miCopyName.setDisable(film == null);
        miCopyName.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getTitle()));
        MenuItem miCopyWeb = new MenuItem("Website-URL");
        miCopyWeb.setDisable(film == null);
        miCopyWeb.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getWebsite()));
        subMenuURL.getItems().addAll((MenuItem[])new MenuItem[]{miCopyTheme, miCopyName, miCopyWeb});
        String uNormal = film == null ? "" : film.getUrlForResolution("normal");
        String uHd = film == null ? "" : film.getUrlForResolution("hd");
        String uLow = film == null ? "" : film.getUrlForResolution("small");
        String string = uSub = film == null ? "" : film.getUrlSubtitle();
        if (uHd.equals(uNormal)) {
            uHd = "";
        }
        if (uLow.equals(uNormal)) {
            uLow = "";
        }
        if (!(uHd.isEmpty() && uLow.isEmpty() && uSub.isEmpty())) {
            MenuItem item;
            subMenuURL.getItems().add(new SeparatorMenuItem());
            if (!uHd.isEmpty()) {
                item = new MenuItem("URL in HD-Aufl\u00f6sung");
                item.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getUrlForResolution("hd")));
                subMenuURL.getItems().add(item);
            }
            item = new MenuItem("URL in hoher Aufl\u00f6sung");
            item.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getUrlForResolution("normal")));
            subMenuURL.getItems().add(item);
            if (!uLow.isEmpty()) {
                item = new MenuItem("URL in kleiner Aufl\u00f6sung");
                item.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getUrlForResolution("small")));
                subMenuURL.getItems().add(item);
            }
            if (!film.getUrlSubtitle().isEmpty()) {
                subMenuURL.getItems().add(new SeparatorMenuItem());
                item = new MenuItem("Untertitel-URL");
                item.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getUrlSubtitle()));
                subMenuURL.getItems().add(item);
            }
        } else {
            MenuItem item = new MenuItem("Film-URL");
            item.setDisable(film == null);
            item.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getUrlForResolution("normal")));
            subMenuURL.getItems().add(item);
        }
        return subMenuURL;
    }
}

