/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.MTPlayerFactory;
import de.p2tools.mtplayer.controller.config.PShortKeyFactory;
import de.p2tools.mtplayer.controller.config.PShortcut;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFactory;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.data.film.FilmSaveFactory;
import de.p2tools.mtplayer.controller.filter.FilmFilter;
import de.p2tools.mtplayer.controller.filter.film.FilmFilterSamples;
import de.p2tools.mtplayer.gui.ToolBarButton;
import de.p2tools.mtplayer.gui.dialog.BookmarkDialogController;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.shortcut.P2ShortcutWorker;
import java.util.Optional;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;

public class FilmMenu {
    private final VBox vBox;
    private final ProgData progData;
    private FilmFilter storedActFilterSettings = null;
    private static final String FILM_FILTER_BOOKMARK_TEXT = "Alle angelegte Bookmarks anzeigen\nder zweite Klick stellt den\neingestellten Filter wieder her";
    private static final String FILM_SHOW_BOOKMARK_TEXT = "Alle Bookmarks in einem Dialog anzeigen";

    public FilmMenu(VBox vBox) {
        this.vBox = vBox;
        this.progData = ProgData.getInstance();
    }

    public void init() {
        this.vBox.getChildren().clear();
        this.initFilmMenu();
        this.initButton();
    }

    private void initButton() {
        VBox vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(0.0);
        vBoxSpace.setMinHeight(0.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btPlay = new ToolBarButton(this.vBox, "Abspielen", "Markierten Film abspielen", ProgIcons.ICON_TOOLBAR_START.getImageView());
        ToolBarButton btPlayAll = new ToolBarButton(this.vBox, "Alle Abspielen", "Alle markierten Filme abspielen", ProgIcons.ICON_TOOLBAR_START_ALL.getImageView());
        ToolBarButton btSave = new ToolBarButton(this.vBox, "Speichern", "Markierte Filme speichern", ProgIcons.ICON_TOOLBAR_REC.getImageView());
        btPlay.setOnAction(a -> {
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().filmGuiController.getSel(true, true);
            if (filmSelection.isPresent()) {
                FilmPlayFactory.playFilm(false, filmSelection.get());
                this.progData.filmGuiController.tableView.refresh();
                this.progData.filmGuiController.tableView.requestFocus();
            }
        });
        btPlayAll.setOnAction(a -> {
            FilmPlayFactory.playFilmList(false, ProgData.getInstance().filmGuiController.getSelList(true));
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        btSave.setOnAction(a -> {
            FilmSaveFactory.saveFilmList();
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(10.0);
        vBoxSpace.setMinHeight(10.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btBookmark = new ToolBarButton(this.vBox, "Bookmarks anlegen", "Bookmarks f\u00fcr die markierten Filme anlegen", ProgIcons.ICON_TOOLBAR_BOOKMARK.getImageView());
        ToolBarButton btDelBookmark = new ToolBarButton(this.vBox, "Bookmarks l\u00f6schen", "Bookmarks f\u00fcr die markierten Filme l\u00f6schen", ProgIcons.ICON_TOOLBAR_DEL_BOOKMARK.getImageView());
        ToolBarButton btDelAllBookmark = new ToolBarButton(this.vBox, "Alle Bookmarks l\u00f6schen", "Alle angelegten Bookmarks l\u00f6schen", ProgIcons.ICON_TOOLBAR_DEL_ALL_BOOKMARK.getImageView());
        ToolBarButton btFilterBookmark = new ToolBarButton(this.vBox, "Bookmarks anzeigen", FILM_FILTER_BOOKMARK_TEXT, ProgIcons.ICON_TOOLBAR_BOOKMARK_FILTER.getImageView());
        ToolBarButton btShowBookmark = new ToolBarButton(this.vBox, "Alle Bookmarks anzeigen", FILM_SHOW_BOOKMARK_TEXT, ProgIcons.ICON_TOOLBAR_BOOKMARK_DIALOG.getImageView());
        btBookmark.setOnAction(a -> {
            BookmarkFactory.addBookmarkList(false, this.progData.filmGuiController.getSelList(true));
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        btDelBookmark.setOnAction(a -> {
            BookmarkFactory.removeBookmarkList(this.progData.filmGuiController.getSelList(true));
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        btDelAllBookmark.setOnAction(a -> {
            BookmarkFactory.deleteAll(this.progData.primaryStage);
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        btFilterBookmark.setOnAction(a -> {
            FilmFilter bookmarkFilter;
            FilmFilter sf = this.progData.filterWorkerFilm.getActFilterSettings();
            if (sf.isSame(bookmarkFilter = FilmFilterSamples.getBookmarkFilter())) {
                if (this.storedActFilterSettings != null) {
                    this.storedActFilterSettings.setOnlyBookmark(false);
                    this.progData.filterWorkerFilm.setActFilterSettings(this.storedActFilterSettings);
                    this.storedActFilterSettings = null;
                } else {
                    this.progData.filterWorkerFilm.getActFilterSettings().clearFilter();
                }
            } else {
                this.storedActFilterSettings = this.progData.filterWorkerFilm.getActFilterSettings().getCopy();
                this.progData.filterWorkerFilm.setActFilterSettings(bookmarkFilter);
            }
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        btShowBookmark.setOnAction(a -> {
            if (this.progData.bookmarkDialogController != null) {
                this.progData.bookmarkDialogController.showDialog();
            } else {
                new BookmarkDialogController(this.progData);
            }
        });
        this.vBox.getChildren().add(P2GuiTools.getVDistance(10));
    }

    private void initFilmMenu() {
        MenuButton mb = new MenuButton("");
        mb.setTooltip(new Tooltip("Filmmen\u00fc anzeigen"));
        mb.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        mb.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-0"});
        MenuItem mbPlay = new MenuItem("Film abspielen");
        mbPlay.setOnAction(a -> {
            if (!MTPlayerController.TAB_FILM_ON.get()) {
                return;
            }
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().filmGuiController.getSel(true, true);
            filmSelection.ifPresent(film -> FilmPlayFactory.playFilm(false, film));
        });
        P2ShortcutWorker.addShortCut(mbPlay, PShortcut.SHORTCUT_PLAY_FILM);
        MenuItem mbPlayAll = new MenuItem("Alle markierten Film abspielen");
        mbPlayAll.setOnAction(a -> {
            if (!MTPlayerController.TAB_FILM_ON.get()) {
                return;
            }
            FilmPlayFactory.playFilmList(false, ProgData.getInstance().filmGuiController.getSelList(true));
        });
        P2ShortcutWorker.addShortCut(mbPlayAll, PShortcut.SHORTCUT_PLAY_FILM_ALL);
        MenuItem mbSave = new MenuItem("Film speichern");
        mbSave.setOnAction(e -> {
            if (!MTPlayerController.TAB_FILM_ON.get()) {
                return;
            }
            FilmSaveFactory.saveFilmList();
        });
        P2ShortcutWorker.addShortCut(mbSave, PShortcut.SHORTCUT_SAVE_FILM);
        mb.getItems().addAll((MenuItem[])new MenuItem[]{mbPlay, mbPlayAll, mbSave});
        mb.getItems().add(new SeparatorMenuItem());
        MenuItem miFilmShown = new MenuItem("Filme als gesehen markieren");
        miFilmShown.setOnAction(a -> {
            if (!MTPlayerController.TAB_FILM_ON.get()) {
                return;
            }
            this.progData.filmGuiController.setFilmShown(true);
        });
        P2ShortcutWorker.addShortCut(miFilmShown, PShortcut.SHORTCUT_FILM_SHOWN);
        MenuItem miFilmNotShown = new MenuItem("Filme als ungesehen markieren");
        miFilmNotShown.setOnAction(a -> {
            if (!MTPlayerController.TAB_FILM_ON.get()) {
                return;
            }
            this.progData.filmGuiController.setFilmShown(false);
        });
        P2ShortcutWorker.addShortCut(miFilmNotShown, PShortcut.SHORTCUT_FILM_NOT_SHOWN);
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miFilmShown, miFilmNotShown});
        MenuItem miFilmInfo = new MenuItem("Filminformation anzeigen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_INFO_FILM.getActShortcut());
        miFilmInfo.setOnAction(a -> this.progData.filmGuiController.showFilmInfo());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miFilmInfo});
        mb.getItems().addAll((MenuItem[])new MenuItem[]{FilmMenu.copyInfos(this.progData)});
        mb.getItems().add(new SeparatorMenuItem());
        MenuItem miFilmMediaCollection = new MenuItem("Film in der Mediensammlung suchen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SEARCH_FILM_IN_MEDIACOLLECTION.getActShortcut());
        miFilmMediaCollection.setOnAction(a -> this.progData.filmGuiController.searchFilmInMediaCollection());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miFilmMediaCollection});
        Menu submenuBlacklist = new Menu("Blacklist");
        MenuItem miBlack = new MenuItem("Blacklist-Eintrag f\u00fcr den Film erstellen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_ADD_BLACKLIST.getActShortcut());
        miBlack.setOnAction(event -> BlacklistFactory.addBlackFilm(BlacklistFactory.BLACK_SRC.FILM));
        MenuItem miBlackTheme = new MenuItem("Thema direkt in die Blacklist einf\u00fcgen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_ADD_BLACKLIST_THEME.getActShortcut());
        miBlackTheme.setOnAction(event -> BlacklistFactory.addBlackThemeFilm(BlacklistFactory.BLACK_SRC.FILM));
        submenuBlacklist.getItems().addAll((MenuItem[])new MenuItem[]{miBlack, miBlackTheme});
        mb.getItems().addAll((MenuItem[])new MenuItem[]{submenuBlacklist});
        Menu submenuBookmark = new Menu("Bookmarks");
        MenuItem miBookmarkAdd = new MenuItem("Neue Bookmarks anlegen");
        miBookmarkAdd.setOnAction(a -> BookmarkFactory.addBookmarkList(false, this.progData.filmGuiController.getSelList(true)));
        MenuItem miBookmarkDel = new MenuItem("Bookmarks l\u00f6schen");
        miBookmarkDel.setOnAction(a -> BookmarkFactory.removeBookmarkList(this.progData.filmGuiController.getSelList(true)));
        MenuItem miBookmarkDelAll = new MenuItem("Alle angelegten Bookmarks l\u00f6schen");
        miBookmarkDelAll.setOnAction(a -> BookmarkFactory.deleteAll(this.progData.primaryStage));
        submenuBookmark.getItems().addAll((MenuItem[])new MenuItem[]{miBookmarkAdd, miBookmarkDel, miBookmarkDelAll});
        mb.getItems().add(submenuBookmark);
        CheckMenuItem miSmallFilter = new CheckMenuItem("Einfachen Filter anzeigen");
        miSmallFilter.selectedProperty().bindBidirectional(ProgConfig.FILMFILTER_SMALL_FILTER);
        MenuItem miShowFilter = new MenuItem("Filter ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_FILTER.getActShortcut());
        miShowFilter.disableProperty().bind(ProgConfig.FILM__FILTER_IS_RIP);
        miShowFilter.setOnAction(a -> MTPlayerFactory.setFilter());
        MenuItem miShowInfo = new MenuItem("Infos ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_INFOS.getActShortcut());
        miShowInfo.disableProperty().bind(ProgConfig.FILM__INFO_PANE_IS_RIP.and(ProgConfig.FILM__BUTTON_PANE_IS_RIP).and(ProgConfig.FILM__MEDIA_PANE_IS_RIP));
        miShowInfo.setOnAction(a -> MTPlayerFactory.setInfos());
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miSmallFilter, miShowFilter, miShowInfo});
        this.vBox.getChildren().add(mb);
    }

    public static Menu copyInfos(ProgData progData) {
        Menu subMenuURL = new Menu("Film-Infos kopieren");
        MenuItem miCopyTheme = new MenuItem("Thema");
        miCopyTheme.setOnAction(a -> progData.filmGuiController.copyFilmThemeTitle(true));
        MenuItem miCopyName = new MenuItem("Titel");
        miCopyName.setOnAction(a -> progData.filmGuiController.copyFilmThemeTitle(false));
        MenuItem miCopyWeb = new MenuItem("Website-URL");
        miCopyWeb.setOnAction(a -> progData.filmGuiController.copyWebsite());
        MenuItem miCopyHd = new MenuItem("URL in HD-Aufl\u00f6sung");
        miCopyHd.setOnAction(a -> progData.filmGuiController.copyUrl("hd"));
        MenuItem miCopyUrl = new MenuItem("URL in hoher Aufl\u00f6sung");
        miCopyUrl.setOnAction(a -> progData.filmGuiController.copyUrl("normal"));
        MenuItem miCopyLow = new MenuItem("URL in kleiner Aufl\u00f6sung");
        miCopyLow.setOnAction(a -> progData.filmGuiController.copyUrl("small"));
        subMenuURL.getItems().addAll((MenuItem[])new MenuItem[]{miCopyTheme, miCopyName, miCopyWeb});
        subMenuURL.getItems().add(new SeparatorMenuItem());
        subMenuURL.getItems().addAll((MenuItem[])new MenuItem[]{miCopyHd, miCopyUrl, miCopyLow});
        return subMenuURL;
    }
}

