/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.film.FilmToolsFactory;
import de.p2tools.mtplayer.gui.FilmTableContextMenu;
import de.p2tools.mtplayer.gui.dialog.FilmInfoDialogController;
import de.p2tools.mtplayer.gui.infoPane.InfoPaneFactory;
import de.p2tools.mtplayer.gui.infoPane.PaneFilmButton;
import de.p2tools.mtplayer.gui.infoPane.PaneFilmInfo;
import de.p2tools.mtplayer.gui.infoPane.PaneMedia;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;
import de.p2tools.mtplayer.gui.mediadialog.MediaDialogController;
import de.p2tools.mtplayer.gui.tools.table.Table;
import de.p2tools.mtplayer.gui.tools.table.TableFilm;
import de.p2tools.mtplayer.gui.tools.table.TableRowFilm;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2RowFactory;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import de.p2tools.p2lib.tools.P2ToolsFactory;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;

public class FilmGuiController
extends AnchorPane {
    private final SplitPane splitPane = new SplitPane();
    private final ScrollPane scrollPaneTableFilm = new ScrollPane();
    public final TableFilm tableView;
    private final ProgData progData;
    private final SortedList<FilmDataMTP> sortedList;
    private final KeyCombination STRG_A = new KeyCodeCombination(KeyCode.A, KeyCombination.CONTROL_ANY);
    private boolean setShown = false;
    private final PaneFilmInfo paneFilmInfo;
    private final PaneFilmButton paneButton;
    private final PaneMedia paneMedia;
    private final P2ClosePaneController closePaneController;
    private final BooleanProperty boundInfo = new SimpleBooleanProperty(false);

    public FilmGuiController() {
        this.progData = ProgData.getInstance();
        this.sortedList = this.progData.filmListFiltered.getSortedList();
        this.tableView = new TableFilm(Table.TABLE_ENUM.FILM, this.progData);
        AnchorPane.setLeftAnchor(this.splitPane, 0.0);
        AnchorPane.setBottomAnchor(this.splitPane, 0.0);
        AnchorPane.setRightAnchor(this.splitPane, 0.0);
        AnchorPane.setTopAnchor(this.splitPane, 0.0);
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.getChildren().addAll((Node[])new Node[]{this.splitPane});
        this.scrollPaneTableFilm.setFitToHeight(true);
        this.scrollPaneTableFilm.setFitToWidth(true);
        this.scrollPaneTableFilm.setContent(this.tableView);
        this.paneFilmInfo = new PaneFilmInfo(ProgConfig.FILM_PANE_INFO_DIVIDER);
        this.paneButton = new PaneFilmButton(PaneFilmButton.PANE.FILM);
        MediaDataDto mDtoMedia = new MediaDataDto();
        MediaDataDto mDtoAbo = new MediaDataDto();
        this.initDto(mDtoMedia, mDtoAbo);
        this.paneMedia = new PaneMedia(mDtoMedia, mDtoAbo);
        ArrayList<P2ClosePaneDto> list = new ArrayList<P2ClosePaneDto>();
        P2ClosePaneDto infoDto = new P2ClosePaneDto(this.paneFilmInfo, ProgConfig.FILM__INFO_PANE_IS_RIP, ProgConfig.FILM__INFO_DIALOG_SIZE, MTPlayerController.TAB_FILM_ON, "Beschreibung", "Beschreibung", false, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        infoDto = new P2ClosePaneDto(this.paneButton, ProgConfig.FILM__BUTTON_PANE_IS_RIP, ProgConfig.FILM__BUTTON_DIALOG_SIZE, MTPlayerController.TAB_FILM_ON, "Buttons", "Buttons", false, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        infoDto = new P2ClosePaneDto(this.paneMedia, ProgConfig.FILM__MEDIA_PANE_IS_RIP, ProgConfig.FILM__MEDIA_DIALOG_SIZE, MTPlayerController.TAB_FILM_ON, "Mediensammlung", "Mediensammlung", false, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        this.closePaneController = new P2ClosePaneController(list, ProgConfig.FILM__INFO_IS_SHOWING);
        ProgConfig.FILM__INFO_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.FILM__INFO_PANE_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.FILM__BUTTON_PANE_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.FILM__MEDIA_PANE_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        this.setInfoPane();
        this.initTable();
        this.initListener();
    }

    public void isShown() {
        this.setFilmInfos((FilmDataMTP)this.tableView.getSelectionModel().getSelectedItem());
        this.tableView.requestFocus();
    }

    public int getFilmCount() {
        return this.tableView.getItems().size();
    }

    public int getSelCount() {
        return this.tableView.getSelectionModel().getSelectedItems().size();
    }

    public void showFilmInfo() {
        FilmInfoDialogController.getInstanceAndShow().showFilmInfo();
    }

    public void copyFilmThemeTitle(boolean theme) {
        Optional<FilmDataMTP> filmSelection = this.getSel(false, true);
        filmSelection.ifPresent(mtp -> P2ToolsFactory.copyToClipboard(theme ? mtp.getTheme() : mtp.getTitle()));
    }

    public void copyUrl(String resolution) {
        Optional<FilmDataMTP> filmSelection = this.getSel(false, true);
        filmSelection.ifPresent(mtp -> P2ToolsFactory.copyToClipboard(mtp.getUrlForResolution(resolution)));
    }

    public void copyWebsite() {
        Optional<FilmDataMTP> filmSelection = this.getSel(false, true);
        filmSelection.ifPresent(mtp -> P2ToolsFactory.copyToClipboard(mtp.getWebsite()));
    }

    public ArrayList<FilmDataMTP> getSelList(boolean markSel) {
        ArrayList<FilmDataMTP> ret = new ArrayList<FilmDataMTP>(this.tableView.getSelectionModel().getSelectedItems());
        if (ret.isEmpty()) {
            P2Alert.showInfoNoSelection();
        } else if (markSel) {
            this.setLastShown(ret.get(0));
        }
        return ret;
    }

    public Optional<FilmDataMTP> getSel(boolean markSel, boolean show) {
        Optional<Object> mtp;
        int selectedTableRow = this.tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow >= 0) {
            mtp = Optional.of((FilmDataMTP)this.tableView.getSelectionModel().getSelectedItem());
        } else {
            if (show) {
                P2Alert.showInfoNoSelection();
            }
            mtp = Optional.empty();
        }
        if (markSel && mtp.isPresent()) {
            this.setLastShown((FilmDataMTP)mtp.get());
        }
        return mtp;
    }

    private void setLastShown(FilmDataMTP mtp) {
        boolean set = true;
        for (FilmDataMTP filmDataMTP : this.sortedList) {
            if (filmDataMTP == mtp) {
                set = false;
            }
            filmDataMTP.setWasHere(set);
        }
    }

    public void searchFilmInMediaCollection() {
        Optional<FilmDataMTP> film = this.getSel(false, true);
        film.ifPresent(mtp -> new MediaDialogController(mtp.getTheme(), mtp.getTitle()));
    }

    public void setFilmShown(boolean set) {
        ArrayList<FilmDataMTP> list = this.getSelList(true);
        if (list.isEmpty()) {
            return;
        }
        FilmToolsFactory.setFilmShown(list, set);
        this.setShown = true;
    }

    public void saveTable() {
        Table.saveTable(this.tableView, Table.TABLE_ENUM.FILM);
    }

    public void selectLastShown() {
        if (Platform.isFxApplicationThread()) {
            this.selectLastShown_();
            return;
        }
        Platform.runLater(this::selectLastShown_);
    }

    private void initListener() {
        ProgConfig.FILM__INFO_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
    }

    private void initTable() {
        Table.setTable(this.tableView);
        this.tableView.setItems(this.sortedList);
        this.sortedList.comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.setRowFactory(new P2RowFactory(tableView -> {
            TableRowFilm row = new TableRowFilm();
            row.setOnMouseClicked(event -> {
                if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2 && !row.isEmpty()) {
                    FilmInfoDialogController.getInstanceAndShow().showFilmInfo();
                }
            });
            row.hoverProperty().addListener(observable2 -> {
                FilmDataMTP filmDataMTP = (FilmDataMTP)row.getItem();
                if (row.isHover() && filmDataMTP != null) {
                    this.setFilmInfos(filmDataMTP);
                } else if (filmDataMTP == null) {
                    this.setFilmInfos((FilmDataMTP)tableView.getSelectionModel().getSelectedItem());
                }
            });
            return row;
        }));
        this.tableView.hoverProperty().addListener(o -> {
            if (!this.tableView.isHover()) {
                this.setFilmInfos((FilmDataMTP)this.tableView.getSelectionModel().getSelectedItem());
            }
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> Platform.runLater(() -> this.setFilmInfos((FilmDataMTP)this.tableView.getSelectionModel().getSelectedItem())));
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                Optional<FilmDataMTP> optionalFilm = this.getSel(true, false);
                FilmDataMTP film = optionalFilm.orElse(null);
                ContextMenu contextMenu = new FilmTableContextMenu(this.progData, this, this.tableView).getContextMenu(film);
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
            if (P2TableFactory.SPACE.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeDown(this.tableView);
                event.consume();
            }
            if (P2TableFactory.SPACE_SHIFT.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeUp(this.tableView);
                event.consume();
            }
            if (this.STRG_A.match((KeyEvent)event) && this.tableView.getItems().size() > 3000) {
                P2Log.sysLog("STRG-A: lange Liste -> verhindern");
                event.consume();
            }
        });
    }

    private void selectLastShown_() {
        P2Duration.counterStart("selectLastShown");
        if (this.setShown) {
            this.setShown = false;
            this.tableView.refresh();
            P2TableFactory.refreshTable(this.tableView);
            return;
        }
        if (this.tableView.getItems().isEmpty()) {
            return;
        }
        if (ProgConfig.SYSTEM_FILTER_NONE_ROW.get()) {
            this.tableView.refresh();
            P2TableFactory.refreshTable(this.tableView);
            return;
        }
        if (ProgConfig.SYSTEM_FILTER_FIRST_ROW.getValue().booleanValue()) {
            this.tableView.getSelectionModel().clearAndSelect(0);
            this.tableView.scrollTo(0);
            this.tableView.refresh();
            P2TableFactory.refreshTable(this.tableView);
            return;
        }
        FilmDataMTP filmDataMTP = (FilmDataMTP)this.tableView.getSelectionModel().getSelectedItem();
        if (filmDataMTP != null) {
            this.tableView.scrollTo(filmDataMTP);
        } else {
            for (int i = this.sortedList.size() - 1; i >= 0; --i) {
                FilmDataMTP film = this.sortedList.get(i);
                if (!film.isWasHere()) continue;
                this.tableView.getSelectionModel().select(film);
                this.tableView.scrollTo(film);
                break;
            }
        }
        this.setCenter();
        P2Duration.counterStop("selectLastShown");
    }

    private void setCenter() {
        int selected = this.tableView.getSelectionModel().getSelectedIndex();
        if (selected == -1) {
            this.tableView.refresh();
            P2TableFactory.refreshTable(this.tableView);
            return;
        }
        Platform.runLater(() -> {
            TableViewSkin skin = (TableViewSkin)this.tableView.getSkin();
            skin.getChildren().stream().filter(VirtualFlow.class::isInstance).map(VirtualFlow.class::cast).findAny().ifPresent(vf -> {
                vf.scrollToTop(selected);
                vf.layout();
                vf.scrollPixels(-vf.getHeight() / 2.0);
                this.tableView.refresh();
                P2TableFactory.refreshTable(this.tableView);
            });
        });
    }

    private void setFilmInfos(FilmDataMTP film) {
        if (InfoPaneFactory.paneIsVisible(MTPlayerController.TAB_FILM_ON, this.paneFilmInfo)) {
            this.paneFilmInfo.setFilm(film);
        }
        if (InfoPaneFactory.paneIsVisible(MTPlayerController.TAB_FILM_ON, this.paneMedia)) {
            this.paneMedia.setSearchPredicate(film);
        }
        FilmInfoDialogController.getInstance().setFilm(film);
    }

    private void setInfoPane() {
        P2ClosePaneFactory.setSplit(this.boundInfo, this.splitPane, this.closePaneController, false, this.scrollPaneTableFilm, ProgConfig.FILM__INFO_DIVIDER, ProgConfig.FILM__INFO_IS_SHOWING);
    }

    private void initDto(MediaDataDto mediaDataDtoMedia, MediaDataDto mediaDataDtoAbo) {
        mediaDataDtoMedia.whatToShow = MediaDataDto.SHOW_WHAT.SHOW_MEDIA;
        mediaDataDtoMedia.buildSearchFrom = ProgConfig.INFO_FILM_BUILD_SEARCH_FROM_FOR_MEDIA;
        mediaDataDtoMedia.searchInWhat = ProgConfig.INFO_FILM_SEARCH_IN_WHAT_FOR_MEDIA;
        mediaDataDtoMedia.cleaning = ProgConfig.INFO_FILM_CLEAN_MEDIA;
        mediaDataDtoMedia.cleaningExact = ProgConfig.INFO_FILM_CLEAN_EXACT_MEDIA;
        mediaDataDtoMedia.cleaningAndOr = ProgConfig.INFO_FILM_CLEAN_AND_OR_MEDIA;
        mediaDataDtoMedia.cleaningList = ProgConfig.INFO_FILM_CLEAN_LIST_MEDIA;
        mediaDataDtoAbo.whatToShow = MediaDataDto.SHOW_WHAT.SHOW_ABO;
        mediaDataDtoAbo.buildSearchFrom = ProgConfig.INFO_FILM_BUILD_SEARCH_FROM_FOR_ABO;
        mediaDataDtoAbo.searchInWhat = ProgConfig.INFO_FILM_SEARCH_IN_WHAT_FOR_ABO;
        mediaDataDtoAbo.cleaning = ProgConfig.INFO_FILM_CLEAN_ABO;
        mediaDataDtoAbo.cleaningExact = ProgConfig.INFO_FILM_CLEAN_EXACT_ABO;
        mediaDataDtoAbo.cleaningAndOr = ProgConfig.INFO_FILM_CLEAN_AND_OR_ABO;
        mediaDataDtoAbo.cleaningList = ProgConfig.INFO_FILM_CLEAN_LIST_ABO;
    }
}

