/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboListFactory;
import de.p2tools.mtplayer.controller.data.abo.AboSearchDownloadsFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactory;
import de.p2tools.mtplayer.gui.DownloadGuiController;
import de.p2tools.mtplayer.gui.tools.table.TableDownload;
import de.p2tools.p2lib.tools.P2ToolsFactory;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class DownloadTableContextMenu {
    private final ProgData progData;
    private final DownloadGuiController downloadGuiController;
    private final TableDownload tableView;

    public DownloadTableContextMenu(ProgData progData, DownloadGuiController downloadGuiController, TableDownload tableView) {
        this.progData = progData;
        this.downloadGuiController = downloadGuiController;
        this.tableView = tableView;
    }

    public ContextMenu getContextMenu(DownloadData download) {
        ContextMenu contextMenu = new ContextMenu();
        this.getMenu(contextMenu, download);
        return contextMenu;
    }

    private void getMenu(ContextMenu contextMenu, DownloadData download) {
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.addSubMenuDownload(download)});
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.addSubMenuAllDownload(download)});
        contextMenu.getItems().add(new SeparatorMenuItem());
        MenuItem miUndo = new MenuItem("Gel\u00f6schte wieder anlegen");
        miUndo.setDisable(this.progData.downloadList.getUndoList().isEmpty());
        miUndo.setOnAction(a -> this.progData.downloadList.undoDownloads());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miUndo});
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.addSubMenuFilm(download)});
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.addSubMenuAbo(download)});
        Menu mBlacklist = this.addBlacklist(download);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{mBlacklist});
        MenuItem miFilmInfo = new MenuItem("Filminformation anzeigen");
        miFilmInfo.setOnAction(a -> this.downloadGuiController.showFilmInfo());
        MenuItem miPlayUrl = new MenuItem("Film (URL) abspielen");
        miPlayUrl.setOnAction(a -> this.downloadGuiController.playUrl());
        MenuItem miCopyName = new MenuItem("Titel in die Zwischenablage kopieren");
        miCopyName.setOnAction(a -> P2ToolsFactory.copyToClipboard(download.getTitle()));
        MenuItem miCopyTheme = new MenuItem("Thema in die Zwischenablage kopieren");
        miCopyTheme.setOnAction(a -> P2ToolsFactory.copyToClipboard(download.getTheme()));
        MenuItem miCopyUrl = new MenuItem("Download (URL) kopieren");
        miCopyUrl.setOnAction(a -> this.downloadGuiController.copyUrl());
        MenuItem miMediaDb = new MenuItem("Download in der Mediensammlung suchen");
        miMediaDb.setOnAction(a -> this.downloadGuiController.searchFilmInMediaCollection());
        miFilmInfo.setDisable(download == null);
        miPlayUrl.setDisable(download == null);
        miCopyUrl.setDisable(download == null);
        miMediaDb.setDisable(download == null);
        miCopyName.setDisable(download == null);
        miCopyTheme.setDisable(download == null);
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miFilmInfo, miPlayUrl, new SeparatorMenuItem(), miCopyName, miCopyTheme, miCopyUrl, miMediaDb});
        MenuItem miSelectAll = new MenuItem("Alles ausw\u00e4hlen");
        miSelectAll.setOnAction(a -> this.tableView.getSelectionModel().selectAll());
        MenuItem miSelection = new MenuItem("Auswahl umkehren");
        miSelection.setOnAction(a -> this.downloadGuiController.invertSelection());
        miSelectAll.setDisable(download == null);
        miSelection.setDisable(download == null);
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miSelectAll, miSelection});
        contextMenu.getItems().add(new SeparatorMenuItem());
        CheckMenuItem smallTableRow = new CheckMenuItem("Nur kleine Button anzeigen");
        smallTableRow.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SMALL_TABLE_ROW_DOWNLOAD);
        CheckMenuItem toolTipTable = new CheckMenuItem("Infos beim \u00dcberfahren einer Zeile anzeigen");
        toolTipTable.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_GUI_SHOW_TABLE_TOOL_TIP);
        MenuItem resetTable = new MenuItem("Tabelle zur\u00fccksetzen");
        resetTable.setOnAction(a -> this.tableView.resetTable());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{smallTableRow, toolTipTable, resetTable});
    }

    private Menu addBlacklist(DownloadData downloadData) {
        Menu submenuBlacklist = new Menu("Blacklist");
        MenuItem miBlack = new MenuItem("Blacklist-Eintrag f\u00fcr den Film erstellen");
        miBlack.setOnAction(event -> BlacklistFactory.addBlackFilm(BlacklistFactory.BLACK_SRC.DOWNLOAD));
        MenuItem miBlackSenderTheme = new MenuItem("Sender und Thema direkt in die Blacklist einf\u00fcgen");
        miBlackSenderTheme.setOnAction(event -> BlacklistFactory.addBlack(0, downloadData.getChannel(), downloadData.getTheme(), ""));
        MenuItem miBlackTheme = new MenuItem("Thema direkt in die Blacklist einf\u00fcgen");
        miBlackTheme.setOnAction(event -> BlacklistFactory.addBlack(0, "", downloadData.getTheme(), ""));
        MenuItem miBlackTitle = new MenuItem("Titel direkt in die Blacklist einf\u00fcgen");
        miBlackTitle.setOnAction(event -> BlacklistFactory.addBlack(0, "", "", downloadData.getTitle()));
        miBlack.setDisable(downloadData == null);
        miBlackSenderTheme.setDisable(downloadData == null);
        miBlackTheme.setDisable(downloadData == null);
        miBlackTitle.setDisable(downloadData == null);
        submenuBlacklist.getItems().addAll((MenuItem[])new MenuItem[]{miBlack, miBlackSenderTheme, miBlackTheme, miBlackTitle});
        return submenuBlacklist;
    }

    private Menu addSubMenuFilm(DownloadData download) {
        Menu submenuFilm = new Menu("Gespeicherten Film");
        MenuItem miDownloadShown = new MenuItem("Filme als gesehen markieren");
        miDownloadShown.setOnAction(a -> this.downloadGuiController.setFilmShown());
        MenuItem miDownloadNotShown = new MenuItem("Filme als ungesehen markieren");
        miDownloadNotShown.setOnAction(a -> this.downloadGuiController.setFilmNotShown());
        MenuItem miPlayerDownload = new MenuItem("Gespeicherten Film (Datei) abspielen");
        miPlayerDownload.setOnAction(a -> this.downloadGuiController.playFilm());
        MenuItem miDeleteDownload = new MenuItem("Gespeicherten Film (Datei) l\u00f6schen");
        miDeleteDownload.setOnAction(a -> this.downloadGuiController.deleteFilmFile());
        MenuItem miOpenDir = new MenuItem("Zielordner \u00f6ffnen");
        miOpenDir.setOnAction(e -> this.downloadGuiController.openDestinationDir());
        miDownloadShown.setDisable(download == null);
        miDownloadNotShown.setDisable(download == null);
        miPlayerDownload.setDisable(download == null);
        miDeleteDownload.setDisable(download == null);
        miOpenDir.setDisable(download == null);
        submenuFilm.getItems().addAll((MenuItem[])new MenuItem[]{miDownloadShown, miDownloadNotShown, new SeparatorMenuItem(), miPlayerDownload, miDeleteDownload, miOpenDir});
        return submenuFilm;
    }

    private Menu addSubMenuAbo(DownloadData download) {
        MenuItem miChangeAbo = new MenuItem("Abo \u00e4ndern");
        MenuItem miDeactivateAbo = new MenuItem("Abo ausschalten");
        MenuItem miDelAbo = new MenuItem("Abo l\u00f6schen");
        miChangeAbo.setDisable(download == null);
        miDeactivateAbo.setDisable(download == null);
        miDelAbo.setDisable(download == null);
        if (download != null && download.getAbo() != null) {
            miChangeAbo.setOnAction(event -> AboListFactory.editAbo(download.getAbo()));
            miDeactivateAbo.setOnAction(event -> AboListFactory.setAboActive(download.getAbo(), false));
            miDelAbo.setOnAction(event -> AboListFactory.deleteAbo(download.getAbo()));
        } else {
            miChangeAbo.setDisable(true);
            miDeactivateAbo.setDisable(true);
            miDelAbo.setDisable(true);
        }
        Menu submenuAbo = new Menu("Abo");
        submenuAbo.getItems().addAll((MenuItem[])new MenuItem[]{miChangeAbo, miDeactivateAbo, miDelAbo});
        return submenuAbo;
    }

    private Menu addSubMenuDownload(DownloadData download) {
        Menu submenuDownload = new Menu("Downloads");
        MenuItem miStart = new MenuItem("Downloads starten");
        miStart.setOnAction(a -> this.downloadGuiController.startDownload(false));
        MenuItem miStop = new MenuItem("Downloads stoppen");
        miStop.setOnAction(a -> this.downloadGuiController.stopDownload(false));
        MenuItem miChange = new MenuItem("Downloads \u00e4ndern");
        miChange.setOnAction(a -> this.downloadGuiController.changeDownload());
        miStart.setDisable(download == null);
        miStop.setDisable(download == null);
        miChange.setDisable(download == null);
        submenuDownload.getItems().addAll((MenuItem[])new MenuItem[]{miStart, miStop, miChange});
        MenuItem miPrefer = new MenuItem("Downloads vorziehen");
        miPrefer.setOnAction(a -> this.downloadGuiController.preferDownload());
        MenuItem miPutBack = new MenuItem("Downloads zur\u00fcckstellen");
        miPutBack.setOnAction(a -> this.downloadGuiController.moveDownloadBack());
        MenuItem miRemove = new MenuItem("Downloads aus Liste entfernen");
        miRemove.setOnAction(a -> this.downloadGuiController.deleteDownloads());
        miPrefer.setDisable(download == null || !download.isStateStartedWaiting());
        miPutBack.setDisable(download == null);
        miRemove.setDisable(download == null);
        submenuDownload.getItems().add(new SeparatorMenuItem());
        submenuDownload.getItems().addAll((MenuItem[])new MenuItem[]{miPrefer, miPutBack, miRemove});
        return submenuDownload;
    }

    private Menu addSubMenuAllDownload(DownloadData download) {
        MenuItem miStartAll = new MenuItem("Alle Downloads starten");
        miStartAll.setOnAction(a -> this.downloadGuiController.startDownload(true));
        MenuItem miStartTimeAll = new MenuItem("Alle Downloads mit Startzeit starten");
        miStartTimeAll.setOnAction(a -> this.progData.downloadGuiController.startDownloadTime());
        MenuItem miStopAll = new MenuItem("Alle Downloads stoppen");
        miStopAll.setOnAction(a -> this.downloadGuiController.stopDownload(true));
        MenuItem miStopWaiting = new MenuItem("Alle wartenden Downloads stoppen");
        miStopWaiting.setOnAction(a -> this.downloadGuiController.stopWaitingDownloads());
        MenuItem miUpdate = new MenuItem("Liste der Downloads aktualisieren");
        miUpdate.setOnAction(e -> AboSearchDownloadsFactory.searchForDownloadsFromAbosAndMaybeStart());
        MenuItem miCleanUp = new MenuItem("Liste der Downloads aufr\u00e4umen");
        miCleanUp.setOnAction(e -> DownloadFactory.cleanUpList(this.progData.downloadList));
        miStartAll.setDisable(download == null);
        miStartTimeAll.setDisable(download == null);
        miStopAll.setDisable(download == null);
        miStopWaiting.setDisable(download == null);
        Menu submenuAllDownloads = new Menu("Alle Downloads");
        submenuAllDownloads.getItems().addAll((MenuItem[])new MenuItem[]{miStartAll, miStartTimeAll, miStopAll, miStopWaiting, new SeparatorMenuItem(), miUpdate, miCleanUp});
        return submenuAllDownloads;
    }
}

