/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkData;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.gui.tools.table.TableBookmark;
import de.p2tools.p2lib.tools.P2ToolsFactory;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class BookmarkTableContextMenu {
    private final ProgData progData;
    private final TableBookmark tableView;

    public BookmarkTableContextMenu(ProgData progData, TableBookmark tableView) {
        this.progData = progData;
        this.tableView = tableView;
    }

    public ContextMenu getContextMenu(BookmarkData bookmarkData) {
        ContextMenu contextMenu = new ContextMenu();
        if (bookmarkData != null) {
            if (bookmarkData.getFilmData() != null) {
                contextMenu.getItems().add(BookmarkTableContextMenu.copyInfos(bookmarkData.getFilmData()));
            } else {
                MenuItem item = new MenuItem("Film-URL kopieren");
                item.setOnAction(a -> P2ToolsFactory.copyToClipboard(bookmarkData.getUrl()));
                contextMenu.getItems().add(item);
            }
            contextMenu.getItems().add(new SeparatorMenuItem());
        }
        CheckMenuItem smallTableRow = new CheckMenuItem("Nur kleine Button anzeigen");
        smallTableRow.selectedProperty().bindBidirectional(ProgConfig.BOOKMARK_DIALOG_SMALL_TABLE_ROW);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{smallTableRow});
        CheckMenuItem toolTipTable = new CheckMenuItem("Infos beim \u00dcberfahren einer Zeile anzeigen");
        toolTipTable.selectedProperty().bindBidirectional(ProgConfig.BOOKMARK_DIALOG_SHOW_TABLE_TOOL_TIP);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{toolTipTable});
        MenuItem resetTable = new MenuItem("Tabelle zur\u00fccksetzen");
        resetTable.setOnAction(a -> this.tableView.resetTable());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{resetTable});
        return contextMenu;
    }

    public static Menu copyInfos(FilmDataMTP film) {
        String uSub;
        Menu subMenuURL = new Menu("Film-Infos kopieren");
        subMenuURL.setDisable(film == null);
        MenuItem miCopyTheme = new MenuItem("Thema");
        miCopyTheme.setDisable(film == null);
        miCopyTheme.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getTheme()));
        MenuItem miCopyName = new MenuItem("Titel");
        miCopyName.setDisable(film == null);
        miCopyName.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getTitle()));
        MenuItem miCopyWeb = new MenuItem("Website-URL");
        miCopyWeb.setDisable(film == null);
        miCopyWeb.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getWebsite()));
        subMenuURL.getItems().addAll((MenuItem[])new MenuItem[]{miCopyTheme, miCopyName, miCopyWeb});
        String uNormal = film == null ? "" : film.getUrlForResolution("normal");
        String uHd = film == null ? "" : film.getUrlForResolution("hd");
        String uLow = film == null ? "" : film.getUrlForResolution("small");
        String string = uSub = film == null ? "" : film.getUrlSubtitle();
        if (uHd.equals(uNormal)) {
            uHd = "";
        }
        if (uLow.equals(uNormal)) {
            uLow = "";
        }
        if (!(uHd.isEmpty() && uLow.isEmpty() && uSub.isEmpty())) {
            MenuItem item;
            subMenuURL.getItems().add(new SeparatorMenuItem());
            if (!uHd.isEmpty()) {
                item = new MenuItem("URL in HD-Aufl\u00f6sung");
                item.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getUrlForResolution("hd")));
                subMenuURL.getItems().add(item);
            }
            item = new MenuItem("URL in hoher Aufl\u00f6sung");
            item.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getUrlForResolution("normal")));
            subMenuURL.getItems().add(item);
            if (!uLow.isEmpty()) {
                item = new MenuItem("URL in kleiner Aufl\u00f6sung");
                item.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getUrlForResolution("small")));
                subMenuURL.getItems().add(item);
            }
            if (!film.getUrlSubtitle().isEmpty()) {
                subMenuURL.getItems().add(new SeparatorMenuItem());
                item = new MenuItem("Untertitel-URL");
                item.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getUrlSubtitle()));
                subMenuURL.getItems().add(item);
            }
        } else {
            MenuItem item = new MenuItem("Film-URL");
            item.setDisable(film == null);
            item.setOnAction(a -> P2ToolsFactory.copyToClipboard(film.getUrlForResolution("normal")));
            subMenuURL.getItems().add(item);
        }
        return subMenuURL;
    }
}

