/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.mtplayer.controller.data.abo.AboListFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFactory;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.data.film.FilmSaveFactory;
import de.p2tools.mtplayer.controller.data.setdata.SetDataList;
import de.p2tools.mtplayer.controller.starter.StartDownloadFactory;
import de.p2tools.mtplayer.gui.AudioGuiController;
import de.p2tools.mtplayer.gui.tools.table.TableAudio;
import de.p2tools.p2lib.tools.P2ToolsFactory;
import java.util.Optional;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class AudioTableContextMenu {
    private final ProgData progData;
    private final AudioGuiController audioGuiController;
    private final TableAudio tableView;

    public AudioTableContextMenu(ProgData progData, AudioGuiController audioGuiController, TableAudio tableView) {
        this.progData = progData;
        this.audioGuiController = audioGuiController;
        this.tableView = tableView;
    }

    public ContextMenu getContextMenu(FilmDataMTP audio) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem miStart = new MenuItem("Audio abspielen");
        miStart.setOnAction(a -> {
            Optional<FilmDataMTP> sel = ProgData.getInstance().audioGuiController.getSel(true, true);
            sel.ifPresent(f -> FilmPlayFactory.playFilm(true, f));
        });
        MenuItem miSave = new MenuItem("Audio speichern");
        miSave.setOnAction(a -> FilmSaveFactory.saveAudioList());
        miStart.setDisable(audio == null);
        miSave.setDisable(audio == null);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miStart, miSave});
        Menu mFilter = this.addFilter(audio);
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{mFilter});
        Menu mStartFilm = AudioTableContextMenu.startFilmWithSet(this.progData, audio);
        if (mStartFilm != null) {
            contextMenu.getItems().add(mStartFilm);
        }
        Menu mCopyUrl = AudioTableContextMenu.copyInfos(audio);
        Menu mFilm = this.addFilm(audio);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{mCopyUrl, mFilm});
        Menu mAddAbo = this.addAbo(audio);
        Menu mBlacklist = this.addBlacklist(audio);
        Menu mBookmark = this.addBookmark(audio);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{new SeparatorMenuItem(), mAddAbo, mBlacklist, mBookmark});
        contextMenu.getItems().add(new SeparatorMenuItem());
        CheckMenuItem smallTableRow = new CheckMenuItem("Nur kleine Button anzeigen");
        smallTableRow.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SMALL_TABLE_ROW_AUDIO);
        CheckMenuItem toolTipTable = new CheckMenuItem("Infos beim \u00dcberfahren einer Zeile anzeigen");
        toolTipTable.selectedProperty().bindBidirectional(ProgConfig.AUDIO_GUI_SHOW_TABLE_TOOL_TIP);
        MenuItem resetTable = new MenuItem("Tabelle zur\u00fccksetzen");
        resetTable.setOnAction(a -> this.tableView.resetTable());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{smallTableRow, toolTipTable, resetTable});
        return contextMenu;
    }

    private Menu addFilter(FilmDataMTP film) {
        Menu submenuFilter = new Menu("Filter");
        MenuItem miFilterChannel = new MenuItem("nach Sender filtern");
        miFilterChannel.setOnAction(event -> this.progData.filterWorkerAudio.getActFilterSettings().setChannelAndVis(film.getChannel()));
        MenuItem miFilterTheme = new MenuItem("nach Thema filtern");
        miFilterTheme.setOnAction(event -> this.progData.filterWorkerAudio.getActFilterSettings().setThemeAndVis(film.getTheme(), false));
        MenuItem miFilterChannelTheme = new MenuItem("nach Sender und Thema filtern");
        miFilterChannelTheme.setOnAction(event -> {
            this.progData.filterWorkerAudio.getActFilterSettings().setChannelAndVis(film.getChannel());
            this.progData.filterWorkerAudio.getActFilterSettings().setThemeAndVis(film.getTheme(), false);
        });
        MenuItem miFilterChannelThemeTitle = new MenuItem("nach Sender, Thema und Titel filtern");
        miFilterChannelThemeTitle.setOnAction(event -> {
            this.progData.filterWorkerAudio.getActFilterSettings().setChannelAndVis(film.getChannel());
            this.progData.filterWorkerAudio.getActFilterSettings().setThemeAndVis(film.getTheme(), false);
            this.progData.filterWorkerAudio.getActFilterSettings().setTitleAndVis(film.getTitle());
        });
        miFilterChannel.setDisable(film == null);
        miFilterTheme.setDisable(film == null);
        miFilterChannelTheme.setDisable(film == null);
        miFilterChannelThemeTitle.setDisable(film == null);
        submenuFilter.getItems().addAll((MenuItem[])new MenuItem[]{miFilterChannel, miFilterTheme, miFilterChannelTheme, miFilterChannelThemeTitle});
        return submenuFilter;
    }

    private Menu addAbo(FilmDataMTP film) {
        AboData aboData;
        Menu submenuAbo = new Menu("Abo");
        MenuItem miAboAddFilter = new MenuItem("Aus dem Filter ein Abo erstellen");
        MenuItem miAboAddChannelTheme = new MenuItem("Abo mit Sender und Thema anlegen");
        MenuItem miAboAddChannelThemeTitle = new MenuItem("Abo mit Sender und Thema und Titel anlegen");
        MenuItem miAboChange = new MenuItem("Abo \u00e4ndern");
        MenuItem miAboDel = new MenuItem("Abo l\u00f6schen");
        miAboAddChannelTheme.setDisable(film == null);
        miAboAddChannelThemeTitle.setDisable(film == null);
        miAboChange.setDisable(film == null);
        miAboDel.setDisable(film == null);
        miAboAddFilter.setOnAction(a -> AboListFactory.addNewAboFromFilterButton(true));
        AboData aboData2 = aboData = film == null ? null : AboFactory.findAbo(true, film);
        if (aboData == null) {
            miAboAddChannelTheme.setOnAction(a -> AboListFactory.addNewAbo(2, film.getTheme(), film.getChannel(), film.getTheme(), ""));
            miAboAddChannelThemeTitle.setOnAction(a -> AboListFactory.addNewAbo(2, film.getTheme(), film.getChannel(), film.getTheme(), film.getTitle()));
            miAboChange.setDisable(true);
            miAboDel.setDisable(true);
        } else {
            miAboAddChannelTheme.setDisable(true);
            miAboAddChannelThemeTitle.setDisable(true);
            miAboChange.setOnAction(event -> AboListFactory.editAbo(aboData));
            miAboDel.setOnAction(event -> AboListFactory.deleteAbo(aboData));
        }
        submenuAbo.getItems().addAll((MenuItem[])new MenuItem[]{miAboAddChannelTheme, miAboAddChannelThemeTitle, miAboAddFilter, miAboChange, miAboDel});
        return submenuAbo;
    }

    public static Menu startFilmWithSet(ProgData progData, FilmDataMTP audio) {
        SetDataList list = progData.setDataList.getSetDataListButton();
        if (!list.isEmpty()) {
            Menu submenuSet = new Menu("Audio mit Set starten");
            list.forEach(setData -> {
                MenuItem item = new MenuItem(setData.getVisibleName());
                item.setDisable(audio == null);
                item.setOnAction(event -> FilmPlayFactory.playFilmListWithSet(true, setData, ProgData.getInstance().audioGuiController.getSelList(true)));
                submenuSet.getItems().add(item);
            });
            return submenuSet;
        }
        return null;
    }

    private Menu addBlacklist(FilmDataMTP film) {
        Menu submenuBlacklist = new Menu("Blacklist");
        MenuItem miBlack = new MenuItem("Blacklist-Eintrag f\u00fcr das Audio erstellen");
        miBlack.setOnAction(event -> BlacklistFactory.addBlackFilm(BlacklistFactory.BLACK_SRC.AUDIO));
        MenuItem miBlackSenderTheme = new MenuItem("Sender und Thema direkt in die Blacklist einf\u00fcgen");
        miBlackSenderTheme.setOnAction(event -> BlacklistFactory.addBlack(2, film.getChannel(), film.getTheme(), ""));
        MenuItem miBlackTheme = new MenuItem("Thema direkt in die Blacklist einf\u00fcgen");
        miBlackTheme.setOnAction(event -> BlacklistFactory.addBlack(2, "", film.getTheme(), ""));
        MenuItem miBlackTitle = new MenuItem("Titel direkt in die Blacklist einf\u00fcgen");
        miBlackTitle.setOnAction(event -> BlacklistFactory.addBlack(2, "", "", film.getTitle()));
        miBlack.setDisable(film == null);
        miBlackSenderTheme.setDisable(film == null);
        miBlackTheme.setDisable(film == null);
        miBlackTitle.setDisable(film == null);
        submenuBlacklist.getItems().addAll((MenuItem[])new MenuItem[]{miBlack, miBlackSenderTheme, miBlackTheme, miBlackTitle});
        return submenuBlacklist;
    }

    private Menu addBookmark(FilmDataMTP film) {
        Menu submenuBookmark = new Menu("Bookmark");
        MenuItem miBookmarkAdd = new MenuItem("neues Bookmark anlegen");
        MenuItem miBookmarkDel = new MenuItem("Bookmark l\u00f6schen");
        MenuItem miBookmarkDelAll = new MenuItem("alle Bookmarks l\u00f6schen");
        if (film != null && film.isBookmark()) {
            miBookmarkDel.setOnAction(a -> BookmarkFactory.removeBookmark(film));
            miBookmarkAdd.setDisable(true);
        } else {
            miBookmarkDel.setDisable(true);
            miBookmarkAdd.setOnAction(a -> BookmarkFactory.addBookmark(true, film));
        }
        miBookmarkDelAll.setOnAction(a -> BookmarkFactory.deleteAll(this.progData.primaryStage));
        miBookmarkAdd.setDisable(film == null);
        miBookmarkDel.setDisable(film == null);
        miBookmarkDelAll.setDisable(film == null);
        submenuBookmark.getItems().addAll((MenuItem[])new MenuItem[]{miBookmarkAdd, miBookmarkDel, new SeparatorMenuItem(), miBookmarkDelAll});
        return submenuBookmark;
    }

    private Menu addFilm(FilmDataMTP film) {
        MenuItem miFilmsSetShown;
        Menu submenuFilm = new Menu("Audio");
        MenuItem miLoadTxt = new MenuItem("Info-Datei speichern");
        miLoadTxt.setDisable(film == null);
        miLoadTxt.setOnAction(a -> StartDownloadFactory.downloadSubtitle(true, film, false));
        if (film != null && film.isShown()) {
            miFilmsSetShown = new MenuItem("Audio als ungesehen markieren");
            miFilmsSetShown.setOnAction(a -> this.audioGuiController.setFilmShown(false));
        } else {
            miFilmsSetShown = new MenuItem("Audio als gesehen markieren");
            miFilmsSetShown.setOnAction(a -> this.audioGuiController.setFilmShown(true));
        }
        miFilmsSetShown.setDisable(film == null);
        MenuItem miFilmInfo = new MenuItem("Audioinformation anzeigen");
        miFilmInfo.setDisable(film == null);
        miFilmInfo.setOnAction(a -> this.audioGuiController.showFilmInfo());
        MenuItem miMediaDb = new MenuItem("Audio in der Mediensammlung suchen");
        miMediaDb.setDisable(film == null);
        miMediaDb.setOnAction(a -> this.audioGuiController.searchFilmInMediaCollection());
        submenuFilm.getItems().addAll((MenuItem[])new MenuItem[]{miLoadTxt, miFilmsSetShown, miFilmInfo, miMediaDb});
        return submenuFilm;
    }

    public static Menu copyInfos(FilmDataMTP audio) {
        Menu subMenuURL = new Menu("Audio-Infos kopieren");
        subMenuURL.setDisable(audio == null);
        MenuItem miCopyTheme = new MenuItem("Thema");
        miCopyTheme.setDisable(audio == null);
        miCopyTheme.setOnAction(a -> P2ToolsFactory.copyToClipboard(audio.getTheme()));
        MenuItem miCopyName = new MenuItem("Titel");
        miCopyName.setDisable(audio == null);
        miCopyName.setOnAction(a -> P2ToolsFactory.copyToClipboard(audio.getTitle()));
        MenuItem miCopyWeb = new MenuItem("Website-URL");
        miCopyWeb.setDisable(audio == null);
        miCopyWeb.setOnAction(a -> P2ToolsFactory.copyToClipboard(audio.getWebsite()));
        subMenuURL.getItems().addAll((MenuItem[])new MenuItem[]{miCopyTheme, miCopyName, miCopyWeb});
        MenuItem item = new MenuItem("Film-URL");
        item.setDisable(audio == null);
        item.setOnAction(a -> P2ToolsFactory.copyToClipboard(audio.getUrlForResolution("normal")));
        subMenuURL.getItems().add(item);
        return subMenuURL;
    }
}

