/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.MTPlayerFactory;
import de.p2tools.mtplayer.controller.config.PShortKeyFactory;
import de.p2tools.mtplayer.controller.config.PShortcut;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFactory;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.data.film.FilmSaveFactory;
import de.p2tools.mtplayer.controller.filter.FilmFilter;
import de.p2tools.mtplayer.controller.filter.film.AudioFilterSamples;
import de.p2tools.mtplayer.gui.ToolBarButton;
import de.p2tools.mtplayer.gui.dialog.BookmarkDialogController;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.shortcut.P2ShortcutWorker;
import java.util.Optional;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;

public class AudioMenu {
    private final VBox vBox;
    private final ProgData progData;
    private FilmFilter storedActFilterSettings = null;
    private static final String FILM_FILTER_BOOKMARK_TEXT = "Alle angelegte Bookmarks anzeigen\nder zweite Klick stellt den\neingestellten Filter wieder her";
    private static final String FILM_SHOW_BOOKMARK_TEXT = "Alle Bookmarks in einem Dialog anzeigen";

    public AudioMenu(VBox vBox) {
        this.vBox = vBox;
        this.progData = ProgData.getInstance();
    }

    public void init() {
        this.vBox.getChildren().clear();
        this.initFilmMenu();
        this.initButton();
    }

    private void initButton() {
        VBox vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(0.0);
        vBoxSpace.setMinHeight(0.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btPlay = new ToolBarButton(this.vBox, "Abspielen", "Markiertes Audio abspielen", ProgIcons.ICON_TOOLBAR_START.getImageView());
        ToolBarButton btPlayAll = new ToolBarButton(this.vBox, "Alle Abspielen", "Alle markierten Audios abspielen", ProgIcons.ICON_TOOLBAR_START_ALL.getImageView());
        ToolBarButton btSave = new ToolBarButton(this.vBox, "Speichern", "Markiertes Audio speichern", ProgIcons.ICON_TOOLBAR_REC.getImageView());
        btPlay.setOnAction(a -> {
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().audioGuiController.getSel(true, true);
            if (filmSelection.isPresent()) {
                FilmPlayFactory.playFilm(true, filmSelection.get());
                this.progData.audioGuiController.tableView.refresh();
                this.progData.audioGuiController.tableView.requestFocus();
            }
        });
        btPlayAll.setOnAction(a -> {
            FilmPlayFactory.playFilmList(true, ProgData.getInstance().audioGuiController.getSelList(true));
            this.progData.audioGuiController.tableView.refresh();
            this.progData.audioGuiController.tableView.requestFocus();
        });
        btSave.setOnAction(a -> {
            FilmSaveFactory.saveAudioList();
            this.progData.audioGuiController.tableView.refresh();
            this.progData.audioGuiController.tableView.requestFocus();
        });
        vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(10.0);
        vBoxSpace.setMinHeight(10.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btBookmark = new ToolBarButton(this.vBox, "Bookmarks anlegen", "Bookmarks f\u00fcr die markierten Filme anlegen", ProgIcons.ICON_TOOLBAR_BOOKMARK.getImageView());
        ToolBarButton btDelBookmark = new ToolBarButton(this.vBox, "Bookmarks l\u00f6schen", "Bookmarks f\u00fcr die markierten Filme l\u00f6schen", ProgIcons.ICON_TOOLBAR_DEL_BOOKMARK.getImageView());
        ToolBarButton btDelAllBookmark = new ToolBarButton(this.vBox, "Alle Bookmarks l\u00f6schen", "Alle angelegten Bookmarks l\u00f6schen", ProgIcons.ICON_TOOLBAR_DEL_ALL_BOOKMARK.getImageView());
        ToolBarButton btFilterBookmark = new ToolBarButton(this.vBox, "Bookmarks anzeigen", FILM_FILTER_BOOKMARK_TEXT, ProgIcons.ICON_TOOLBAR_BOOKMARK_FILTER.getImageView());
        ToolBarButton btShowBookmark = new ToolBarButton(this.vBox, "Alle Bookmarks anzeigen", FILM_SHOW_BOOKMARK_TEXT, ProgIcons.ICON_TOOLBAR_BOOKMARK_DIALOG.getImageView());
        btBookmark.setOnAction(a -> {
            BookmarkFactory.addBookmarkList(true, this.progData.audioGuiController.getSelList(true));
            this.progData.audioGuiController.tableView.refresh();
            this.progData.audioGuiController.tableView.requestFocus();
        });
        btDelBookmark.setOnAction(a -> {
            BookmarkFactory.removeBookmarkList(this.progData.audioGuiController.getSelList(true));
            this.progData.audioGuiController.tableView.refresh();
            this.progData.audioGuiController.tableView.requestFocus();
        });
        btDelAllBookmark.setOnAction(a -> {
            BookmarkFactory.deleteAll(this.progData.primaryStage);
            this.progData.audioGuiController.tableView.refresh();
            this.progData.audioGuiController.tableView.requestFocus();
        });
        btFilterBookmark.setOnAction(a -> {
            FilmFilter bookmarkFilter;
            FilmFilter sf = this.progData.filterWorkerAudio.getActFilterSettings();
            if (sf.isSame(bookmarkFilter = AudioFilterSamples.getBookmarkFilter())) {
                if (this.storedActFilterSettings != null) {
                    this.storedActFilterSettings.setOnlyBookmark(false);
                    this.progData.filterWorkerAudio.setActFilterSettings(this.storedActFilterSettings);
                    this.storedActFilterSettings = null;
                } else {
                    this.progData.filterWorkerAudio.getActFilterSettings().clearFilter();
                }
            } else {
                this.storedActFilterSettings = this.progData.filterWorkerAudio.getActFilterSettings().getCopy();
                this.progData.filterWorkerAudio.setActFilterSettings(bookmarkFilter);
            }
            this.progData.audioGuiController.tableView.refresh();
            this.progData.audioGuiController.tableView.requestFocus();
        });
        btShowBookmark.setOnAction(a -> {
            if (this.progData.bookmarkDialogController != null) {
                this.progData.bookmarkDialogController.showDialog();
            } else {
                new BookmarkDialogController(this.progData);
            }
        });
        this.vBox.getChildren().add(P2GuiTools.getVDistance(10));
    }

    private void initFilmMenu() {
        MenuButton mb = new MenuButton("");
        mb.setTooltip(new Tooltip("Audiomen\u00fc anzeigen"));
        mb.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        mb.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-0"});
        MenuItem mbPlay = new MenuItem("Audio abspielen");
        mbPlay.setOnAction(a -> {
            if (!MTPlayerController.TAB_AUDIO_ON.get()) {
                return;
            }
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().audioGuiController.getSel(true, true);
            filmSelection.ifPresent(filmDataMTP -> FilmPlayFactory.playFilm(true, filmDataMTP));
        });
        P2ShortcutWorker.addShortCut(mbPlay, PShortcut.SHORTCUT_PLAY_FILM);
        MenuItem mbPlayAll = new MenuItem("Alle markierten Audios abspielen");
        mbPlayAll.setOnAction(a -> {
            if (!MTPlayerController.TAB_AUDIO_ON.get()) {
                return;
            }
            FilmPlayFactory.playFilmList(true, ProgData.getInstance().audioGuiController.getSelList(true));
        });
        P2ShortcutWorker.addShortCut(mbPlayAll, PShortcut.SHORTCUT_PLAY_FILM_ALL);
        MenuItem mbSave = new MenuItem("Audios speichern");
        mbSave.setOnAction(e -> {
            if (!MTPlayerController.TAB_AUDIO_ON.get()) {
                return;
            }
            FilmSaveFactory.saveAudioList();
        });
        P2ShortcutWorker.addShortCut(mbSave, PShortcut.SHORTCUT_SAVE_FILM);
        mb.getItems().addAll((MenuItem[])new MenuItem[]{mbPlay, mbPlayAll, mbSave});
        mb.getItems().add(new SeparatorMenuItem());
        MenuItem miFilmShown = new MenuItem("Audio als gesehen markieren");
        miFilmShown.setOnAction(a -> {
            if (!MTPlayerController.TAB_AUDIO_ON.get()) {
                return;
            }
            this.progData.audioGuiController.setFilmShown(true);
        });
        P2ShortcutWorker.addShortCut(miFilmShown, PShortcut.SHORTCUT_FILM_SHOWN);
        MenuItem miFilmNotShown = new MenuItem("Audio als ungesehen markieren");
        miFilmNotShown.setOnAction(a -> {
            if (!MTPlayerController.TAB_AUDIO_ON.get()) {
                return;
            }
            this.progData.audioGuiController.setFilmShown(false);
        });
        P2ShortcutWorker.addShortCut(miFilmNotShown, PShortcut.SHORTCUT_FILM_NOT_SHOWN);
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miFilmShown, miFilmNotShown});
        MenuItem miFilmInfo = new MenuItem("Audioinformation anzeigen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_INFO_FILM.getActShortcut());
        miFilmInfo.setOnAction(a -> this.progData.audioGuiController.showFilmInfo());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miFilmInfo});
        mb.getItems().addAll((MenuItem[])new MenuItem[]{AudioMenu.copyInfos(this.progData)});
        mb.getItems().add(new SeparatorMenuItem());
        MenuItem miFilmMediaCollection = new MenuItem("Audio in der Mediensammlung suchen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SEARCH_FILM_IN_MEDIACOLLECTION.getActShortcut());
        miFilmMediaCollection.setOnAction(a -> this.progData.audioGuiController.searchFilmInMediaCollection());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miFilmMediaCollection});
        Menu submenuBlacklist = new Menu("Blacklist");
        MenuItem miBlack = new MenuItem("Blacklist-Eintrag f\u00fcr das Audio erstellen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_ADD_BLACKLIST.getActShortcut());
        miBlack.setOnAction(event -> BlacklistFactory.addBlackFilm(BlacklistFactory.BLACK_SRC.AUDIO));
        MenuItem miBlackTheme = new MenuItem("Thema direkt in die Blacklist einf\u00fcgen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_ADD_BLACKLIST_THEME.getActShortcut());
        miBlackTheme.setOnAction(event -> BlacklistFactory.addBlackThemeFilm(BlacklistFactory.BLACK_SRC.AUDIO));
        submenuBlacklist.getItems().addAll((MenuItem[])new MenuItem[]{miBlack, miBlackTheme});
        mb.getItems().addAll((MenuItem[])new MenuItem[]{submenuBlacklist});
        Menu submenuBookmark = new Menu("Bookmarks");
        MenuItem miBookmarkAdd = new MenuItem("Neue Bookmarks anlegen");
        miBookmarkAdd.setOnAction(a -> BookmarkFactory.addBookmarkList(true, this.progData.audioGuiController.getSelList(true)));
        MenuItem miBookmarkDel = new MenuItem("Bookmarks l\u00f6schen");
        miBookmarkDel.setOnAction(a -> BookmarkFactory.removeBookmarkList(this.progData.audioGuiController.getSelList(true)));
        MenuItem miBookmarkDelAll = new MenuItem("Alle angelegten Bookmarks l\u00f6schen");
        miBookmarkDelAll.setOnAction(a -> BookmarkFactory.deleteAll(this.progData.primaryStage));
        submenuBookmark.getItems().addAll((MenuItem[])new MenuItem[]{miBookmarkAdd, miBookmarkDel, miBookmarkDelAll});
        mb.getItems().add(submenuBookmark);
        CheckMenuItem miSmallFilter = new CheckMenuItem("Einfachen Filter anzeigen");
        miSmallFilter.selectedProperty().bindBidirectional(ProgConfig.AUDIOFILTER_SMALL_FILTER);
        MenuItem miShowFilter = new MenuItem("Filter ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_FILTER.getActShortcut());
        miShowFilter.disableProperty().bind(ProgConfig.AUDIO__FILTER_IS_RIP);
        miShowFilter.setOnAction(a -> MTPlayerFactory.setFilter());
        MenuItem miShowInfo = new MenuItem("Infos ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_INFOS.getActShortcut());
        miShowInfo.disableProperty().bind(ProgConfig.AUDIO__INFO_PANE_IS_RIP.and(ProgConfig.AUDIO__BUTTON_PANE_IS_RIP).and(ProgConfig.AUDIO__MEDIA_PANE_IS_RIP));
        miShowInfo.setOnAction(a -> MTPlayerFactory.setInfos());
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miSmallFilter, miShowFilter, miShowInfo});
        this.vBox.getChildren().add(mb);
    }

    public static Menu copyInfos(ProgData progData) {
        Menu subMenuURL = new Menu("Audio-Infos kopieren");
        MenuItem miCopyTheme = new MenuItem("Thema");
        miCopyTheme.setOnAction(a -> progData.audioGuiController.copyFilmThemeTitle(true));
        MenuItem miCopyName = new MenuItem("Titel");
        miCopyName.setOnAction(a -> progData.audioGuiController.copyFilmThemeTitle(false));
        MenuItem miCopyWeb = new MenuItem("Website-URL");
        miCopyWeb.setOnAction(a -> progData.audioGuiController.copyWebsite());
        MenuItem miCopyUrl = new MenuItem("URL");
        miCopyUrl.setOnAction(a -> progData.audioGuiController.copyUrl("normal"));
        subMenuURL.getItems().addAll((MenuItem[])new MenuItem[]{miCopyTheme, miCopyName, miCopyWeb});
        subMenuURL.getItems().add(new SeparatorMenuItem());
        subMenuURL.getItems().addAll((MenuItem[])new MenuItem[]{miCopyUrl});
        return subMenuURL;
    }
}

