/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.filter.FilterDto;
import de.p2tools.mtplayer.gui.AudioGuiController;
import de.p2tools.mtplayer.gui.MenuController;
import de.p2tools.mtplayer.gui.filter.film.FilmFilterController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class AudioGui {
    ProgData progData;
    private final SplitPane splitPane = new SplitPane();
    private final HBox hBox = new HBox();
    private final FilmFilterController audioFilterController;
    private final AudioGuiController audioGuiController;
    private final BooleanProperty boundFilter = new SimpleBooleanProperty(false);
    private final P2ClosePaneController infoControllerFilter;

    public AudioGui() {
        this.progData = ProgData.getInstance();
        FilterDto filterDto = new FilterDto(true);
        this.audioFilterController = new FilmFilterController(filterDto);
        this.audioGuiController = new AudioGuiController();
        SimpleBooleanProperty show = new SimpleBooleanProperty();
        show.bind(MTPlayerController.TAB_AUDIO_ON.and(ProgConfig.FAST_AUDIO_SEARCH_ON.not()));
        P2ClosePaneDto infoDto = new P2ClosePaneDto(this.audioFilterController, ProgConfig.AUDIO__FILTER_IS_RIP, ProgConfig.AUDIO__FILTER_DIALOG_SIZE, show, "Filter", "Filter", true, this.progData.maskerPane.getVisibleProperty());
        this.infoControllerFilter = new P2ClosePaneController(infoDto, ProgConfig.AUDIO__FILTER_IS_SHOWING);
    }

    public SplitPane pack() {
        MenuController menuController = new MenuController(MenuController.StartupMode.AUDIO);
        this.progData.audioGuiController = this.audioGuiController;
        this.splitPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        SplitPane.setResizableWithParent(this.audioFilterController, Boolean.FALSE);
        this.hBox.setPrefSize(-1.0, -1.0);
        this.hBox.setMinSize(-1.0, -1.0);
        this.hBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        HBox.setHgrow(this.splitPane, Priority.ALWAYS);
        this.hBox.getChildren().addAll((Node[])new Node[]{this.splitPane, menuController});
        ProgConfig.AUDIO__FILTER_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setSplit());
        ProgConfig.AUDIO__FILTER_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setSplit());
        this.setSplit();
        return new SplitPane(this.hBox);
    }

    private void setSplit() {
        P2ClosePaneFactory.setSplit(this.boundFilter, this.splitPane, this.infoControllerFilter, true, this.audioGuiController, ProgConfig.AUDIO__FILTER_DIVIDER, ProgConfig.AUDIO__FILTER_IS_SHOWING);
    }
}

