/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.abo.AboListFactory;
import de.p2tools.mtplayer.gui.AboGuiController;
import de.p2tools.mtplayer.gui.tools.table.TableAbo;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class AboTableContextMenu {
    private final ProgData progData;
    private final AboGuiController aboGuiController;
    private final TableAbo tableView;

    public AboTableContextMenu(ProgData progData, AboGuiController aboGuiController, TableAbo tableView) {
        this.progData = progData;
        this.aboGuiController = aboGuiController;
        this.tableView = tableView;
    }

    public ContextMenu getContextMenu(AboData abo) {
        ContextMenu contextMenu = new ContextMenu();
        this.getMenu(contextMenu, abo);
        return contextMenu;
    }

    private void getMenu(ContextMenu contextMenu, AboData abo) {
        MenuItem miOnOff;
        if (abo != null && abo.isActive()) {
            miOnOff = new MenuItem("Abos ausschalten");
            miOnOff.setOnAction(e -> AboListFactory.setAboActive(false));
        } else {
            miOnOff = new MenuItem("Abos einschalten");
            miOnOff.setOnAction(a -> AboListFactory.setAboActive(true));
        }
        MenuItem miDel = new MenuItem("Abos l\u00f6schen");
        miDel.setOnAction(a -> AboListFactory.deleteAbo());
        MenuItem miChange = new MenuItem("Abos \u00e4ndern");
        miChange.setOnAction(a -> AboListFactory.editAbo());
        MenuItem miNew = new MenuItem("neues Abo anlegen");
        miNew.setOnAction(a -> AboListFactory.addNewAbo(0, "Neu", "", "", ""));
        MenuItem miUndo = new MenuItem("Gel\u00f6schte wieder anlegen");
        miUndo.setOnAction(a -> this.progData.aboList.undoAbos());
        miUndo.setDisable(this.progData.aboList.getUndoList().isEmpty());
        miOnOff.setDisable(abo == null);
        miDel.setDisable(abo == null);
        miChange.setDisable(abo == null);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miOnOff, miDel, miChange, miNew, new SeparatorMenuItem(), miUndo});
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.getSubMenuFilter(abo)});
        MenuItem miSelectAll = new MenuItem("alles ausw\u00e4hlen");
        miSelectAll.setOnAction(a -> this.tableView.getSelectionModel().selectAll());
        MenuItem miSelection = new MenuItem("Auswahl umkehren");
        miSelection.setOnAction(a -> this.aboGuiController.invertSelection());
        MenuItem miSort = new MenuItem("Abos alphabetisch sortieren");
        miSort.setOnAction(a -> this.progData.aboList.sortAlphabetically());
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miSelectAll, miSelection, miSort});
        contextMenu.getItems().add(new SeparatorMenuItem());
        CheckMenuItem smallTableRow = new CheckMenuItem("Nur kleine Button anzeigen");
        smallTableRow.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SMALL_TABLE_ROW_ABO);
        CheckMenuItem toolTipTable = new CheckMenuItem("Infos beim \u00dcberfahren einer Zeile anzeigen");
        toolTipTable.selectedProperty().bindBidirectional(ProgConfig.ABO_GUI_SHOW_TABLE_TOOL_TIP);
        MenuItem resetTable = new MenuItem("Tabelle zur\u00fccksetzen");
        resetTable.setOnAction(e -> this.tableView.resetTable());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{smallTableRow, toolTipTable, resetTable});
    }

    private Menu getSubMenuFilter(AboData abo) {
        MenuItem miAboAddFilterFilm = new MenuItem("Neues Abo aus dem Film-Filter erstellen");
        miAboAddFilterFilm.setOnAction(a -> AboListFactory.addNewAboFromFilterButton(false));
        MenuItem miAboAddFilterAudio = new MenuItem("Neues Abo aus dem Audio-Filter erstellen");
        miAboAddFilterAudio.setOnAction(a -> AboListFactory.addNewAboFromFilterButton(true));
        MenuItem miAboToFilter = new MenuItem("Filmfilter aus dem Abo setzen");
        miAboToFilter.setOnAction(a -> AboListFactory.setFilmFilterFromAbo());
        MenuItem miFilterToAbo = new MenuItem("Abo aus dem Filmfilter setzen");
        miFilterToAbo.setOnAction(a -> AboListFactory.changeAboFromFilterButton());
        Menu mFilter = new Menu("Filter - Abo");
        mFilter.setDisable(abo == null);
        mFilter.getItems().addAll((MenuItem[])new MenuItem[]{miAboAddFilterFilm, miAboAddFilterAudio, miAboToFilter, miFilterToAbo});
        return mFilter;
    }
}

