/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.abo.AboListFactory;
import de.p2tools.mtplayer.gui.AboTableContextMenu;
import de.p2tools.mtplayer.gui.dialog.FilmInfoDialogController;
import de.p2tools.mtplayer.gui.infoPane.InfoPaneFactory;
import de.p2tools.mtplayer.gui.infoPane.PaneAboInfo;
import de.p2tools.mtplayer.gui.infoPane.PaneAboInfoList;
import de.p2tools.mtplayer.gui.tools.table.Table;
import de.p2tools.mtplayer.gui.tools.table.TableAbo;
import de.p2tools.mtplayer.gui.tools.table.TableRowAbo;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2RowMoveFactory;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import de.p2tools.p2lib.mediathek.filter.Filter;
import de.p2tools.p2lib.mediathek.filter.FilterCheck;
import de.p2tools.p2lib.p2event.P2Listener;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;

public class AboGuiController
extends AnchorPane {
    private final SplitPane splitPane = new SplitPane();
    private final ScrollPane scrollPane = new ScrollPane();
    public final TableAbo tableView;
    private final ProgData progData;
    private final FilteredList<AboData> filteredAbos;
    private final SortedList<AboData> sortedAbos;
    private final PaneAboInfo paneAboInfo;
    private final PaneAboInfoList paneAboInfoList;
    private final P2ClosePaneController infoController;
    private final BooleanProperty boundInfo = new SimpleBooleanProperty(false);

    public AboGuiController() {
        this.progData = ProgData.getInstance();
        this.tableView = new TableAbo(Table.TABLE_ENUM.ABO);
        AnchorPane.setLeftAnchor(this.splitPane, 0.0);
        AnchorPane.setBottomAnchor(this.splitPane, 0.0);
        AnchorPane.setRightAnchor(this.splitPane, 0.0);
        AnchorPane.setTopAnchor(this.splitPane, 0.0);
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.getChildren().addAll((Node[])new Node[]{this.splitPane});
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setContent(this.tableView);
        this.paneAboInfo = new PaneAboInfo();
        this.paneAboInfoList = new PaneAboInfoList();
        this.filteredAbos = new FilteredList<AboData>(this.progData.aboList, p -> true);
        this.sortedAbos = new SortedList<AboData>((ObservableList<AboData>)this.filteredAbos);
        ArrayList<P2ClosePaneDto> list = new ArrayList<P2ClosePaneDto>();
        P2ClosePaneDto infoDto = new P2ClosePaneDto(this.paneAboInfo, ProgConfig.ABO__INFO_PANE_IS_RIP, ProgConfig.ABO__INFO__DIALOG_SIZE, MTPlayerController.TAB_ABO_ON, "Beschreibung", "Beschreibung", false, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        infoDto = new P2ClosePaneDto(this.paneAboInfoList, ProgConfig.ABO__LIST_PANE_IS_RIP, ProgConfig.ABO__LIST_DIALOG_SIZE, MTPlayerController.TAB_ABO_ON, "Infos", "Infos", false, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        this.infoController = new P2ClosePaneController(list, ProgConfig.ABO__INFO_IS_SHOWING);
        ProgConfig.ABO__INFO_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.ABO__INFO_PANE_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.ABO__LIST_PANE_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        this.setInfoPane();
        this.initTable();
        this.initListener();
        this.setFilterProperty();
        this.setFilter();
    }

    public ObservableList<AboData> getSelList() {
        ObservableList ret = this.tableView.getSelectionModel().getSelectedItems();
        if (ret == null || ret.isEmpty()) {
            P2Alert.showInfoNoSelection();
        }
        return ret;
    }

    public Optional<AboData> getSel() {
        return this.getSel(true);
    }

    private Optional<AboData> getSel(boolean show) {
        int selectedTableRow = this.tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow >= 0) {
            return Optional.of((AboData)this.tableView.getSelectionModel().getSelectedItem());
        }
        if (show) {
            P2Alert.showInfoNoSelection();
        }
        return Optional.empty();
    }

    public void isShown() {
        this.tableView.requestFocus();
        FilmInfoDialogController.getInstance().setFilm(null);
    }

    public int getAboCount() {
        return this.tableView.getItems().size();
    }

    public int getSelCount() {
        return this.tableView.getSelectionModel().getSelectedItems().size();
    }

    public void selectAll() {
        this.tableView.getSelectionModel().selectAll();
    }

    public void invertSelection() {
        P2TableFactory.invertSelection(this.tableView);
    }

    public void saveTable() {
        Table.saveTable(this.tableView, Table.TABLE_ENUM.ABO);
    }

    private void initListener() {
        this.progData.aboList.listChangedProperty().addListener((observable2, oldValue, newValue) -> this.tableView.refresh());
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_SET_DATA_CHANGED){

            @Override
            public void pingGui() {
                AboGuiController.this.tableView.refresh();
            }
        });
    }

    private void initTable() {
        Table.setTable(this.tableView);
        this.tableView.setItems(this.sortedAbos);
        this.sortedAbos.comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.setRowFactory(new P2RowMoveFactory<AboData>(tv -> {
            TableRowAbo row = new TableRowAbo();
            row.setOnMouseClicked(event -> {
                if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2 && !row.isEmpty()) {
                    AboListFactory.editAbo();
                }
            });
            row.hoverProperty().addListener(observable2 -> {
                AboData aboData = (AboData)row.getItem();
                if (row.isHover() && aboData != null) {
                    if (InfoPaneFactory.paneIsVisible(MTPlayerController.TAB_ABO_ON, this.paneAboInfo)) {
                        this.paneAboInfo.setAbo(aboData);
                    }
                } else if (InfoPaneFactory.paneIsVisible(MTPlayerController.TAB_ABO_ON, this.paneAboInfo)) {
                    this.paneAboInfo.setAbo((AboData)this.tableView.getSelectionModel().getSelectedItem());
                }
            });
            return row;
        }, this.progData.aboList));
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> {
            if (InfoPaneFactory.paneIsVisible(MTPlayerController.TAB_ABO_ON, this.paneAboInfo)) {
                this.paneAboInfo.setAbo((AboData)this.tableView.getSelectionModel().getSelectedItem());
            }
        });
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                Optional<AboData> optionalAbo = this.getSel(false);
                AboData abo = optionalAbo.orElse(null);
                ContextMenu contextMenu = new AboTableContextMenu(this.progData, this, this.tableView).getContextMenu(abo);
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
            if (P2TableFactory.SPACE.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeDown(this.tableView);
                event.consume();
            }
            if (P2TableFactory.SPACE_SHIFT.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeUp(this.tableView);
                event.consume();
            }
        });
    }

    private void setFilterProperty() {
        ProgConfig.FILTER_ABO_CHANNEL.addListener((observable2, oldValue, newValue) -> this.setFilter());
        ProgConfig.FILTER_ABO_TYPE.addListener((observable2, oldValue, newValue) -> this.setFilter());
        ProgConfig.FILTER_ABO_NAME.addListener((observable2, oldValue, newValue) -> this.setFilter());
        ProgConfig.FILTER_ABO_SEARCH_TEXT.addListener((observable2, oldValue, newValue) -> this.setFilter());
        ProgConfig.FILTER_ABO_DESCRIPTION.addListener((observable2, oldValue, newValue) -> this.setFilter());
    }

    private void setFilter() {
        Filter filter;
        String sender = ProgConfig.FILTER_ABO_CHANNEL.getValueSafe();
        String type = ProgConfig.FILTER_ABO_TYPE.getValueSafe();
        String name = ProgConfig.FILTER_ABO_NAME.getValueSafe().trim();
        String searchText = ProgConfig.FILTER_ABO_SEARCH_TEXT.getValueSafe().trim();
        String description = ((String)ProgConfig.FILTER_ABO_DESCRIPTION.get()).trim();
        Predicate<AboData> predicate = aboData -> true;
        if (!sender.isEmpty()) {
            filter = new Filter(sender, true);
            predicate = predicate.and(aboData -> FilterCheck.check(filter, aboData.getChannel()));
        }
        if (!type.isEmpty()) {
            predicate = predicate.and(aboData -> type.equals("eingeschaltet") && aboData.isActive() || type.equals("ausgeschaltet") && !aboData.isActive());
        }
        if (!name.isEmpty()) {
            filter = new Filter(name, true);
            predicate = predicate.and(aboData -> FilterCheck.check(filter, aboData.getName()));
        }
        if (!searchText.isEmpty()) {
            filter = new Filter(searchText, true);
            predicate = predicate.and(aboData -> FilterCheck.check(filter, aboData.getTheme()) || FilterCheck.check(filter, aboData.getThemeTitle()) || FilterCheck.check(filter, aboData.getTitle()) || FilterCheck.check(filter, aboData.getSomewhere()));
        }
        if (!description.isEmpty()) {
            filter = new Filter(description, true);
            predicate = predicate.and(aboData -> FilterCheck.check(filter, aboData.getDescription()));
        }
        this.filteredAbos.setPredicate(predicate);
    }

    private void setInfoPane() {
        P2ClosePaneFactory.setSplit(this.boundInfo, this.splitPane, this.infoController, false, this.scrollPane, ProgConfig.ABO__INFO_DIVIDER, ProgConfig.ABO__INFO_IS_SHOWING);
    }
}

