/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.worker;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.mtplayer.controller.data.abo.AboSearchDownloadsFactory;
import de.p2tools.mtplayer.controller.load.LoadFilmFactory;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;

public class Worker {
    private String downloadFilterChannel = ProgConfig.FILTER_DOWNLOAD_CHANNEL.getValueSafe();
    private String downloadFilterAbo = ProgConfig.FILTER_DOWNLOAD_ABO.getValueSafe();
    private String aboFilterChannel = ProgConfig.FILTER_ABO_CHANNEL.getValueSafe();
    private final ProgData progData;

    public Worker(ProgData progData) {
        this.progData = progData;
        this.getAboNames();
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_BLACKLIST_CHANGED){

            @Override
            public void pingGui() {
                if (ProgConfig.SYSTEM_BLACKLIST_SHOW_ABO.getValue().booleanValue() && ProgConfig.ABO_SEARCH_NOW.getValue().booleanValue()) {
                    AboSearchDownloadsFactory.searchForDownloadsFromAbosAndMaybeStart();
                }
            }
        });
        ProgConfig.SYSTEM_BLACKLIST_SHOW_ABO.addListener((observable2, oldValue, newValue) -> {
            if (ProgConfig.ABO_SEARCH_NOW.getValue().booleanValue()) {
                Platform.runLater(AboSearchDownloadsFactory::searchForDownloadsFromAbosAndMaybeStart);
            }
        });
        progData.aboList.listChangedProperty().addListener((observable2, oldValue, newValue) -> Platform.runLater(() -> {
            this.getAboNames();
            if (ProgConfig.ABO_SEARCH_NOW.getValue().booleanValue()) {
                AboSearchDownloadsFactory.searchForDownloadsFromAbosAndMaybeStart();
            }
        }));
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_SET_DATA_CHANGED){

            @Override
            public void pingGui() {
                AboFactory.checkAbosSetData();
                AboSearchDownloadsFactory.searchForDownloadsFromAbosAndMaybeStart();
            }
        });
        progData.checkForNewFilmlist.foundNewListProperty().addListener((u, o, n) -> {
            if (!ProgConfig.SYSTEM_LOAD_NEW_FILMLIST_IMMEDIATELY.getValue().booleanValue()) {
                return;
            }
            if (!progData.checkForNewFilmlist.isFoundNewList()) {
                return;
            }
            if (ProgData.FILMLIST_IS_DOWNLOADING.get()) {
                return;
            }
            P2Log.sysLog(new String[]{"==================================", "Es gibt eine neue Filmliste und die soll sofort geladen werden", "=================================="});
            LoadFilmFactory.loadFilmListFromWeb(false, true);
        });
    }

    public void workOnConfigLoaded() {
        this.getAboNames();
    }

    public void workOnConfigSaved() {
        this.getAboNames();
    }

    public void saveFilter() {
        this.downloadFilterChannel = ProgConfig.FILTER_DOWNLOAD_CHANNEL.getValueSafe();
        this.downloadFilterAbo = ProgConfig.FILTER_DOWNLOAD_ABO.getValueSafe();
        this.aboFilterChannel = ProgConfig.FILTER_ABO_CHANNEL.getValueSafe();
    }

    public void resetFilter() {
        if (ThemeListFactory.allAboNamesList.contains(this.downloadFilterAbo)) {
            ProgConfig.FILTER_DOWNLOAD_ABO.setValue(this.downloadFilterAbo);
        } else {
            ProgConfig.FILTER_DOWNLOAD_ABO.setValue("");
        }
        if (ThemeListFactory.allChannelListFilm.contains(this.downloadFilterChannel)) {
            ProgConfig.FILTER_DOWNLOAD_CHANNEL.setValue(this.downloadFilterChannel);
        } else {
            ProgConfig.FILTER_DOWNLOAD_CHANNEL.setValue("");
        }
        if (ThemeListFactory.allChannelListFilm.contains(this.aboFilterChannel)) {
            ProgConfig.FILTER_ABO_CHANNEL.setValue(this.aboFilterChannel);
        } else {
            ProgConfig.FILTER_ABO_CHANNEL.setValue("");
        }
    }

    private void getAboNames() {
        ArrayList<String> listAboChannel = this.progData.aboList.getAboChannelList();
        ArrayList<String> listAboName = this.progData.aboList.getAboNameList();
        this.saveFilter();
        ThemeListFactory.channelsForAbosList.setAll((Collection<String>)listAboChannel);
        ThemeListFactory.allAboNamesList.setAll((Collection<String>)listAboName);
        this.resetFilter();
    }
}

