/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.update;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.dialogs.WhatsNewInfo;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import java.time.LocalDate;
import java.util.ArrayList;

public class WhatsNewList
extends ArrayList<WhatsNewInfo> {
    private LocalDate maxDate = LocalDate.MIN;

    public WhatsNewList() {
        this.addWhatsNew();
        this.forEach((? super E whatsNewInfo) -> {
            if (whatsNewInfo.getDate().isAfter(this.maxDate)) {
                this.maxDate = whatsNewInfo.getDate();
            }
        });
    }

    public void setLastShownToMax() {
        ProgConfig.SYSTEM_WHATS_NEW_DATE_LAST_SHOWN.setValue(P2LDateFactory.toStringR(this.maxDate));
    }

    public ArrayList<WhatsNewInfo> getOnlyNews() {
        ArrayList<WhatsNewInfo> list = new ArrayList<WhatsNewInfo>();
        LocalDate lastDate = P2LDateFactory.fromStringR(ProgConfig.SYSTEM_WHATS_NEW_DATE_LAST_SHOWN.getValueSafe());
        this.forEach((? super E whatsNewInfo) -> {
            if (lastDate.isBefore(whatsNewInfo.getDate())) {
                list.add((WhatsNewInfo)whatsNewInfo);
            }
        });
        return list;
    }

    private void addWhatsNew() {
        WhatsNewInfo whatsNewInfo = new WhatsNewInfo(LocalDate.of(2025, 4, 28), "/de/p2tools/mtplayer/res/whatsnew/whatsNew_bookmark.png", "Bookmarks", "Die Bookmarks k\u00f6nnen in einem eigenen Dialog angezeigt werden. Dort k\u00f6nnen die Filme auch angesehen und gespeichert werden. Es k\u00f6nnen auch Kommentare zu den Bookmarks hinzugef\u00fcgt werden.", 100);
        this.add(whatsNewInfo);
        whatsNewInfo = new WhatsNewInfo(LocalDate.of(2025, 7, 29), "/de/p2tools/mtplayer/res/whatsnew/whatsNew_small-filter.png", "Einfacher Filter", "Im Tab Filme kann ein einfacher Filter angezeigt werden. Er enth\u00e4lt nur das n\u00f6tigste und ist \u00fcbersichtlicher. Umschalten l\u00e4sst sich das im Film-Men\u00fc->Einfacher Filter.", 100);
        this.add(whatsNewInfo);
        whatsNewInfo = new WhatsNewInfo(LocalDate.of(2025, 8, 25), "/de/p2tools/mtplayer/res/whatsnew/whatsNew_audiolist.png", "Audiothek", "Jetzt werden auch die Beitr\u00e4ge der ARD-Audiothek angezeigt. Die Beitr\u00e4ge k\u00f6nnen genauso wie die Filme abgespielt und aufgezeichnet werden. Auch Abos lassen sich anlegen.\nWer die Audiothek nicht verwenden will, kann sie in den Einstellungen abschalten.\nWenns Vorschl\u00e4ge dazu gibt, gerne per Mail oder im Forum.", 140);
        this.add(whatsNewInfo);
        whatsNewInfo = new WhatsNewInfo(LocalDate.of(2025, 10, 11), "", "Filtervorschl\u00e4ge", "In den Textfiltern (Filme/Audios) kann mit einem Doppelklick ein Filtervorschlag eingef\u00fcgt werden. Die Vorschl\u00e4ge kann man in den \"Einstellungen->Filter\" vorgeben. Die Funktion kann dort auch abgeschaltet werden.", 100);
        this.add(whatsNewInfo);
    }
}

