/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.starter;

import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.p2lib.mediathek.download.MtInputStream;
import de.p2tools.p2lib.tools.date.P2Date;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class StartDownloadDto {
    private int startCounter = 0;
    private boolean startViewing = false;
    private long timeLeftSeconds = -1L;
    private long downloaded = 0L;
    private boolean deleteAfterStop = false;
    private Process process = null;
    private P2Date startTime = null;
    private MtInputStream inputStream = null;
    private File file = null;
    private final List<String> errMsgList = new ArrayList<String>();
    private final List<String> errStreamList = new ArrayList<String>();
    private final DownloadData download;

    public StartDownloadDto(DownloadData download) {
        this.download = download;
    }

    public long getTimeLeftSeconds() {
        return this.timeLeftSeconds;
    }

    public void setTimeLeftSeconds(int timeLeftSeconds) {
        this.timeLeftSeconds = timeLeftSeconds;
        if (this.download.isStateStartedRun() && this.getTimeLeftSeconds() > 0L) {
            this.download.setRemaining(timeLeftSeconds);
        } else {
            this.download.setRemaining(Integer.MIN_VALUE);
        }
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
    }

    public boolean isDeleteAfterStop() {
        return this.deleteAfterStop;
    }

    public void setDeleteAfterStop(boolean deleteAfterStop) {
        this.deleteAfterStop = deleteAfterStop;
    }

    public void startDownload() {
        this.setStartTime(new P2Date());
        this.errMsgList.clear();
        this.errStreamList.clear();
    }

    public boolean isStartViewing() {
        return this.startViewing;
    }

    public void setStartViewing(boolean startViewing) {
        this.startViewing = startViewing;
    }

    public P2Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(P2Date startTime) {
        this.startTime = startTime;
    }

    public MtInputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(MtInputStream inputStream2) {
        this.inputStream = inputStream2;
    }

    public int getStartCounter() {
        return this.startCounter;
    }

    public void setStartCounter(int startCounter) {
        this.startCounter = startCounter;
    }

    public void addStartCounter() {
        ++this.startCounter;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public List<String> getErrMsgList() {
        return this.errMsgList;
    }

    public String getErrorMsg() {
        String errMsg;
        if (!this.errMsgList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            this.errMsgList.forEach(s -> sb.append((String)s).append("\n"));
            errMsg = sb.toString();
        } else {
            errMsg = "Fehlerhafter Download";
        }
        return errMsg;
    }

    public void addErrMsg(String error) {
        if (!this.errMsgList.contains(error)) {
            this.errMsgList.add(error);
        }
    }

    public List<String> getErrStreamList() {
        return this.errStreamList;
    }

    public void addErrStream(String error) {
        this.errStreamList.add(error);
        while (this.errStreamList.size() > 25) {
            this.errStreamList.remove(0);
        }
    }

    public String getErrorStream() {
        String err;
        if (!this.errStreamList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            this.errStreamList.forEach(s -> sb.append((String)s).append("\n"));
            err = sb.toString();
        } else {
            err = "";
        }
        return err;
    }
}

