/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.starter;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.starter.PlayerMessage;
import de.p2tools.p2lib.mediathek.download.DownloadSize;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuntimeExecDownload {
    private static final int INPUT = 1;
    private static final int ERROR = 2;
    private Process process = null;
    private static final Pattern patternYtDlp = Pattern.compile("(?<=\\[download\\] [ ])[^%]*");
    private static final Pattern patternYtDlpSize = Pattern.compile("(?<=of ~[ ])[^M]*");
    private static final Pattern patternYtDlpBandwidth = Pattern.compile("(?<=at [ ])[^.]*");
    private static final Pattern patternFfmpegDuration = Pattern.compile("(?<=  Duration: )[^,]*");
    private static final Pattern patternFfmpegTime = Pattern.compile("(?<=time=)[^ ]*");
    private static final Pattern patternFfmpegSize = Pattern.compile("(?<=size=)[^k]*");
    private static final Pattern patternFfmpegBitrate = Pattern.compile("(?<=bitrate=)[^k]*");
    private double totalSecs = 0.0;
    private long oldSize = 0L;
    private long oldSecs = 0L;
    private DownloadData download = null;
    private DownloadSize mVFilmSize = null;
    private final String strProgCall;
    private String[] arrProgCallArray = null;
    private String strProgCallArray = "";
    private final PlayerMessage playerMessage = new PlayerMessage();

    public RuntimeExecDownload(DownloadData download) {
        this.download = download;
        this.mVFilmSize = download.getDownloadSize();
        this.strProgCall = download.getProgramCall();
        this.strProgCallArray = download.getProgramCallArray();
        this.arrProgCallArray = this.strProgCallArray.split("<>");
        if (this.arrProgCallArray.length <= 1) {
            this.arrProgCallArray = null;
        }
    }

    public Process exec(boolean log) {
        try {
            if (this.arrProgCallArray != null) {
                if (log) {
                    P2Log.sysLog("=====================");
                    P2Log.sysLog("Starte Array: ");
                    P2Log.sysLog(" -> " + this.strProgCallArray);
                    P2Log.sysLog("=====================");
                }
                this.process = Runtime.getRuntime().exec(this.arrProgCallArray);
            } else {
                if (log) {
                    P2Log.sysLog("=====================");
                    P2Log.sysLog("Starte nicht als Array:");
                    P2Log.sysLog(" -> " + this.strProgCall);
                    P2Log.sysLog("=====================");
                }
                this.process = Runtime.getRuntime().exec(this.strProgCall);
            }
            Thread clearIn = new Thread(new ClearInOut(1, this.process));
            clearIn.setName("exec-in");
            clearIn.start();
            Thread clearOut = new Thread(new ClearInOut(2, this.process));
            clearOut.setName("exec-out");
            clearOut.start();
        }
        catch (IOException ex) {
            P2Log.errorLog(958454789, (Exception)ex, "IOFehler beim Starten");
            String error = "Das Programm: [" + this.download.getProgramName() + "] konnte nicht gestartet werden.";
            this.download.getDownloadStartDto().addErrMsg(error);
        }
        catch (Exception ex) {
            P2Log.errorLog(450028932, ex, "Fehler beim Starten");
            String error = ex.getLocalizedMessage();
            this.download.getDownloadStartDto().addErrMsg(error);
        }
        return this.process;
    }

    private class ClearInOut
    implements Runnable {
        private final int art;
        private BufferedReader buff;
        private InputStream in;
        private final Process process;
        private double percent = 0.0;
        private double percent_start = -1.0;

        public ClearInOut(int a, Process p) {
            this.art = a;
            this.process = p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeExecDownload.this.download.getDownloadStartDto().getErrStreamList().clear();
            String title = "";
            try {
                String inStr;
                switch (this.art) {
                    case 1: {
                        this.in = this.process.getInputStream();
                        title = "INPUTSTREAM";
                        break;
                    }
                    case 2: {
                        this.in = this.process.getErrorStream();
                        ClearInOut clearInOut = this;
                        synchronized (clearInOut) {
                            title = "ERRORSTREAM";
                            break;
                        }
                    }
                }
                this.buff = new BufferedReader(new InputStreamReader(this.in));
                while ((inStr = this.buff.readLine()) != null) {
                    if (RuntimeExecDownload.this.download.getProgramCall().contains("ffmpeg")) {
                        this.getFromErrorStreamFfmpeg(inStr);
                    } else if (RuntimeExecDownload.this.download.getProgramCall().contains("yt-dlp")) {
                        this.getFromErrorStreamYtDlp(inStr);
                    }
                    RuntimeExecDownload.this.download.getDownloadStartDto().addErrStream(inStr);
                    RuntimeExecDownload.this.playerMessage.playerMessage(title + ": " + inStr);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.buff.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void getFromErrorStreamFfmpeg(String input) {
            block15: {
                try {
                    String size;
                    String bitrate;
                    Matcher matcher;
                    if (input.contains("HTTP error 404 Not Found")) {
                        RuntimeExecDownload.this.download.getDownloadStartDto().addErrMsg("Die URL wurde nicht gefunden.");
                    }
                    if ((matcher = patternFfmpegDuration.matcher(input)).find()) {
                        String duration = matcher.group().trim();
                        String[] hms = duration.split(":");
                        RuntimeExecDownload.this.totalSecs = (double)(Integer.parseInt(hms[0]) * 3600 + Integer.parseInt(hms[1]) * 60) + Double.parseDouble(hms[2]);
                    }
                    if (RuntimeExecDownload.this.totalSecs > 0.0 && (matcher = patternFfmpegBitrate.matcher(input)).find() && !(bitrate = matcher.group().trim()).isEmpty()) {
                        try {
                            double rate = Double.parseDouble(bitrate) * 1000.0 / 8.0;
                            if (rate > 0.0) {
                                long sumSize = (long)(RuntimeExecDownload.this.totalSecs * rate);
                                RuntimeExecDownload.this.mVFilmSize.setTargetSize(sumSize);
                            }
                        }
                        catch (NumberFormatException rate) {
                            // empty catch block
                        }
                    }
                    if ((matcher = patternFfmpegSize.matcher(input)).find() && !(size = matcher.group().trim()).isEmpty()) {
                        try {
                            long actSize = Integer.parseInt(size.replace("kB", ""));
                            RuntimeExecDownload.this.mVFilmSize.setActuallySize(actSize * 1000L);
                            long akt = RuntimeExecDownload.this.download.getDownloadStartDto().getStartTime().diffInSeconds();
                            if (RuntimeExecDownload.this.oldSecs < akt - 5L) {
                                RuntimeExecDownload.this.download.setBandwidth((actSize - RuntimeExecDownload.this.oldSize) * 1000L / (akt - RuntimeExecDownload.this.oldSecs));
                                RuntimeExecDownload.this.oldSecs = akt;
                                RuntimeExecDownload.this.oldSize = actSize;
                            }
                        }
                        catch (NumberFormatException actSize) {
                            // empty catch block
                        }
                    }
                    matcher = patternFfmpegTime.matcher(input);
                    if (RuntimeExecDownload.this.totalSecs > 0.0 && matcher.find()) {
                        String time = matcher.group();
                        if (time.contains(":")) {
                            String[] hms = time.split(":");
                            double aktSecs = (double)(Integer.parseInt(hms[0]) * 3600 + Integer.parseInt(hms[1]) * 60) + Double.parseDouble(hms[2]);
                            double d = aktSecs / RuntimeExecDownload.this.totalSecs * 100.0;
                            this.notifyDouble(d);
                        } else {
                            double aktSecs = Double.parseDouble(time);
                            double d = aktSecs / RuntimeExecDownload.this.totalSecs * 100.0;
                            this.notifyDouble(d);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!ProgData.debug) break block15;
                    P2Log.errorLog(320154795, input);
                }
            }
        }

        private void getFromErrorStreamYtDlp(String input) {
            block11: {
                try {
                    String bandwidth;
                    String size;
                    Matcher matcher = patternYtDlpSize.matcher(input);
                    if (matcher.find() && !(size = matcher.group().trim()).isEmpty()) {
                        try {
                            double targetSize = Double.parseDouble(size) * 1000.0 * 1000.0;
                            long targetLong = (long)targetSize;
                            if (RuntimeExecDownload.this.mVFilmSize.getTargetSize() < targetLong) {
                                RuntimeExecDownload.this.mVFilmSize.setTargetSize(targetLong);
                            }
                        }
                        catch (NumberFormatException targetSize) {
                            // empty catch block
                        }
                    }
                    if ((matcher = patternYtDlpBandwidth.matcher(input)).find() && !(bandwidth = matcher.group().trim()).isEmpty()) {
                        try {
                            long b = Long.parseLong(bandwidth);
                            long akt = RuntimeExecDownload.this.download.getDownloadStartDto().getStartTime().diffInSeconds();
                            if (RuntimeExecDownload.this.oldSecs < akt - 5L) {
                                RuntimeExecDownload.this.download.setBandwidth(b * 1000L * 1000L);
                                RuntimeExecDownload.this.oldSecs = akt;
                            }
                        }
                        catch (NumberFormatException b) {
                            // empty catch block
                        }
                    }
                    if ((matcher = patternYtDlp.matcher(input)).find()) {
                        String percent = matcher.group().trim();
                        double d = Double.parseDouble(percent);
                        this.notifyDouble(d);
                    }
                }
                catch (Exception ex) {
                    if (!ProgData.debug) break block11;
                    P2Log.errorLog(951254697, input);
                }
            }
        }

        private void notifyDouble(double d) {
            double pNeu = d / 100.0;
            RuntimeExecDownload.this.download.setProgress(pNeu);
            if (pNeu != this.percent) {
                this.percent = pNeu;
                if (this.percent_start == -1.0) {
                    this.percent_start = this.percent;
                }
                if (this.percent > this.percent_start + 0.05) {
                    int diffTime = RuntimeExecDownload.this.download.getDownloadStartDto().getStartTime().diffInSeconds();
                    double diffPercent = this.percent - this.percent_start;
                    double restPercent = 1.0 - this.percent;
                    RuntimeExecDownload.this.download.getDownloadStartDto().setTimeLeftSeconds((int)((double)diffTime * restPercent / diffPercent));
                }
            }
        }
    }
}

