/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.starter;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.SizeTools;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.starter.NotificationDownFinished;
import de.p2tools.mtplayer.controller.starter.StartDownloadDto;
import de.p2tools.p2lib.tools.date.P2Date;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.awt.Toolkit;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class LogMsgFactory {
    private LogMsgFactory() {
    }

    public static void addNewDownloadMsg(DownloadData download, boolean start, boolean changeDownload) {
        P2Log.sysLog("");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("------------------------------------------------------------");
        if (changeDownload) {
            if (start) {
                list.add("Download \u00c4NDERN und STARTEN");
            } else {
                list.add("Download \u00c4NDERN und noch NICHT STARTEN");
            }
        } else if (start) {
            list.add("Download ANLEGEN und STARTEN");
        } else {
            list.add("Download ANLEGEN und noch NICHT STARTEN");
        }
        list.add("Programmset: " + (download.getSetData() == null ? "" : download.getSetData().getVisibleName()));
        list.add("Ziel: " + download.getDestPathFile());
        list.add("Titel: " + download.getTitle());
        list.add("URL: " + download.getUrl());
        list.add("Vorgegebene Startzeit: " + download.getStartTime());
        if (download.getType().equals("direkter Download")) {
            list.add("direkter Download");
        } else {
            list.add("Programmaufruf: " + download.getProgramCall());
            list.add("Programmaufruf[]: " + download.getProgramCallArray());
        }
        list.add("  ");
        P2Log.sysLog(list.toArray(new String[0]));
    }

    public static void startMsg(DownloadData download) {
        P2Log.sysLog("");
        ArrayList<Object> list = new ArrayList<Object>();
        boolean play = download.getSource().equals("Button");
        list.add("------------------------------------------------------------");
        if (play) {
            list.add("Film abspielen");
        } else {
            list.add("Download mit dem LADEN STARTEN");
            list.add("Programmset: " + (download.getSetData() == null ? "" : download.getSetData().getVisibleName()));
            list.add("Ziel: " + download.getDestPathFile());
        }
        list.add("Titel: " + download.getTitle());
        list.add("URL: " + download.getUrl());
        list.add("Vorgegebene Startzeit: " + download.getStartTime());
        list.add("Download Startzeit: " + P2DateConst.F_FORMAT_HH__mm__ss.format(download.getDownloadStartDto().getStartTime()));
        if (download.getType().equals("direkter Download")) {
            list.add("direkter Download");
        } else {
            list.add("Programmaufruf: " + download.getProgramCall());
            list.add("Programmaufruf[]: " + download.getProgramCallArray());
        }
        list.add("  ");
        P2Log.sysLog(list.toArray(new String[0]));
    }

    public static void restartMsg(DownloadData download) {
        P2Log.sysLog("");
        ArrayList<CallSite> text = new ArrayList<CallSite>();
        text.add((CallSite)((Object)("Fehlerhaften Download neu starten - Restart (Summe Starts: " + download.getDownloadStartDto().getStartCounter() + ")")));
        text.add((CallSite)((Object)("Ziel: " + download.getDestPathFile())));
        text.add((CallSite)((Object)("URL: " + download.getUrl())));
        P2Log.sysLog(text.toArray(new String[text.size()]));
    }

    public static void finishedMsg(DownloadData download) {
        long dauer;
        StartDownloadDto startDownloadDto = download.getDownloadStartDto();
        if (ProgConfig.DOWNLOAD_BEEP.getValue().booleanValue()) {
            try {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        P2Log.sysLog("");
        ArrayList<String> list = new ArrayList<String>();
        list.add("------------------------------------------------------------");
        if (download.isStateStopped()) {
            list.add("Download wurde abgebrochen");
        } else if (download.getSource().equals("Button")) {
            list.add("Film fertig");
        } else {
            if (download.isStateFinished()) {
                list.add("Download ist fertig und hat geklappt");
            } else if (download.isStateError()) {
                list.add("Download ist fertig und war fehlerhaft");
                if (!startDownloadDto.getErrMsgList().isEmpty()) {
                    startDownloadDto.getErrMsgList().forEach(s -> list.add("   > " + s));
                    list.add("");
                }
            }
            list.add("==== ==== ==== ==== ==== ==== ==== ==== ==== ");
            if (download.isProgramDownloadmanager()) {
                list.add("Programm ist ein Downloadmanager");
            }
            list.add("Programmset: " + (download.getSetData() == null ? "" : download.getSetData().getVisibleName()));
            list.add("Ziel: " + download.getDestPathFile());
        }
        list.add("==== ==== ==== ==== ==== ==== ==== ==== ==== ");
        list.add("Startzeit: " + P2DateConst.F_FORMAT_HH__mm__ss.format(startDownloadDto.getStartTime()));
        list.add("Endzeit: " + P2DateConst.F_FORMAT_HH__mm__ss.format(new P2Date().getTime()));
        if (startDownloadDto.getStartCounter() > 1) {
            list.add("Starts: " + startDownloadDto.getStartCounter());
        }
        if ((dauer = (long)startDownloadDto.getStartTime().diffInMinutes()) == 0L) {
            list.add("Dauer: " + startDownloadDto.getStartTime().diffInSeconds() + " s");
        } else {
            list.add("Dauer: " + startDownloadDto.getStartTime().diffInMinutes() + " Min");
        }
        if (download.getType().equals("direkter Download")) {
            if (startDownloadDto.getInputStream() != null) {
                list.add("==== ==== ==== ==== ==== ==== ==== ==== ==== ");
                list.add("Bandbreite:    " + SizeTools.humanReadableByteCount(startDownloadDto.getInputStream().getSumBandwidth(), true));
                list.add("Bytes geladen (letzter Ladezyklus): " + SizeTools.humanReadableByteCount(startDownloadDto.getInputStream().getSumByte(), true));
                list.add("Bytes geladen (letzter Ladezyklus): " + startDownloadDto.getInputStream().getSumByte() + " Byte");
                list.add("");
                list.add("Bytes soll (aus der URL):      " + SizeTools.humanReadableByteCount(download.getDownloadSize().getTargetSize(), true));
                list.add("Bytes soll (aus der URL):      " + download.getDownloadSize().getTargetSize() + " Byte");
                list.add("");
                list.add("Bytes ist (aus der Zieldatei): " + SizeTools.humanReadableByteCount(download.getDownloadSize().getActuallySize(), true));
                list.add("Bytes ist (aus der Zieldatei): " + download.getDownloadSize().getActuallySize() + " Byte");
            }
        } else {
            list.add("==== ==== ==== ==== ==== ==== ==== ==== ==== ");
            list.add("Bytes ist (aus der Zieldatei): " + SizeTools.humanReadableByteCount(download.getDownloadSize().getActuallySize(), true));
            list.add("Bytes ist (aus der Zieldatei): " + download.getDownloadSize().getActuallySize() + " Byte");
        }
        list.add("==== ==== ==== ==== ==== ==== ==== ==== ==== ");
        list.add("URL: " + download.getUrl());
        if (download.getType().equals("direkter Download")) {
            list.add("direkter Download");
        } else {
            list.add("Programmaufruf: " + download.getProgramCall());
            list.add("Programmaufruf[]: " + download.getProgramCallArray());
        }
        list.add("  ");
        P2Log.sysLog(list);
        if (!download.getSource().equals("Button") && !download.isStateStopped()) {
            new NotificationDownFinished().addNotification(download, download.isStateError());
        }
    }
}

