/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.starter;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.starter.CheckDownloadFileExists;
import de.p2tools.mtplayer.controller.starter.LogMsgFactory;
import de.p2tools.mtplayer.controller.starter.RuntimeExecDownload;
import de.p2tools.mtplayer.controller.starter.StartDownloadFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import java.nio.file.Files;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class DownloadExternal
extends Thread {
    private final ProgData progData;
    private final DownloadData download;
    private final StringProperty errMsg = new SimpleStringProperty();
    private final int stat_start = 0;
    private final int stat_running = 1;
    private final int stat_restart = 3;
    private final int stat_checking = 4;
    private final int stat_finished_ok = 10;
    private final int stat_finished_error = 11;
    private final int stat_finished_abort = 12;
    private final int stat_end = 99;

    public DownloadExternal(ProgData progData, DownloadData download) {
        this.setName("EXTERNAL PROGRAM DL THREAD: " + download.getTitle());
        this.progData = progData;
        this.download = download;
        this.download.setStateStartedRun();
    }

    @Override
    public synchronized void run() {
        LogMsgFactory.startMsg(this.download);
        StartDownloadFactory.makeDirAndLoadInfoSubtitle(this.download);
        this.runWhile();
        StartDownloadFactory.finalizeDownload(this.download);
    }

    private void runWhile() {
        int stat = 0;
        if (!new CheckDownloadFileExists().checkIfContinue(this.progData, this.download, false)) {
            return;
        }
        try {
            while (stat < 99) {
                stat = this.downloadLoop(stat);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(395623710, ex);
            this.download.setStateError(ex.getLocalizedMessage());
        }
    }

    private int downloadLoop(int stat) {
        switch (stat) {
            case 0: {
                stat = this.startDownload();
                break;
            }
            case 1: {
                stat = this.runDownload();
                break;
            }
            case 3: {
                stat = this.restartDownload();
                break;
            }
            case 4: {
                stat = this.checkDownload();
                break;
            }
            case 11: {
                this.download.setStateError(this.errMsg.getValueSafe());
                stat = 99;
                break;
            }
            case 10: {
                this.download.setStateFinished();
                stat = 99;
                break;
            }
            case 12: {
                stat = 99;
            }
        }
        return stat;
    }

    private int startDownload() {
        int retStat;
        this.download.getDownloadStartDto().addStartCounter();
        RuntimeExecDownload runtimeExecDownload = new RuntimeExecDownload(this.download);
        this.download.getDownloadStartDto().setProcess(runtimeExecDownload.exec(true));
        if (this.download.getDownloadStartDto().getProcess() != null) {
            if (this.download.isProgramDownloadmanager()) {
                if (this.download.isAbo()) {
                    this.progData.historyListAbos.addHistoryDataToHistory(this.download.getTheme(), this.download.getTitle(), this.download.getHistoryUrl());
                }
                retStat = 10;
            } else {
                retStat = this.download.getSource().equals("Button") && !this.download.getSetData().isSaveAbo() ? 10 : 1;
            }
        } else {
            retStat = 3;
        }
        return retStat;
    }

    private int runDownload() {
        int retStatus = 1;
        try {
            if (this.download.isStateStopped()) {
                retStatus = 12;
                if (this.download.getDownloadStartDto().getProcess() != null) {
                    this.download.getDownloadStartDto().getProcess().destroy();
                }
                this.download.stopDownload();
            } else {
                Process process = this.download.getDownloadStartDto().getProcess();
                int exitV = process.exitValue();
                retStatus = exitV != 0 ? 3 : 4;
            }
        }
        catch (Exception ex) {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return retStatus;
    }

    private int restartDownload() {
        int retStatus = 3;
        try {
            Files.deleteIfExists(this.download.getFile().toPath());
        }
        catch (Exception ex) {
            P2Log.errorLog(989895674, ex, "file exists: " + this.download.getDestPathFile());
        }
        if (this.download.getDownloadStartDto().getStartCounter() < StartDownloadFactory.SYSTEM_PARAMETER_DOWNLOAD_MAX_RESTART) {
            retStatus = 0;
        } else {
            this.errMsg.setValue("Der Download mit dem Programm: [" + this.download.getProgramName() + "] hat nicht geklappt.");
            retStatus = 11;
        }
        return retStatus;
    }

    private int checkDownload() {
        if (this.download.getSource().equals("Button") || this.download.isProgramDownloadmanager()) {
            return 10;
        }
        if (this.download.getFile().exists()) {
            this.download.getDownloadSize().setActuallySize(this.download.getFile().length());
        } else {
            this.download.getDownloadSize().setActuallySize(0L);
        }
        if (StartDownloadFactory.checkDownloadWasOK(this.progData, this.download, this.errMsg)) {
            return 10;
        }
        return 11;
    }
}

