/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.starter;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.config.ProxyFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.starter.CheckDownloadFileExists;
import de.p2tools.mtplayer.controller.starter.LogMsgFactory;
import de.p2tools.mtplayer.controller.starter.StartDownloadFactory;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.mediathek.download.MtInputStream;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;

public class DownloadDirectHttp
extends Thread {
    private static final int TIMEOUT_LENGTH = 5000;
    private final ProgData progData;
    private final DownloadData download;
    private final Timer bandwidthCalculationTimer;
    private long fileSizeLoaded = 0L;
    private double percentOld = 0.0;
    private double startPercent = -1.0;
    private HttpURLConnection httpURLConn = null;
    private boolean updateDownloadInfos = false;
    private final P2Listener listener = new P2Listener(P2Events.EVENT_TIMER_HALF_SECOND){

        @Override
        public void pingGui() {
            DownloadDirectHttp.this.updateDownloadInfos = true;
        }
    };
    private FileOutputStream fos = null;

    public DownloadDirectHttp(ProgData progData, DownloadData d, Timer bandwidthCalculationTimer) {
        this.progData = progData;
        this.bandwidthCalculationTimer = bandwidthCalculationTimer;
        this.download = d;
        this.setName("DIRECT DL THREAD: " + d.getTitle());
        this.download.setStateStartedRun();
        ProgData.getInstance().pEventHandler.addListener(this.listener);
    }

    @Override
    public synchronized void run() {
        LogMsgFactory.startMsg(this.download);
        StartDownloadFactory.makeDirAndLoadInfoSubtitle(this.download);
        this.runWhile();
        StartDownloadFactory.finalizeDownload(this.download);
        ProgData.getInstance().pEventHandler.removeListener(this.listener);
    }

    private void runWhile() {
        SimpleBooleanProperty restartWithOutSSL = new SimpleBooleanProperty(false);
        boolean restart = true;
        while (restart) {
            restart = false;
            try {
                if (!new CheckDownloadFileExists().checkIfContinue(this.progData, this.download, true)) {
                    this.closeConn();
                    return;
                }
                this.download.getDownloadStartDto().addStartCounter();
                this.openConnForDownload(restartWithOutSSL);
                if (this.download.isStateStartedRun()) {
                    this.downloadContent();
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(316598941, ex, "Fehler");
                if (ex instanceof SSLHandshakeException) {
                    if (this.download.getDownloadStartDto().getStartCounter() == 1 && !restartWithOutSSL.getValue().booleanValue()) {
                        restartWithOutSSL.setValue(this.restartHttps());
                    }
                    this.download.setStateError("DownloadFehler beim SSLHandshake: " + ex.getLocalizedMessage());
                }
                if (ex instanceof SocketTimeoutException) {
                    this.download.setStateError("DownloadFehler, Timeout: " + ex.getLocalizedMessage());
                }
                this.download.setStateError("DownloadFehler: " + ex.getLocalizedMessage());
            }
            if (!this.download.isStateError() || this.download.getDownloadStartDto().getStartCounter() >= StartDownloadFactory.SYSTEM_PARAMETER_DOWNLOAD_MAX_RESTART) continue;
            restart = true;
            this.download.setStateStartedRun();
            try {
                DownloadDirectHttp.sleep(2000L);
            }
            catch (Exception exception) {}
        }
        this.closeConn();
    }

    private void closeConn() {
        try {
            if (this.download.getDownloadStartDto().getInputStream() != null) {
                this.download.getDownloadStartDto().getInputStream().close();
            }
            if (this.fos != null) {
                this.fos.close();
            }
            if (this.httpURLConn != null) {
                this.httpURLConn.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void openConnForDownload(BooleanProperty restartWithOutSSL) throws IOException {
        URL url = new URL(this.download.getUrl());
        this.download.getDownloadSize().setTargetSize(this.getContentLength(url));
        this.download.getDownloadSize().setActuallySize(0L);
        this.httpURLConn = ProxyFactory.getUrlConnection(url);
        if ((restartWithOutSSL.getValue().booleanValue() || ProgConfig.SYSTEM_SSL_ALWAYS_TRUE.getValue().booleanValue()) && this.httpURLConn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)this.httpURLConn;
            httpsConn.setHostnameVerifier((hostname, session) -> true);
        }
        this.setupHttpConnection(this.httpURLConn);
        this.httpURLConn.connect();
        int httpResponseCode = this.httpURLConn.getResponseCode();
        if (httpResponseCode >= 400) {
            String responseCode = "ResponseCode: " + httpResponseCode + P2LibConst.LINE_SEPARATOR + this.httpURLConn.getResponseMessage();
            P2Log.errorLog(915235789, responseCode);
            if (httpResponseCode == 416) {
                this.httpURLConn.disconnect();
                this.httpURLConn = ProxyFactory.getUrlConnection(url);
                this.download.getDownloadStartDto().setDownloaded(0L);
                this.setupHttpConnection(this.httpURLConn);
                this.httpURLConn.connect();
                if (this.httpURLConn.getResponseCode() >= 400) {
                    this.download.setStateError("DownloadFehler, httpResponseCode 416: Der angeforderte Teil einer Ressource war ung\u00fcltig oder steht auf dem Server nicht zur Verf\u00fcgung.");
                }
            } else if (httpResponseCode == 404) {
                this.download.setStateError("Die URL wurde nicht gefunden.");
            } else {
                this.download.setStateError("DownloadFehler, httpResponseCode " + httpResponseCode + ": Der angeforderte Teil einer Ressource konnte nicht geladen werden.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getContentLength(URL url) {
        long ret = -1L;
        HttpURLConnection connection = null;
        try {
            connection = ProxyFactory.getUrlConnection(url);
            connection.setRequestProperty("User-Agent", ProgInfos.getUserAgent());
            connection.setReadTimeout(5000);
            connection.setConnectTimeout(5000);
            if (connection.getResponseCode() < 400) {
                ret = connection.getContentLengthLong();
            }
            if (ret < 300000L) {
                ret = -1L;
            }
        }
        catch (Exception ex) {
            ret = -1L;
            P2Log.errorLog(643298301, ex);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return ret;
    }

    private void setupHttpConnection(HttpURLConnection conn) {
        conn.setRequestProperty("Range", "bytes=" + this.download.getDownloadStartDto().getDownloaded() + "-");
        conn.setRequestProperty("User-Agent", ProgInfos.getUserAgent());
        conn.setDoInput(true);
        conn.setDoOutput(true);
    }

    private void downloadContent() throws Exception {
        int len;
        this.download.getDownloadStartDto().setInputStream(new MtInputStream(this.httpURLConn.getInputStream(), this.bandwidthCalculationTimer, ProgConfig.DOWNLOAD_MAX_BANDWIDTH_BYTE, ProgData.FILMLIST_IS_DOWNLOADING));
        this.fos = new FileOutputStream(this.download.getDownloadStartDto().getFile(), this.download.getDownloadStartDto().getDownloaded() != 0L);
        this.download.getDownloadSize().setActuallySize(this.download.getDownloadStartDto().getDownloaded());
        byte[] buffer = new byte[4096];
        while ((len = this.download.getDownloadStartDto().getInputStream().read(buffer)) != -1 && !this.download.isStateStopped()) {
            this.download.getDownloadStartDto().setDownloaded(this.download.getDownloadStartDto().getDownloaded() + (long)len);
            this.fos.write(buffer, 0, len);
            if (!this.updateDownloadInfos) continue;
            this.updateDownloadInfos = false;
            this.setDownloadProgress(false);
        }
        this.setDownloadProgress(true);
        if (!this.download.isStateStopped()) {
            SimpleStringProperty strErrorMsg = new SimpleStringProperty();
            if (this.download.getSource().equals("Button")) {
                this.download.setStateFinished();
            } else if (StartDownloadFactory.checkDownloadWasOK(this.progData, this.download, strErrorMsg)) {
                this.download.setStateFinished();
            } else {
                this.download.setStateError(strErrorMsg.getValueSafe());
            }
        } else {
            this.download.stopDownload();
        }
    }

    private void setDownloadProgress(boolean withExactFileSize) {
        if (withExactFileSize) {
            if (this.download.getFile().exists()) {
                this.download.getDownloadSize().setActuallySize(this.download.getFile().length());
            } else {
                this.download.getDownloadSize().setActuallySize(0L);
            }
        } else {
            this.download.getDownloadSize().setActuallySize(this.download.getDownloadStartDto().getDownloaded());
        }
        if (this.fileSizeLoaded == this.download.getDownloadSize().getActuallySize()) {
            return;
        }
        long aktBandwidth = this.download.getDownloadStartDto().getInputStream().getBandwidth();
        if (aktBandwidth != this.download.getBandwidth()) {
            this.download.setBandwidth(aktBandwidth);
        }
        this.fileSizeLoaded = this.download.getDownloadSize().getActuallySize();
        long fileTargetSize = this.download.getDownloadSize().getTargetSize();
        if (fileTargetSize > 0L) {
            double percentActProgress = 1.0 * (double)this.fileSizeLoaded / (double)fileTargetSize;
            if (this.startPercent == -1.0) {
                this.startPercent = percentActProgress;
            }
            if (percentActProgress == 0.0) {
                percentActProgress = 0.001;
            } else if (percentActProgress >= 1.0) {
                percentActProgress = 0.995;
            }
            this.download.setProgress(percentActProgress);
            if (percentActProgress != this.percentOld) {
                this.percentOld = percentActProgress;
                if (percentActProgress > 0.001 && percentActProgress > this.startPercent) {
                    long timeLeft = 0L;
                    long sizeLeft = fileTargetSize - this.fileSizeLoaded;
                    if (sizeLeft > 0L && aktBandwidth > 0L) {
                        timeLeft = sizeLeft / aktBandwidth;
                    }
                    this.download.getDownloadStartDto().setTimeLeftSeconds((int)timeLeft);
                    StartDownloadFactory.canAlreadyStarted(this.download);
                }
            }
        }
    }

    private boolean restartHttps() {
        ArrayList<CallSite> text = new ArrayList<CallSite>();
        text.add((CallSite)((Object)("Ziel: " + this.download.getDestPathFile())));
        text.add((CallSite)((Object)("URL: " + this.download.getUrl())));
        P2Log.sysLog(text.toArray(new String[0]));
        AtomicBoolean dialog = new AtomicBoolean(true);
        AtomicBoolean ret = new AtomicBoolean(false);
        Platform.runLater(() -> {
            ret.set(P2Alert.showAlertOkCancel("HTTPS", "Problem mit der HTTPS-Verbindung", "Beim Verbindungsaufbau mit der HTTPS-URL trat ein Problem auf. Soll versucht werden, die Verbindung ohne die Pr\u00fcfung des Zertifikats aufzubauen?\n\n" + this.download.getTitle() + "\n\n" + this.download.getUrl()));
            dialog.set(false);
        });
        while (dialog.get()) {
            try {
                this.wait(200L);
            }
            catch (Exception exception) {}
        }
        return ret.get();
    }
}

