/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.starter;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgConfigAskBeforeDelete;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryMakeParameter;
import de.p2tools.mtplayer.gui.dialog.downloaddialog.DownloadContinueDialogController;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;

public class CheckDownloadFileExists {
    boolean checkIfContinue(ProgData progData, DownloadData download, boolean httpDownload) {
        if (!httpDownload && download.isProgramDownloadmanager()) {
            return true;
        }
        if (!httpDownload && download.getSource().equals("Button") && !download.getSetData().isSaveAbo()) {
            return true;
        }
        if (!httpDownload) {
            download.getDownloadSize().clearSize();
        }
        download.getDownloadStartDto().setDownloaded(0L);
        if (!download.getFile().exists()) {
            return true;
        }
        AtomicBoolean dialogBreakIsVis = new AtomicBoolean(true);
        AtomicBoolean retBreak = new AtomicBoolean(true);
        Platform.runLater(() -> {
            retBreak.set(this.checkContinue(progData, download, httpDownload));
            dialogBreakIsVis.set(false);
        });
        while (dialogBreakIsVis.get()) {
            try {
                this.wait(200L);
            }
            catch (Exception exception) {}
        }
        return retBreak.get();
    }

    private boolean checkContinue(ProgData progData, DownloadData download, boolean httpDownload) {
        ProgConfigAskBeforeDelete.ContinueDownload result;
        if (!download.getFile().exists()) {
            return true;
        }
        boolean ccontinue = true;
        boolean isNewName = false;
        if (ProgData.autoMode) {
            result = ProgConfigAskBeforeDelete.ContinueDownload.RESTART;
        } else if (ProgConfig.DOWNLOAD_CONTINUE.getValue() == 1) {
            result = ProgConfigAskBeforeDelete.ContinueDownload.CONTINUE;
        } else if (ProgConfig.DOWNLOAD_CONTINUE.getValue() == 2) {
            result = ProgConfigAskBeforeDelete.ContinueDownload.RESTART;
        } else {
            DownloadContinueDialogController downloadContinueDialogController = new DownloadContinueDialogController(ProgConfig.DOWNLOAD_DIALOG_CONTINUE_SIZE, progData, download, httpDownload);
            result = downloadContinueDialogController.getResult();
            isNewName = downloadContinueDialogController.isNewName();
        }
        if (!httpDownload && result == ProgConfigAskBeforeDelete.ContinueDownload.CONTINUE) {
            result = ProgConfigAskBeforeDelete.ContinueDownload.RESTART;
        }
        switch (result) {
            case CANCEL: {
                download.stopDownload();
                ccontinue = false;
                break;
            }
            case CONTINUE: {
                download.getDownloadStartDto().setDownloaded(download.getFile().length());
                break;
            }
            case RESTART: {
                download.getDownloadStartDto().setDownloaded(0L);
                if (isNewName) {
                    if (!httpDownload) {
                        DownloadFactoryMakeParameter.makeProgParameter(download);
                    }
                    try {
                        Files.createDirectories(Paths.get(download.getDestPath(), new String[0]), new FileAttribute[0]);
                    }
                    catch (IOException downloadContinueDialogController) {}
                    break;
                }
                try {
                    Files.deleteIfExists(download.getFile().toPath());
                    break;
                }
                catch (Exception ex) {
                    P2Log.errorLog(945757586, ex, "file exists: " + download.getDestPathFile());
                }
            }
        }
        return ccontinue;
    }
}

