/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mv;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.p2lib.alert.P2Alert;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.stage.Stage;

public class MVFactory {
    private MVFactory() {
    }

    public static String getSettingsDirectory() {
        String stdDir = ".mediathek3";
        Path baseDirectoryPath = Paths.get(System.getProperty("user.home"), ".mediathek3");
        if (baseDirectoryPath.toFile().exists() && baseDirectoryPath.toFile().isDirectory()) {
            return baseDirectoryPath.toString();
        }
        return "";
    }

    public static int importAbosMediathekView(Stage stage, ObservableList<AboData> aboList) {
        int ret = 0;
        SimpleBooleanProperty remember = new SimpleBooleanProperty(false);
        boolean todo = true;
        for (AboData aboData : aboList) {
            AboData abo = AboFactory.aboExistsAlready(aboData, false);
            if (abo != null) {
                if (!remember.getValue().booleanValue()) {
                    P2Alert.BUTTON btn = P2Alert.alert_yes_no_remember(stage, "Fehler", "Abo anlegen", "Ein Abo mit den Einstellungen existiert bereits: \n\n" + (String)(abo.getChannel().isEmpty() ? "" : "Sender: " + abo.getChannel() + "\n") + (String)(abo.getTheme().isEmpty() ? "" : "Thema: " + abo.getTheme() + "\n") + (String)(abo.getThemeTitle().isEmpty() ? "" : "Thema-Titel: " + abo.getThemeTitle() + "\n") + (String)(abo.getTitle().isEmpty() ? "" : "Titel: " + abo.getTitle() + "\n") + (String)(abo.getSomewhere().isEmpty() ? "" : "Irgendwo: " + abo.getSomewhere()) + "\n\nTrotzdem anlegen?", remember, "Immer");
                    todo = btn.equals((Object)P2Alert.BUTTON.YES);
                }
                if (!todo) continue;
            }
            ++ret;
            ProgData.getInstance().aboList.addAbo(aboData);
        }
        return ret;
    }

    public static int addBlacks(ObservableList<BlackData> blackList) {
        int ret = 0;
        for (BlackData blackData : blackList) {
            if (BlacklistFactory.blackExistsAlready(blackData, ProgData.getInstance().blackList)) continue;
            ++ret;
            ProgData.getInstance().blackList.add(blackData);
        }
        return ret;
    }
}

