/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mv;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javafx.collections.ObservableList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class LoadMV
implements AutoCloseable {
    private final XMLInputFactory inFactory;
    private final ObservableList<AboData> aboList;
    private final ObservableList<BlackData> blackList;

    public LoadMV(ObservableList<AboData> aboList, ObservableList<BlackData> blackList) {
        this.aboList = aboList;
        this.blackList = blackList;
        this.inFactory = XMLInputFactory.newInstance();
        this.inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.inFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.inFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
    }

    public boolean readConfiguration(Path xmlFilePath) {
        boolean ret;
        this.aboList.clear();
        this.blackList.clear();
        Path configPath = Path.of(xmlFilePath.toString(), "mediathek.xml");
        if (!Files.exists(configPath, new LinkOption[0])) {
            return false;
        }
        P2Duration.counterStart("readConfiguration");
        try (InputStream is = Files.newInputStream(configPath, new OpenOption[0]);
             InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);){
            ret = this.read(in);
        }
        catch (Exception ex) {
            ret = false;
            P2Log.errorLog(951254698, ex);
        }
        P2Duration.counterStop("readConfiguration");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean read(InputStreamReader in) {
        boolean ret;
        XMLStreamReader parser = null;
        try {
            parser = this.inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                String xmlElem;
                int event = parser.next();
                if (event != 1 || (xmlElem = parser.getLocalName()).equals("Abonnement") && this.getAbos(parser) || !xmlElem.equals("Blacklist") || !this.getBlackList(parser)) continue;
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
            P2Log.errorLog(915263478, ex);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    private boolean getAbos(XMLStreamReader parser) {
        boolean ret = false;
        AboData aboData = new AboData();
        this.aboList.add(aboData);
        String xmlElem = parser.getLocalName();
        try {
            int event;
            while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                String localName = parser.getLocalName();
                String value = parser.getElementText();
                switch (localName) {
                    case "aktiv": {
                        if (value.equals("true")) {
                            aboData.setActive(true);
                            break;
                        }
                        aboData.setActive(false);
                        break;
                    }
                    case "Name": {
                        aboData.setName("MV: " + value);
                        break;
                    }
                    case "Sender": {
                        aboData.setChannel(value);
                        break;
                    }
                    case "Thema": {
                        aboData.setTheme(value);
                        aboData.setThemeExact(false);
                        break;
                    }
                    case "Titel": {
                        aboData.setTitle(value);
                        break;
                    }
                    case "Thema-Titel": {
                        aboData.setThemeTitle(value);
                        break;
                    }
                    case "Irgendwo": {
                        aboData.setSomewhere(value);
                        break;
                    }
                    case "Mindestdauer": {
                        try {
                            aboData.setMinDurationMinute(Integer.parseInt(value));
                        }
                        catch (Exception ex) {
                            aboData.setMinDurationMinute(0);
                        }
                        break;
                    }
                    case "min_max": {
                        if (!value.equals("false")) break;
                        aboData.setMaxDurationMinute(aboData.getMinDurationMinute());
                        aboData.setMinDurationMinute(0);
                        break;
                    }
                    case "Zielpfad": {
                        aboData.setAboSubDir(value);
                        break;
                    }
                    case "letztes_Abo": {
                        aboData.setDate(value, "");
                        break;
                    }
                    case "Programmset": {
                        aboData.setSetData(ProgData.getInstance().setDataList.getSetDataForAbo(""));
                    }
                }
            }
            ret = true;
        }
        catch (Exception ex) {
            P2Log.errorLog(102365494, ex);
        }
        return ret;
    }

    private boolean getBlackList(XMLStreamReader parser) {
        boolean ret = false;
        BlackData blackData = new BlackData();
        this.blackList.add(blackData);
        blackData.setThemeExact(false);
        String xmlElem = parser.getLocalName();
        try {
            int event;
            while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                String localName = parser.getLocalName();
                String value = parser.getElementText();
                switch (localName) {
                    case "black-sender": {
                        blackData.setChannel(value);
                        break;
                    }
                    case "black-thema": {
                        blackData.setTheme(value);
                        blackData.setThemeExact(true);
                        break;
                    }
                    case "black-titel": {
                        blackData.setTitle(value);
                        break;
                    }
                    case "black-thema-titel": {
                        blackData.setThemeTitle(value);
                    }
                }
            }
            ret = true;
        }
        catch (Exception ex) {
            P2Log.errorLog(102365494, ex);
        }
        return ret;
    }

    @Override
    public void close() throws Exception {
    }
}

