/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mediadb;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class WriteMediaDb
implements AutoCloseable {
    private XMLStreamWriter writer = null;
    private OutputStreamWriter out = null;
    private Path xmlFilePath = null;
    private OutputStream os = null;
    private ArrayList<String> logList = new ArrayList();
    boolean writeLog = false;
    private List<MediaData> mediaDbList;
    private final ProgData progData;

    public WriteMediaDb(ProgData progData) {
        this.progData = progData;
    }

    public synchronized void writeExternalMediaData() {
        this.writeLog = true;
        this.writeExternalMediaData(this.logList);
    }

    public synchronized void writeExternalMediaData(ArrayList<String> logList) {
        Path path = this.getPathMediaDB();
        this.logList = logList;
        logList.add("MediaDB (extern) schreiben");
        logList.add("   --> Schreiben nach: " + path.toString());
        try {
            File file = path.toFile();
            File dir = new File(file.getParent());
            if (!dir.exists() && !dir.mkdirs()) {
                P2Log.errorLog(932102478, "Kann den Pfad nicht anlegen: " + dir.toString());
                Platform.runLater(() -> P2Alert.showErrorAlert("Fehler beim Schreiben", "Der Pfad zum Schreiben der Mediensammlung kann nicht angelegt werden: " + P2LibConst.LINE_SEPARATOR + path.toString()));
                return;
            }
            List<MediaData> externalMediaData = this.getExternalMediaData();
            logList.add("   --> Anzahl externe Medien: " + externalMediaData.size());
            this.write(path, externalMediaData);
            logList.add("   --> geschrieben!");
        }
        catch (Exception ex) {
            logList.add("   --> Fehler, nicht geschrieben!");
            P2Log.errorLog(931201478, ex, "nach: " + path.toString());
            Platform.runLater(() -> P2Alert.showErrorAlert("Fehler beim Schreiben", "Die Mediensammlung konnte nicht geschrieben werden:" + P2LibConst.LINE_SEPARATOR + path.toString()));
        }
        if (this.writeLog) {
            P2Log.sysLog(logList);
        }
    }

    private synchronized void write(Path file, List<MediaData> mediaDbList) {
        try {
            this.mediaDbList = mediaDbList;
            this.xmlFilePath = file;
            this.writeXmlData();
        }
        catch (Exception ex) {
            this.logList.add("Fehler, nicht geschrieben!");
            P2Log.errorLog(656328109, ex);
            Platform.runLater(() -> P2Alert.showErrorAlert("Fehler beim Schreiben", "Die Mediensammlung konnte nicht geschrieben werden:" + P2LibConst.LINE_SEPARATOR + file.toString()));
        }
    }

    private Path getPathMediaDB() {
        Path urlPath = null;
        try {
            urlPath = Paths.get(ProgInfos.getSettingsDirectory_String(), new String[0]).resolve("mediadb.txt");
            if (Files.notExists(urlPath, new LinkOption[0])) {
                urlPath = Files.createFile(urlPath, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            P2Log.errorLog(951201201, ex);
        }
        return urlPath;
    }

    private synchronized List<MediaData> getExternalMediaData() {
        return this.progData.mediaDataList.parallelStream().filter(mediaData -> mediaData != null && mediaData.isExternal()).collect(Collectors.toList());
    }

    private void writeXmlData() throws XMLStreamException, IOException {
        this.xmlWriteStart();
        this.writer.writeCharacters(P2LibConst.LINE_SEPARATORx2);
        this.writer.writeComment("MediaDb");
        this.writer.writeCharacters(P2LibConst.LINE_SEPARATOR);
        this.xmlWrite();
        this.writer.writeCharacters(P2LibConst.LINE_SEPARATORx2);
        this.xmlWriteEnd();
    }

    private void xmlWriteStart() throws IOException, XMLStreamException {
        this.os = Files.newOutputStream(this.xmlFilePath, new OpenOption[0]);
        this.out = new OutputStreamWriter(this.os, StandardCharsets.UTF_8);
        XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
        this.writer = outFactory.createXMLStreamWriter(this.out);
        this.writer.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
        this.writer.writeCharacters(P2LibConst.LINE_SEPARATOR);
        this.writer.writeStartElement("P2Tools");
        this.writer.writeCharacters(P2LibConst.LINE_SEPARATOR);
    }

    private void xmlWrite() throws XMLStreamException {
        for (MediaData mediaData : this.mediaDbList) {
            String[] arr = mediaData.setXmlFromProps();
            if (!mediaData.isExternal()) continue;
            this.xmlWrite("Mediensammlung", MediaData.XML_NAMES, arr, true);
        }
    }

    private void xmlWrite(String xmlName, String[] xmlColumn, String[] dataArray, boolean newLine) throws XMLStreamException {
        int xmlMax = dataArray.length;
        this.writer.writeStartElement(xmlName);
        if (newLine) {
            this.writer.writeCharacters(P2LibConst.LINE_SEPARATOR);
        }
        for (int i = 0; i < xmlMax; ++i) {
            if (dataArray[i].isEmpty()) continue;
            if (newLine) {
                this.writer.writeCharacters("\t");
            }
            this.writer.writeStartElement(xmlColumn[i]);
            this.writer.writeCharacters(dataArray[i]);
            this.writer.writeEndElement();
            if (!newLine) continue;
            this.writer.writeCharacters(P2LibConst.LINE_SEPARATOR);
        }
        this.writer.writeEndElement();
        this.writer.writeCharacters(P2LibConst.LINE_SEPARATOR);
    }

    private void xmlWriteEnd() throws XMLStreamException {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.flush();
    }

    @Override
    public void close() throws XMLStreamException, IOException {
        this.writer.close();
        this.out.close();
        this.os.close();
    }
}

