/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mediadb;

import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class ReadMediaDb
implements AutoCloseable {
    private final XMLInputFactory inFactory;
    private final ArrayList<MediaData> list = new ArrayList();

    public ReadMediaDb() {
        this.inFactory = XMLInputFactory.newInstance();
        this.inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.inFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.inFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
    }

    public List<MediaData> loadSavedExternalMediaData() {
        Path urlPath = this.getPathMediaDB();
        return new ReadMediaDb().readDb(urlPath);
    }

    private Path getPathMediaDB() {
        Path urlPath = null;
        try {
            urlPath = Paths.get(ProgInfos.getSettingsDirectory_String(), new String[0]).resolve("mediadb.txt");
            if (Files.notExists(urlPath, new LinkOption[0])) {
                urlPath = Files.createFile(urlPath, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            P2Log.errorLog(951201201, ex);
        }
        return urlPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MediaData> readDb(Path xmlFilePath) {
        if (!Files.exists(xmlFilePath, new LinkOption[0]) || xmlFilePath.toFile().length() == 0L) {
            return this.list;
        }
        P2Duration.counterStart("readDb");
        XMLStreamReader parser = null;
        try (InputStream is = Files.newInputStream(xmlFilePath, new OpenOption[0]);
             InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);){
            parser = this.inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                String[] arr;
                int event = parser.next();
                if (event != 1 || !parser.getLocalName().equals("Mediensammlung") || !this.get(parser, "Mediensammlung", MediaData.XML_NAMES, arr = MediaData.getArr())) continue;
                MediaData mediaData = new MediaData(arr);
                this.list.add(mediaData);
            }
        }
        catch (Exception ex) {
            this.list.clear();
            P2Log.errorLog(936251078, ex);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
            }
            catch (Exception exception) {}
        }
        P2Duration.counterStop("readDb");
        return this.list;
    }

    private boolean get(XMLStreamReader parser, String xmlElem, String[] xmlNames, String[] strRet) {
        boolean ret = true;
        int maxElem = strRet.length;
        for (int i = 0; i < maxElem; ++i) {
            if (strRet[i] != null) continue;
            strRet[i] = "";
        }
        try {
            int event;
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (int i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            P2Log.errorLog(912036578, ex);
        }
        return ret;
    }

    @Override
    public void close() throws Exception {
    }
}

