/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mediadb;

import de.p2tools.mtplayer.controller.data.history.HistoryData;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.p2lib.mediathek.filter.Filter;
import de.p2tools.p2lib.mediathek.filter.FilterCheck;
import java.util.function.Predicate;
import javafx.beans.property.IntegerProperty;

public class MediaSearchPredicateFactory {
    private MediaSearchPredicateFactory() {
    }

    public static Predicate<MediaData> getPredicateMediaData(IntegerProperty searchInProperty, String searchStr) {
        String search = searchStr.trim();
        return media -> {
            if (search.isEmpty()) {
                return true;
            }
            Filter filter = new Filter(search, true);
            if (searchInProperty.getValue() == 0) {
                return FilterCheck.check(filter, media.getPath());
            }
            if (searchInProperty.getValue() == 1) {
                return FilterCheck.check(filter, media.getName());
            }
            return FilterCheck.check(filter, media.getPath()) || FilterCheck.check(filter, media.getName());
        };
    }

    public static Predicate<HistoryData> getPredicateHistoryData(IntegerProperty searchInProperty, String searchStr) {
        String search = searchStr.trim();
        return historyData -> {
            if (search.isEmpty()) {
                return true;
            }
            Filter filter = new Filter(search, true);
            if (searchInProperty.getValue() == 0) {
                return FilterCheck.check(filter, historyData.getTheme());
            }
            if (searchInProperty.getValue() == 1) {
                return FilterCheck.check(filter, historyData.getTitle());
            }
            return FilterCheck.check(filter, historyData.getTheme()) || FilterCheck.check(filter, historyData.getTitle());
        };
    }
}

