/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mediadb;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.mediadb.CreateMediaDb;
import de.p2tools.mtplayer.controller.mediadb.ExportMediaDB;
import de.p2tools.mtplayer.controller.mediadb.MediaCollectionData;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.mtplayer.controller.mediadb.WriteMediaDb;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import java.nio.file.Path;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class MediaDataWorker {
    private static ProgData progData = ProgData.getInstance();
    private static BooleanProperty exportIsWorking = new SimpleBooleanProperty(false);

    private MediaDataWorker() {
    }

    public static synchronized void createMediaDb() {
        if (MediaDataWorker.progData.mediaDataList.isSearching()) {
            return;
        }
        Thread th = new Thread(new CreateTheMediaDB());
        th.setName("CreateTheMediaDB -> createInternalMediaDb");
        th.start();
    }

    public static synchronized void updateCollection(MediaCollectionData mediaCollectionData) {
        if (MediaDataWorker.progData.mediaDataList.isSearching()) {
            return;
        }
        MediaDataWorker.progData.mediaDataList.removeMediaData(mediaCollectionData);
        mediaCollectionData.setCount(0);
        Thread th = new Thread(new CreateTheMediaDB(mediaCollectionData));
        th.setName("updateCollection");
        th.start();
    }

    public static synchronized void exportMediaDB(List<MediaData> list, String pathStr, boolean internDB, boolean externDB) {
        if (exportIsWorking.get()) {
            return;
        }
        Path path = Path.of(pathStr, new String[0]);
        int export = internDB && !externDB ? 0 : (!internDB && externDB ? 1 : 2);
        if (path.toFile().exists()) {
            P2Alert.BUTTON button = P2Alert.showAlert_yes_no("Hinweis", "Mediensammlung in Datei exportieren", "Die Zieldatei existiert bereits:" + P2LibConst.LINE_SEPARATOR + path.toString() + P2LibConst.LINE_SEPARATORx2 + "Soll die Datei \u00fcberschrieben werden?");
            if (button.equals((Object)P2Alert.BUTTON.YES)) {
                path.toFile().delete();
            } else {
                return;
            }
        }
        exportIsWorking.set(true);
        Thread th = new Thread(new ExportMediaDB(list, exportIsWorking, path, export));
        th.setName("ExportMediaDB");
        th.start();
    }

    public static synchronized void removeMediaCollection(List<MediaCollectionData> dataList, boolean external) {
        if (MediaDataWorker.progData.mediaDataList.isSearching()) {
            return;
        }
        MediaDataWorker.progData.mediaCollectionDataList.addDataToUndoList(dataList, external);
        dataList.forEach(mediaCollectionData -> {
            mediaCollectionData.setCount(0);
            MediaDataWorker.progData.mediaCollectionDataList.remove(mediaCollectionData);
            MediaDataWorker.progData.mediaDataList.removeMediaData((MediaCollectionData)mediaCollectionData);
        });
        if (external) {
            new WriteMediaDb(progData).writeExternalMediaData();
        }
    }

    private static class CreateTheMediaDB
    implements Runnable {
        MediaCollectionData mediaCollectionData = null;

        public CreateTheMediaDB() {
        }

        public CreateTheMediaDB(MediaCollectionData mediaCollectionData) {
            this.mediaCollectionData = mediaCollectionData;
        }

        @Override
        public void run() {
            new CreateMediaDb().createDB(this.mediaCollectionData);
        }
    }
}

