/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mediadb;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.mediadb.MediaCollectionData;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class MediaDataList
extends SimpleListProperty<MediaData> {
    private FilteredList<MediaData> filteredList = null;
    private SortedList<MediaData> sortedList = null;
    private BooleanProperty searching = new SimpleBooleanProperty(false);
    private boolean stopSearching = false;

    public MediaDataList() {
        super(FXCollections.observableArrayList());
    }

    public synchronized boolean getSearching() {
        return this.searching.get();
    }

    public synchronized BooleanProperty searchingProperty() {
        return this.searching;
    }

    public boolean isSearching() {
        return this.searching.get();
    }

    public synchronized void setSearching(boolean searching) {
        this.searching.set(searching);
    }

    public boolean isStopSearching() {
        return this.stopSearching;
    }

    public void setStopSearching(boolean stopSearching) {
        this.stopSearching = stopSearching;
    }

    public synchronized SortedList<MediaData> getSortedList() {
        this.filteredList = this.getFilteredList();
        if (this.sortedList == null) {
            this.sortedList = new SortedList<MediaData>((ObservableList<MediaData>)this.filteredList);
        }
        return this.sortedList;
    }

    public synchronized FilteredList<MediaData> getFilteredList() {
        if (this.filteredList == null) {
            this.filteredList = new FilteredList<MediaData>(this, p -> true);
        }
        return this.filteredList;
    }

    public synchronized void filteredListSetPredicate(Predicate<MediaData> predicate) {
        this.filteredList.setPredicate(predicate);
    }

    public synchronized void filterdListSetPredFalse() {
        this.filteredList.setPredicate(p -> false);
    }

    public synchronized void filterdListSetPredTrue() {
        this.filteredList.setPredicate(p -> true);
    }

    synchronized void removeMediaData(MediaCollectionData mediaCollectionData) {
        ArrayList rest = new ArrayList();
        this.stream().filter(mediaData -> mediaData.getCollectionId() != mediaCollectionData.getIdInt()).forEach(rest::add);
        this.setAll(rest);
    }

    synchronized void checkDuplicateMediaData() {
        MediaData mediaData;
        HashSet<CallSite> hashSet = new HashSet<CallSite>(this.size());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            mediaData = (MediaData)it.next();
            if (!mediaData.isExternal() || hashSet.add((CallSite)((Object)(mediaData.getName() + mediaData.getPath())))) continue;
            it.remove();
        }
        it = this.iterator();
        while (it.hasNext()) {
            mediaData = (MediaData)it.next();
            if (mediaData.isExternal() || hashSet.add((CallSite)((Object)(mediaData.getName() + mediaData.getPath())))) continue;
            it.remove();
        }
        hashSet.clear();
    }

    public synchronized void countMediaData(ProgData progData) {
        progData.mediaCollectionDataList.forEach(collectionData -> collectionData.setCount(0));
        this.forEach(mediaData -> {
            MediaCollectionData mediaCollectionData = progData.mediaCollectionDataList.getMediaCollectionData(mediaData.getCollectionId());
            if (mediaCollectionData != null) {
                mediaCollectionData.setCount(mediaCollectionData.getCount() + 1);
            }
        });
    }
}

