/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mediadb;

import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import javafx.beans.property.BooleanProperty;

public class ExportMediaDB
implements Runnable {
    private final List<MediaData> list;
    private final BooleanProperty isWorking;
    private final Path path;
    private int export;

    public ExportMediaDB(List<MediaData> list, BooleanProperty isWorking, Path path, int export) {
        this.list = list;
        this.isWorking = isWorking;
        this.path = path;
        this.export = export;
    }

    @Override
    public void run() {
        this.doWork();
        this.isWorking.setValue(false);
    }

    private void doWork() {
        P2Duration.counterStart("MediaData: Thread: ExportMediaDB");
        P2Log.sysLog("MedienDB in Textdatei schreiben: " + this.list.size() + ", Datei: " + this.path.toString());
        this.writeMediaDataToFile(this.list);
        P2Duration.counterStop("MediaData: Thread: ExportMediaDB");
    }

    private boolean writeMediaDataToFile(List<MediaData> list) {
        boolean ret = false;
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.path, new OpenOption[0])));){
            for (MediaData mediaData : list) {
                String line = mediaData.getPath() + File.separator + mediaData.getName();
                if (this.export == 0 && !mediaData.isExternal()) {
                    bufferedWriter.write(line);
                    bufferedWriter.write(P2LibConst.LINE_SEPARATOR);
                    continue;
                }
                if (this.export == 1 && mediaData.isExternal()) {
                    bufferedWriter.write(line);
                    bufferedWriter.write(P2LibConst.LINE_SEPARATOR);
                    continue;
                }
                if (this.export != 2) continue;
                bufferedWriter.write(line);
                bufferedWriter.write(P2LibConst.LINE_SEPARATOR);
            }
            ret = true;
        }
        catch (Exception ex) {
            P2Log.errorLog(742590235, ex);
        }
        return ret;
    }
}

