/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mediadb;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.mediadb.MediaCollectionData;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.mtplayer.controller.mediadb.MediaDataList;
import de.p2tools.mtplayer.controller.mediadb.ReadMediaDb;
import de.p2tools.mtplayer.controller.mediadb.WriteMediaDb;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;

public class CreateMediaDb {
    private String error = "";
    private boolean more = false;
    private final ProgData progData;
    private final MediaDataList mediaDataList;
    private String[] suffix;
    private final ArrayList<String> logs = new ArrayList();
    final boolean withoutSuffix = ProgConfig.MEDIA_DB_WITH_OUT_SUFFIX.getValue();
    final boolean noHiddenFiles = ProgConfig.MEDIA_DB_NO_HIDDEN_FILES.getValue();
    final int fileSize = ProgConfig.MEDIA_DB_FILE_SIZE_MBYTE.getValue() * 1000 * 1000;
    final boolean checkFileSize = this.fileSize > 0;

    public CreateMediaDb() {
        this.progData = ProgData.getInstance();
        this.mediaDataList = this.progData.mediaDataList;
        this.getSuffix();
    }

    public void createDB(MediaCollectionData mediaCollectionData) {
        if (mediaCollectionData == null) {
            this.create();
        } else {
            this.create(mediaCollectionData);
        }
    }

    private void create() {
        ArrayList<MediaData> tmpMediaDataList = new ArrayList<MediaData>();
        this.start();
        try {
            this.logs.add("Gesamte Mediensammlung aufbauen");
            tmpMediaDataList.addAll(new ReadMediaDb().loadSavedExternalMediaData());
            this.progData.mediaCollectionDataList.cleanUpInternalMediaCollectionData();
            for (MediaCollectionData mediaCollectionData2 : this.progData.mediaCollectionDataList.getMediaCollectionDataList(false)) {
                File f = new File(mediaCollectionData2.getPath());
                if (f.canRead()) continue;
                if (!this.error.isEmpty()) {
                    this.error = this.error + P2LibConst.LINE_SEPARATOR;
                    this.more = true;
                }
                this.error = this.error + f.getPath();
            }
            if (!this.error.isEmpty()) {
                this.errorMsg();
            }
            this.progData.mediaCollectionDataList.getMediaCollectionDataList(false).forEach(mediaCollectionData -> {
                if (mediaCollectionData.getCollectionName().isEmpty()) {
                    String name = this.progData.mediaCollectionDataList.getNextMediaCollectionName(false);
                    mediaCollectionData.setCollectionName(name);
                }
                this.searchFile(new File(mediaCollectionData.getPath()), mediaCollectionData.getIdInt(), tmpMediaDataList);
            });
            this.logs.add(" -> gefundene Medien: " + tmpMediaDataList.size());
            this.mediaDataList.setAll(tmpMediaDataList);
            this.mediaDataList.checkDuplicateMediaData();
            this.mediaDataList.countMediaData(this.progData);
        }
        catch (Exception ex) {
            P2Log.errorLog(945120375, ex);
        }
        this.stop();
    }

    private void create(MediaCollectionData mediaCollectionData) {
        if (mediaCollectionData == null) {
            return;
        }
        try {
            ArrayList<MediaData> tmpMediaDataList = new ArrayList<MediaData>();
            this.start();
            File f = new File(mediaCollectionData.getPath());
            this.logs.add("Pfad absuchen: " + f.getAbsolutePath());
            if (!f.canRead()) {
                if (!this.error.isEmpty()) {
                    this.error = this.error + P2LibConst.LINE_SEPARATOR;
                }
                this.error = this.error + f.getPath();
            }
            if (!this.error.isEmpty()) {
                this.errorMsg();
            }
            this.searchFile(new File(mediaCollectionData.getPath()), mediaCollectionData.getIdInt(), tmpMediaDataList);
            this.logs.add(" -> im Pfad gefundene Medien: " + tmpMediaDataList.size());
            this.mediaDataList.addAll(tmpMediaDataList);
            this.mediaDataList.checkDuplicateMediaData();
            this.mediaDataList.countMediaData(this.progData);
            if (mediaCollectionData.isExternal()) {
                new WriteMediaDb(this.progData).writeExternalMediaData(this.logs);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(120321254, ex);
        }
        this.stop();
    }

    private void start() {
        P2Duration.counterStart("createDB");
        this.mediaDataList.setStopSearching(false);
        this.mediaDataList.setSearching(true);
        this.progData.pEventHandler.notifyListener(PEvents.EVENT_MEDIA_DB_START);
    }

    private void stop() {
        this.mediaDataList.setSearching(false);
        P2Log.sysLog(this.logs);
        this.progData.pEventHandler.notifyListener(PEvents.EVENT_MEDIA_DB_STOP);
        P2Duration.counterStop("createDB");
    }

    private void errorMsg() {
        Platform.runLater(() -> P2Alert.showErrorAlert("Fehler beim Erstellen der Mediensammlung", (this.more ? "Die Pfade der Mediensammlung k\u00f6nnen nicht alle gelesen werden:" + P2LibConst.LINE_SEPARATOR : "Der Pfad der Mediensammlung kann nicht gelesen werden:" + P2LibConst.LINE_SEPARATOR) + this.error));
    }

    private void searchFile(File dir, int collectionIdLong, List<MediaData> tmpMediaDataList) {
        if (this.mediaDataList.isStopSearching()) {
            return;
        }
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.searchFile(file, collectionIdLong, tmpMediaDataList);
                    continue;
                }
                if (this.checkFileSize && file.length() < (long)this.fileSize || this.noHiddenFiles && file.isHidden() || !this.checkSuffix(this.suffix, file.getName())) continue;
                tmpMediaDataList.add(new MediaData(file.getName(), file.getParent().intern(), file.length(), collectionIdLong));
            }
        }
    }

    private void getSuffix() {
        String[] arr = ((String)ProgConfig.MEDIA_DB_SUFFIX.get()).split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < arr.length; ++i) {
            Object str = arr[i].trim().toLowerCase();
            if (((String)str).isEmpty()) continue;
            if (!((String)str).startsWith(".")) {
                str = "." + (String)str;
            }
            list.add((String)str);
        }
        this.suffix = list.toArray(new String[0]);
    }

    private boolean checkSuffix(String[] str, String url) {
        if (str.length == 0) {
            return true;
        }
        boolean ret = true;
        String urlLowerCase = url.toLowerCase();
        for (String s : str) {
            if (this.withoutSuffix) {
                if (!urlLowerCase.endsWith(s)) continue;
                ret = false;
                break;
            }
            ret = false;
            if (!urlLowerCase.endsWith(s)) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

