/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.load;

import de.p2tools.mtplayer.controller.ProgSave;
import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.mtplayer.controller.data.abo.AboSearchDownloadsFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.setdata.SetFactory;
import de.p2tools.mtplayer.controller.mediadb.MediaDataWorker;
import de.p2tools.mtplayer.controller.update.WhatsNewFactory;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.mtplayer.gui.tools.ProgTipOfDayFactory;
import de.p2tools.p2lib.mediathek.film.P2FilmlistFactory;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javafx.application.Platform;

public class LoadFilmListWorker {
    private static boolean doneAtProgramStart = false;
    private final ProgData progData;

    public LoadFilmListWorker(final ProgData progData) {
        this.progData = progData;
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_START){

            public void pingGui(P2Event event) {
                ProgData.FILMLIST_IS_DOWNLOADING.setValue(true);
                LoadFilmListWorker.this.workOnFilmListLoadStart();
                if (event.getAct() == -1.0) {
                    progData.maskerPane.setMaskerVisible(true, true, true);
                }
                progData.maskerPane.setMaskerProgress(event.getAct(), event.getText());
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_PROGRESS){

            public void pingGui(P2Event event) {
                progData.maskerPane.setMaskerProgress(event.getAct(), event.getText());
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_LOADED){

            @Override
            public void pingGui() {
                progData.maskerPane.setMaskerVisible(true, true, false);
                progData.maskerPane.setMaskerProgress(-1.0, "Filmliste verarbeiten");
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_FINISHED){

            @Override
            public void pingGui() {
                P2Duration.onlyPing("Filme geladen: Nachbearbeiten");
                LoadFilmListWorker.this.afterLoadingFilmList();
                ProgData.FILMLIST_IS_DOWNLOADING.setValue(false);
            }
        });
    }

    public void workOnFilmListLoadStart() {
        this.progData.worker.saveFilter();
    }

    private void afterLoadingFilmList() {
        boolean search = !ProgData.AUDIOLIST_IS_DOWNLOADING.get();
        new Thread(() -> {
            ArrayList<String> logList = new ArrayList<String>();
            logList.add("Themen suchen");
            this.progData.filmList.loadTheme();
            logList.add("Abos eintragen");
            AboFactory.setAboForList(false, ProgData.getInstance().filmList);
            logList.add("Bookmarks eintragen");
            BookmarkFactory.markBookmarks();
            logList.add("Blacklist filtern");
            this.progData.maskerPane.setMaskerText("Blacklist filtern");
            BlacklistFilterFactory.markFilmsIfBlack(false, false);
            this.progData.blackList.sortAndCleanTheList();
            this.progData.filmListFilter.sortAndCleanTheList();
            logList.add("Filme in Downloads eingetragen");
            this.progData.maskerPane.setMaskerText("Downloads eingetragen");
            LoadFilmListWorker.addFilmInDownloads();
            P2Log.sysLog(logList);
            P2Duration.onlyPing("Filme nachbearbeiten: Ende");
            this.progData.maskerPane.setMaskerText("Abos suchen");
            this.workOnFilmListLoadFinished(search);
            this.progData.pEventHandler.notifyListener(PEvents.EVENT_FILTER_FILM_CHANGED);
            String filmDate = P2FilmlistFactory.getAgeAsStringDate(this.progData.filmList.metaData);
            ProgConfig.SYSTEM_FILMLIST_DATE.setValue(this.progData.filmList.isEmpty() ? "" : filmDate);
            if (!ProgData.AUDIOLIST_IS_DOWNLOADING.get()) {
                this.progData.maskerPane.switchOffMasker();
            }
            if (ProgData.firstProgramStart) {
                ProgData.firstProgramStart = false;
                Platform.runLater(ProgSave::saveAll);
            }
            if (!doneAtProgramStart) {
                doneAtProgramStart = true;
                MediaDataWorker.createMediaDb();
                if (!ProgData.autoMode) {
                    WhatsNewFactory.checkUpdate();
                    Platform.runLater(() -> {
                        ProgTipOfDayFactory.showDialog(ProgData.getInstance(), false);
                        if (ProgConfig.CHECK_SET_PROGRAM_START.get()) {
                            SetFactory.checkPrograms(this.progData.primaryStage, this.progData, false);
                        }
                    });
                }
            }
        }).start();
    }

    private void workOnFilmListLoadFinished(boolean search) {
        Platform.runLater(() -> {
            ThemeListFactory.allChannelListFilm.setAll((Collection<String>)Arrays.asList(this.progData.filmList.sender));
            ThemeListFactory.createThemeList(false, this.progData, this.progData.filterWorkerFilm.getActFilterSettings().getChannel());
            if (search && (ProgConfig.ABO_SEARCH_NOW.getValue().booleanValue() || ProgData.autoMode)) {
                AboSearchDownloadsFactory.searchForDownloadsFromAbosAndMaybeStart();
            }
            this.progData.worker.resetFilter();
        });
    }

    private static synchronized void addFilmInDownloads() {
        P2Duration.counterStart("addFilmInList");
        ProgData progData = ProgData.getInstance();
        int counter = 50;
        for (DownloadData d : progData.downloadList) {
            if (d.isAudio()) continue;
            if (--counter < 0) break;
            d.setFilm((FilmDataMTP)progData.filmList.getFilmByUrl_small_high_hd(d.getUrl()));
            d.initResolution();
        }
        P2Duration.counterStop("addFilmInList");
    }
}

