/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.load;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.controller.load.LoadAudioFactory;
import de.p2tools.mtplayer.controller.load.LoadFilmFactory;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;

public class LoadFactory {
    private LoadFactory() {
    }

    public static void loadProgStart() {
        LoadFactory.initLoadFactoryConst();
        LoadFilmFactory.loadFilmListProgStart();
        LoadAudioFactory.loadAudioListProgStart();
    }

    public static void updateLists(boolean alwaysNew) {
        LoadFactory.initLoadFactoryConst();
        LoadFilmFactory.loadFilmListFromWeb(alwaysNew, false);
        LoadAudioFactory.loadAudioListFromWeb(alwaysNew, false);
    }

    public static void initLoadFactoryConst() {
        P2LoadConst.GEO_HOME_PLACE = ProgConfig.SYSTEM_GEO_HOME_PLACE.getValue();
        P2LoadConst.SYSTEM_LOAD_NOT_SENDER = ProgConfig.SYSTEM_LOAD_NOT_SENDER.getValue();
        P2LoadConst.SYSTEM_LOAD_FILMLIST_MAX_DAYS = ProgConfig.SYSTEM_LOAD_FILMLIST_MAX_DAYS.getValue();
        P2LoadConst.SYSTEM_LOAD_FILMLIST_MIN_DURATION = ProgConfig.SYSTEM_LOAD_FILMLIST_MIN_DURATION.getValue();
        P2LoadConst.removeDiacritic = ProgConfig.SYSTEM_REMOVE_DIACRITICS.getValue();
        P2LoadConst.userAgent = ProgConfig.SYSTEM_USERAGENT.getValue();
        P2LoadConst.firstProgramStart = ProgData.firstProgramStart;
        P2LoadConst.debug = ProgData.debug;
        P2LoadConst.primaryStage = ProgData.getInstance().primaryStage;
        P2LoadConst.p2EventHandler = ProgData.getInstance().pEventHandler;
        P2LoadConst.loadNewFilmlistOnProgramStart = ProgConfig.SYSTEM_LOAD_FILMLIST_ON_PROGRAMSTART.getValue() != false || ProgData.autoMode;
        P2LoadConst.dateStoredAudiolist = ProgConfig.SYSTEM_AUDIOLIST_DATE_TIME;
        P2LoadConst.dateStoredFilmlist = ProgConfig.SYSTEM_FILMLIST_DATE;
        P2LoadConst.SYSTEM_AUDIOLIST_COUNT_DOUBLE = ProgConfig.SYSTEM_AUDIOLIST_COUNT_DOUBLE;
        P2LoadConst.SYSTEM_FILMLIST_REMOVE_DOUBLE = ProgConfig.SYSTEM_FILMLIST_REMOVE_DOUBLE.get();
        P2LoadConst.localAudioListFile = ProgInfos.getAudioListFile();
        P2LoadConst.localFilmListFile = ProgInfos.getLocalFilmListFile();
        P2LoadConst.filmlistLocal = ProgData.getInstance().filmList;
        P2LoadConst.audioListLocal = ProgData.getInstance().audioList;
        P2LoadConst.filmListUrl = ProgData.filmListUrl;
        if (ProgConfig.SYSTEM_FILMLIST_FILTER.getValue() == 0) {
            P2LoadConst.checkerFilm = null;
            P2LoadConst.checkerAudio = null;
        } else if (ProgConfig.SYSTEM_FILMLIST_FILTER.getValue() == 1) {
            ProgData.getInstance().filmListFilter.clearCounter();
            P2LoadConst.checkerFilm = filmData -> BlacklistFilterFactory.checkFilmIsBlack(false, filmData, ProgData.getInstance().filmListFilter, true);
            P2LoadConst.checkerAudio = filmData -> BlacklistFilterFactory.checkFilmIsBlack(true, filmData, ProgData.getInstance().filmListFilter, true);
        } else {
            ProgData.getInstance().filmListFilter.clearCounter();
            P2LoadConst.checkerFilm = filmData -> !BlacklistFilterFactory.checkFilmIsBlack(false, filmData, ProgData.getInstance().filmListFilter, true);
            P2LoadConst.checkerAudio = filmData -> !BlacklistFilterFactory.checkFilmIsBlack(true, filmData, ProgData.getInstance().filmListFilter, true);
        }
    }
}

