/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.load;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.mtplayer.controller.data.abo.AboSearchDownloadsFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javafx.application.Platform;

public class LoadAudioListWorker {
    private static boolean doneAtProgramStart = false;
    private final ProgData progData;

    public LoadAudioListWorker(final ProgData progData) {
        this.progData = progData;
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_AUDIO_LIST_LOAD_START){

            public void pingGui(P2Event event) {
                ProgData.AUDIOLIST_IS_DOWNLOADING.setValue(true);
                if (event.getAct() == -1.0) {
                    progData.maskerPane.setMaskerVisible(true, true, true);
                }
                progData.maskerPane.setMaskerProgress(event.getAct(), event.getText());
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_AUDIO_LIST_LOAD_PROGRESS){

            public void pingGui(P2Event event) {
                progData.maskerPane.setMaskerProgress(event.getAct(), event.getText());
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_AUDIO_LIST_LOAD_LOADED){

            @Override
            public void pingGui() {
                progData.maskerPane.setMaskerVisible(true, true, false);
                progData.maskerPane.setMaskerProgress(-1.0, "Filmliste verarbeiten");
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_AUDIO_LIST_LOAD_FINISHED){

            @Override
            public void pingGui() {
                P2Duration.onlyPing("Filme geladen: Nachbearbeiten");
                LoadAudioListWorker.this.afterLoading();
                ProgData.AUDIOLIST_IS_DOWNLOADING.setValue(false);
            }
        });
    }

    private void afterLoading() {
        boolean search = !ProgData.FILMLIST_IS_DOWNLOADING.get();
        new Thread(() -> {
            ArrayList<String> logList = new ArrayList<String>();
            logList.add("Themen suchen");
            this.progData.audioList.loadTheme();
            logList.add("Abos eintragen");
            AboFactory.setAboForList(true, ProgData.getInstance().audioList);
            logList.add("Bookmarks eintragen");
            BookmarkFactory.markBookmarks();
            logList.add("Blacklist filtern");
            this.progData.maskerPane.setMaskerText("Blacklist filtern");
            BlacklistFilterFactory.markFilmsIfBlack(true, false);
            logList.add("Filme in Downloads eingetragen");
            this.progData.maskerPane.setMaskerText("Downloads eingetragen");
            LoadAudioListWorker.addFilmInDownloads();
            P2Log.sysLog(logList);
            P2Duration.onlyPing("Filme nachbearbeiten: Ende");
            this.workOnFilmListLoadFinished(search);
            this.progData.pEventHandler.notifyListener(PEvents.EVENT_FILTER_AUDIO_CHANGED);
            if (!ProgData.FILMLIST_IS_DOWNLOADING.get()) {
                this.progData.maskerPane.switchOffMasker();
            }
        }).start();
    }

    private void workOnFilmListLoadFinished(boolean search) {
        Platform.runLater(() -> {
            ThemeListFactory.allChannelListAudio.setAll((Collection<String>)Arrays.asList(this.progData.audioList.sender));
            ThemeListFactory.createThemeList(true, this.progData, this.progData.filterWorkerAudio.getActFilterSettings().getChannel());
            if (search && (ProgConfig.ABO_SEARCH_NOW.getValue().booleanValue() || ProgData.autoMode)) {
                AboSearchDownloadsFactory.searchForDownloadsFromAbosAndMaybeStart();
            }
            this.progData.worker.resetFilter();
        });
    }

    private static synchronized void addFilmInDownloads() {
        P2Duration.counterStart("addFilmInList");
        ProgData progData = ProgData.getInstance();
        int counter = 50;
        for (DownloadData d : progData.downloadList) {
            if (!d.isAudio()) continue;
            if (--counter < 0) break;
            d.setFilm((FilmDataMTP)progData.audioList.getFilmByUrl_small_high_hd(d.getUrl()));
            d.initResolution();
        }
        P2Duration.counterStop("addFilmInList");
    }
}

