/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchzdf;

import com.fasterxml.jackson.databind.JsonNode;
import de.p2tools.mtplayer.controller.livesearch.JsonInfoDto;
import de.p2tools.mtplayer.controller.livesearch.tools.JsonFactory;
import de.p2tools.mtplayer.controller.livesearch.tools.JsonUtils;
import de.p2tools.mtplayer.controller.livesearch.tools.UrlUtils;
import de.p2tools.mtplayer.controller.livesearchzdf.DownloadDto;
import de.p2tools.mtplayer.controller.livesearchzdf.ZdfDownloadDtoDeserializer;
import de.p2tools.mtplayer.controller.livesearchzdf.ZdfFilmDetailTask;
import de.p2tools.mtplayer.controller.livesearchzdf.ZdfFilmDto;
import de.p2tools.p2lib.tools.log.P2Log;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class ZdfFilmDetailDeserializer {
    private static final String GERMAN_TIME_ZONE = "Europe/Berlin";
    private static final String JSON_ELEMENT_BEGIN = "airtimeBegin";
    private static final String JSON_ELEMENT_BRAND = "http://zdf.de/rels/brand";
    private static final String JSON_ELEMENT_CATEGORY = "http://zdf.de/rels/category";
    private static final String JSON_ELEMENT_BROADCAST = "http://zdf.de/rels/cmdm/broadcasts";
    private static final String JSON_ELEMENT_DURATION = "duration";
    private static final String JSON_ELEMENT_EDITORIAL_DATE = "editorialDate";
    private static final String JSON_ELEMENT_LEAD_PARAGRAPH = "leadParagraph";
    private static final String JSON_ELEMENT_MAIN_VIDEO = "mainVideoContent";
    private static final String JSON_ELEMENT_PROGRAM_ITEM = "programmeItem";
    private static final String JSON_ELEMENT_SHARING_URL = "http://zdf.de/rels/sharing-url";
    private static final String JSON_ELEMENT_STREAMS = "streams";
    private static final String JSON_ELEMENT_SUBTITLE = "subtitle";
    private static final String JSON_ELEMENT_TARGET = "http://zdf.de/rels/target";
    private static final String JSON_ELEMENT_TITLE = "title";
    private static final String JSON_ELEMENT_TEASER_TEXT = "teasertext";
    private static final String JSON_ATTRIBUTE_TEMPLATE = "http://zdf.de/rels/streams/ptmd-template";
    private static final String EPISODENUMBER = "episodeNumber";
    private static final String[] SEASONNUMBER = new String[]{"http://zdf.de/rels/cmdm/season", "seasonNumber"};
    private static final String PLACEHOLDER_PLAYER_ID = "{playerId}";
    private static final String PLAYER_ID = "android_native_5";
    private static final String DOWNLOAD_URL_DEFAULT = "default";
    private static final String DOWNLOAD_URL_DGS = "dgs";
    private static final String[] KNOWN_STREAMS = new String[]{"default", "dgs"};
    private static final DateTimeFormatter DATE_FORMATTER_EDITORIAL = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static final DateTimeFormatter DATE_FORMATTER_AIRTIME = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
    private final String apiUrlBase = "https://api.zdf.de";
    private final JsonInfoDto jsonInfoDto;

    public ZdfFilmDetailDeserializer(JsonInfoDto jsonInfoDto) {
        this.jsonInfoDto = jsonInfoDto;
    }

    public void deserialize(String getUrl) {
        try {
            JsonNode mainVideoElement;
            Optional<JsonNode> optRootNode = JsonFactory.getRootNode(getUrl, "Bearer " + this.jsonInfoDto.getApi());
            if (optRootNode.isEmpty()) {
                return;
            }
            JsonNode rootNode = optRootNode.get();
            JsonNode programItemTarget = null;
            JsonNode mainVideoTarget = null;
            if (rootNode.get(JSON_ELEMENT_PROGRAM_ITEM) != null) {
                Iterator<JsonNode> children = rootNode.get(JSON_ELEMENT_PROGRAM_ITEM).elements();
                if (!children.hasNext()) {
                    P2Log.debugLog("getVideoUrl: error");
                    return;
                }
                JsonNode jn = children.next();
                if (rootNode.get(JSON_ELEMENT_TARGET) != null) {
                    programItemTarget = jn.get(JSON_ELEMENT_TARGET);
                }
            }
            if (rootNode.get(JSON_ELEMENT_MAIN_VIDEO) != null && (mainVideoElement = rootNode.get(JSON_ELEMENT_MAIN_VIDEO)).get(JSON_ELEMENT_TARGET) != null) {
                mainVideoTarget = mainVideoElement.get(JSON_ELEMENT_TARGET);
            }
            Optional<String> title = this.parseTitle(rootNode, programItemTarget);
            Optional<String> topic = this.parseTopic(rootNode);
            Optional<String> description = this.parseDescription(rootNode);
            Optional<String> website = this.parseWebsiteUrl(rootNode);
            Optional<LocalDateTime> time = this.parseAirtime(rootNode, programItemTarget);
            Optional<Duration> duration = this.parseDuration(mainVideoTarget);
            Map<String, String> downloadUrl = this.parseDownloadUrls(mainVideoTarget);
            if (title.isPresent() && downloadUrl.containsKey(DOWNLOAD_URL_DEFAULT)) {
                ZdfFilmDto zdfFilmDto = new ZdfFilmDto(downloadUrl.get(DOWNLOAD_URL_DEFAULT), topic, title.get(), description, website, time, duration, downloadUrl.get(DOWNLOAD_URL_DGS));
                Optional<DownloadDto> downloadDtoOptional = new ZdfDownloadDtoDeserializer().deserialize(this.jsonInfoDto, downloadUrl.get(DOWNLOAD_URL_DEFAULT));
                downloadDtoOptional.ifPresent(downloadDto -> new ZdfFilmDetailTask().processRestTarget(this.jsonInfoDto, zdfFilmDto, (DownloadDto)downloadDto));
            } else {
                P2Log.errorLog(652365478, "ZdfFilmDetailDeserializer: no title or url found");
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(959454120, ex, "Url: " + getUrl);
        }
    }

    private Map<String, String> parseDownloadUrls(JsonNode mainVideoContent) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (mainVideoContent != null) {
            Optional<String> urlOptional;
            for (String knownStream : KNOWN_STREAMS) {
                Optional<String> url;
                if (!JsonUtils.checkTreePath(mainVideoContent, JSON_ELEMENT_STREAMS, knownStream, JSON_ATTRIBUTE_TEMPLATE) || !(url = JsonUtils.getAttributeAsString(mainVideoContent.get(JSON_ELEMENT_STREAMS).get(knownStream), JSON_ATTRIBUTE_TEMPLATE)).isPresent()) continue;
                result.put(knownStream, this.finalizeDownloadUrl(url.get()));
            }
            if (!result.containsKey(DOWNLOAD_URL_DEFAULT) && (urlOptional = JsonUtils.getAttributeAsString(mainVideoContent, JSON_ATTRIBUTE_TEMPLATE)).isPresent()) {
                result.put(DOWNLOAD_URL_DEFAULT, this.finalizeDownloadUrl(urlOptional.get()));
            }
        }
        return result;
    }

    private String finalizeDownloadUrl(String url) {
        return UrlUtils.addDomainIfMissing(url, "https://api.zdf.de").replace(PLACEHOLDER_PLAYER_ID, PLAYER_ID);
    }

    private Optional<LocalDateTime> parseAirtime(JsonNode aRootNode, JsonNode aProgramItemTarget) {
        if (aProgramItemTarget != null) {
            DateTimeFormatter formatter;
            Optional<String> date;
            Iterator<JsonNode> it = aProgramItemTarget.iterator();
            if (!it.hasNext()) {
                date = this.getEditorialDate(aRootNode);
                formatter = DATE_FORMATTER_EDITORIAL;
            } else {
                date = Optional.of(it.next().get(JSON_ELEMENT_BEGIN).asText());
                formatter = DATE_FORMATTER_AIRTIME;
            }
            return date.map(s -> LocalDateTime.parse(s, formatter));
        }
        Optional<String> date = this.getEditorialDate(aRootNode);
        if (date.isPresent()) {
            ZonedDateTime inputDateTime = ZonedDateTime.parse(date.get());
            LocalDateTime localDateTime = inputDateTime.withZoneSameInstant(ZoneId.of(GERMAN_TIME_ZONE)).toLocalDateTime();
            return Optional.of(localDateTime);
        }
        return Optional.empty();
    }

    private Optional<String> getEditorialDate(JsonNode aRootNode) {
        if (aRootNode.has(JSON_ELEMENT_EDITORIAL_DATE)) {
            return Optional.of(aRootNode.get(JSON_ELEMENT_EDITORIAL_DATE).asText());
        }
        return Optional.empty();
    }

    private Optional<String> parseWebsiteUrl(JsonNode aRootNode) {
        if (aRootNode.has(JSON_ELEMENT_SHARING_URL)) {
            return Optional.of(aRootNode.get(JSON_ELEMENT_SHARING_URL).asText());
        }
        return Optional.empty();
    }

    private Optional<Duration> parseDuration(JsonNode mainVideoTarget) {
        JsonNode duration;
        if (mainVideoTarget != null && (duration = mainVideoTarget.get(JSON_ELEMENT_DURATION)) != null) {
            return Optional.of(Duration.ofSeconds(duration.asInt()));
        }
        return Optional.empty();
    }

    private Optional<String> parseDescription(JsonNode aRootNode) {
        JsonNode leadParagraph = aRootNode.get(JSON_ELEMENT_LEAD_PARAGRAPH);
        if (leadParagraph != null) {
            return Optional.of(leadParagraph.asText());
        }
        JsonNode teaserText = aRootNode.get(JSON_ELEMENT_TEASER_TEXT);
        if (teaserText != null) {
            return Optional.of(teaserText.asText());
        }
        return Optional.empty();
    }

    private Optional<String> parseTitle(JsonNode aRootNode, JsonNode aTarget) {
        Optional<String> programmTitle = JsonUtils.getElementValueAsString(aRootNode, JSON_ELEMENT_TITLE);
        Optional<String> programmSubtitle = JsonUtils.getElementValueAsString(aRootNode, JSON_ELEMENT_SUBTITLE);
        Optional<String> resultingTitle = this.formatTitle(programmTitle, programmSubtitle);
        if (resultingTitle.isEmpty()) {
            Optional<String> targetTitle = JsonUtils.getElementValueAsString(aTarget, JSON_ELEMENT_TITLE);
            Optional<String> targetSubtitle = JsonUtils.getElementValueAsString(aTarget, JSON_ELEMENT_SUBTITLE);
            resultingTitle = this.formatTitle(targetTitle, targetSubtitle);
        }
        if (resultingTitle.isPresent()) {
            Optional<Integer> season = JsonUtils.getElementValueAsInteger(aTarget, SEASONNUMBER);
            Optional<Integer> episode = JsonUtils.getElementValueAsInteger(aTarget, EPISODENUMBER);
            Optional<String> seasonEpisodeTitle = this.formatEpisodeTitle(season, episode);
            Optional<String> title = this.cleanupTitle((resultingTitle.get() + " " + seasonEpisodeTitle.orElse("")).trim());
            return title;
        }
        return Optional.empty();
    }

    private Optional<String> cleanupTitle(String title) {
        return Optional.of(title.replaceAll("\\(CC.*\\) - .* Creative Commons.*", ""));
    }

    private Optional<String> formatTitle(Optional<String> title, Optional<String> sub) {
        if (title.isEmpty()) {
            return Optional.empty();
        }
        if (sub.isPresent() && !sub.get().isBlank()) {
            return Optional.of(title.get().trim() + " - " + sub.get().trim());
        }
        return Optional.of(title.get().trim());
    }

    private Optional<String> formatEpisodeTitle(Optional<Integer> season, Optional<Integer> episode) {
        if (season.isEmpty() && episode.isEmpty()) {
            return Optional.empty();
        }
        Object result = "";
        if (season.isPresent()) {
            result = (String)result + String.format("S%02d", season.get());
        }
        if (season.isPresent() && episode.isPresent()) {
            result = (String)result + "/";
        }
        if (episode.isPresent()) {
            result = (String)result + String.format("E%02d", episode.get());
        }
        return Optional.of("(" + (String)result + ")");
    }

    private Optional<String> parseTopic(JsonNode aRootNode) {
        JsonNode topic;
        JsonNode brand = aRootNode.get(JSON_ELEMENT_BRAND);
        JsonNode category = aRootNode.get(JSON_ELEMENT_CATEGORY);
        if (brand != null && (topic = brand.get(JSON_ELEMENT_TITLE)) != null) {
            return Optional.of(topic.asText());
        }
        if (category != null && (topic = category.get(JSON_ELEMENT_TITLE)) != null) {
            return Optional.of(topic.asText());
        }
        return Optional.empty();
    }
}

