/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchzdf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.p2tools.mtplayer.controller.livesearch.JsonInfoDto;
import de.p2tools.mtplayer.controller.livesearch.tools.LiveConst;
import de.p2tools.mtplayer.controller.livesearchzdf.DownloadDto;
import de.p2tools.mtplayer.controller.livesearchzdf.GeoLocations;
import de.p2tools.p2lib.mediathek.download.MtHttpClient;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.InputStream;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ZdfDownloadDtoDeserializer {
    private static final String ZDF_QUALITY_UHD = "uhd";
    private static final String ZDF_QUALITY_FHD = "fhd";
    private static final String ZDF_QUALITY_HD = "hd";
    private static final String ZDF_QUALITY_VERYHIGH = "veryhigh";
    private static final String ZDF_QUALITY_HIGH = "high";
    private static final String ZDF_QUALITY_MED = "med";
    private static final String ZDF_QUALITY_MEDIUM = "medium";
    private static final String ZDF_QUALITY_LOW = "low";
    private static final String JSON_ELEMENT_ATTRIBUTES = "attributes";
    private static final String JSON_ELEMENT_AUDIO = "audio";
    private static final String JSON_ELEMENT_CAPTIONS = "captions";
    private static final String JSON_ELEMENT_CLASS = "class";
    private static final String JSON_ELEMENT_DURATION = "duration";
    private static final String JSON_ELEMENT_FORMITAET = "formitaeten";
    private static final String JSON_ELEMENT_GEOLOCATION = "geoLocation";
    private static final String JSON_ELEMENT_HIGHEST_VERTIVAL_RESOLUTION = "highestVerticalResolution";
    private static final String JSON_ELEMENT_LANGUAGE = "language";
    private static final String JSON_ELEMENT_MIMETYPE = "mimeType";
    private static final String JSON_ELEMENT_PRIORITYLIST = "priorityList";
    private static final String JSON_ELEMENT_QUALITY = "quality";
    private static final String JSON_ELEMENT_TRACKS = "tracks";
    private static final String JSON_ELEMENT_URI = "uri";
    private static final String JSON_PROPERTY_VALUE = "value";
    private static final String CLASS_AD = "ad";
    private static final String RELEVANT_MIME_TYPE = "video/mp4";
    private static final String RELEVANT_SUBTITLE_TYPE = ".xml";
    private static final String JSON_ELEMENT_QUALITIES = "qualities";

    public Optional<DownloadDto> deserialize(JsonInfoDto jsonInfoDto, String videoUrl) {
        try {
            Request.Builder builder = new Request.Builder().url(videoUrl);
            String api = "Bearer " + jsonInfoDto.getApi();
            builder.addHeader("Api-Auth", api);
            Response response = MtHttpClient.getInstance().getHttpClient().newCall(builder.build()).execute();
            ResponseBody body = response.body();
            DownloadDto downloadDto = new DownloadDto();
            if (body != null && response.isSuccessful()) {
                InputStream input = body.byteStream();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode rootNode = objectMapper.readTree(input);
                this.parseDuration(downloadDto, rootNode);
                this.parseVideoUrls(downloadDto, rootNode);
                this.parseSubtitle(downloadDto, rootNode);
                this.parseGeoLocation(downloadDto, rootNode);
            }
            return Optional.of(downloadDto);
        }
        catch (Exception ex) {
            P2Log.errorLog(959562301, ex, "Url: " + videoUrl);
            return Optional.empty();
        }
    }

    private void parseDuration(DownloadDto dto, JsonNode rootNode) {
        JsonNode durationValue;
        JsonNode durationElement;
        JsonNode attributes = rootNode.get(JSON_ELEMENT_ATTRIBUTES);
        if (attributes != null && (durationElement = attributes.get(JSON_ELEMENT_DURATION)) != null && (durationValue = durationElement.get(JSON_PROPERTY_VALUE)) != null) {
            dto.setDuration(Duration.ofMillis(durationValue.asLong()));
        }
    }

    private void parseVideoUrls(DownloadDto dto, JsonNode rootNode) {
        JsonNode jn = rootNode.get(JSON_ELEMENT_PRIORITYLIST);
        if (jn != null) {
            Iterator<JsonNode> children = jn.elements();
            while (children.hasNext()) {
                JsonNode jnC = children.next();
                this.parsePriority(dto, jnC);
            }
        }
    }

    private void parsePriority(DownloadDto dto, JsonNode priority) {
        JsonNode jn;
        if (priority != null && (jn = priority.get(JSON_ELEMENT_FORMITAET)) != null) {
            Iterator<JsonNode> children = jn.elements();
            while (children.hasNext()) {
                JsonNode jnC = children.next();
                this.parseFormitaet(dto, jnC);
            }
        }
    }

    private void parseFormitaet(DownloadDto dto, JsonNode formitaet) {
        JsonNode mimeType = formitaet.get(JSON_ELEMENT_MIMETYPE);
        if (mimeType != null && mimeType.asText().equalsIgnoreCase(RELEVANT_MIME_TYPE)) {
            ArrayList<DownloadInfo> downloads = new ArrayList<DownloadInfo>();
            JsonNode jn = formitaet.get(JSON_ELEMENT_QUALITIES);
            if (jn != null) {
                Iterator<JsonNode> qualityList = jn.elements();
                while (qualityList.hasNext()) {
                    JsonNode jnTr;
                    JsonNode audio;
                    JsonNode quality = qualityList.next();
                    LiveConst.Qualities qualityValue = this.parseVideoQuality(quality);
                    JsonNode jnQ = quality.get(JSON_ELEMENT_HIGHEST_VERTIVAL_RESOLUTION);
                    int verticalResolution = 0;
                    if (jnQ != null) {
                        verticalResolution = jnQ.asInt();
                    }
                    if ((audio = quality.get(JSON_ELEMENT_AUDIO)) == null || (jnTr = audio.get(JSON_ELEMENT_TRACKS)) == null) continue;
                    Iterator<JsonNode> tracks = jnTr.elements();
                    while (tracks.hasNext()) {
                        JsonNode track = tracks.next();
                        JsonNode size = track.get("filesize");
                        String fileSize = "";
                        if (size != null) {
                            fileSize = size.asText();
                        }
                        AbstractMap.SimpleEntry<String, String> languageUri = this.extractTrack(track);
                        downloads.add(new DownloadInfo(languageUri.getKey(), languageUri.getValue(), verticalResolution, qualityValue, fileSize));
                        if (downloads.size() != 1 || qualityValue.equals((Object)LiveConst.Qualities.NORMAL)) continue;
                        downloads.add(new DownloadInfo(languageUri.getKey(), languageUri.getValue(), verticalResolution, LiveConst.Qualities.NORMAL, fileSize));
                    }
                }
            }
            downloads.sort(Comparator.comparingInt(DownloadInfo::getVerticalResolution));
            downloads.forEach(info -> dto.addUrl(info.getLanguage(), info.getQuality(), info.getUri()));
        }
    }

    private AbstractMap.SimpleEntry<String, String> extractTrack(JsonNode trackObject) {
        String classValue = trackObject.get(JSON_ELEMENT_CLASS).asText();
        Object language = trackObject.get(JSON_ELEMENT_LANGUAGE).asText();
        String uri = trackObject.get(JSON_ELEMENT_URI).asText();
        if (CLASS_AD.equalsIgnoreCase(classValue)) {
            language = (String)language + "-ad";
        }
        if (uri != null) {
            return new AbstractMap.SimpleEntry<Object, String>(language, uri);
        }
        throw new RuntimeException("uri is null");
    }

    private void parseSubtitle(DownloadDto dto, JsonNode rootNode) {
        JsonNode jn = rootNode.get(JSON_ELEMENT_CAPTIONS);
        if (jn != null) {
            Iterator<JsonNode> captionList = rootNode.get(JSON_ELEMENT_CAPTIONS).elements();
            while (captionList.hasNext()) {
                JsonNode caption = captionList.next();
                JsonNode uri = caption.get(JSON_ELEMENT_URI);
                if (uri == null) continue;
                String uriValue = uri.asText();
                JsonNode jnL = caption.get(JSON_ELEMENT_LANGUAGE);
                String language = jnL != null ? caption.get(JSON_ELEMENT_LANGUAGE).asText() : "";
                if (!uriValue.endsWith(RELEVANT_SUBTITLE_TYPE) && dto.getSubTitleUrl(language).isPresent()) continue;
                dto.addSubTitleUrl(language, uriValue);
            }
        }
    }

    private void parseGeoLocation(DownloadDto dto, JsonNode rootNode) {
        JsonNode geoValue;
        JsonNode geoLocation;
        JsonNode attributes = rootNode.get(JSON_ELEMENT_ATTRIBUTES);
        if (attributes != null && (geoLocation = attributes.get(JSON_ELEMENT_GEOLOCATION)) != null && (geoValue = geoLocation.get(JSON_PROPERTY_VALUE)) != null) {
            Optional<GeoLocations> foundGeoLocation = GeoLocations.find(geoValue.asText());
            if (foundGeoLocation.isPresent()) {
                dto.setGeoLocation(foundGeoLocation.get());
            } else {
                P2Log.errorLog(951542145, "Can't find a GeoLocation for \"{}\" " + geoValue.asText());
            }
        }
    }

    private LiveConst.Qualities parseVideoQuality(JsonNode quality) {
        String zdfQuality;
        return switch (zdfQuality = quality.get(JSON_ELEMENT_QUALITY).asText()) {
            case ZDF_QUALITY_LOW, ZDF_QUALITY_MED, ZDF_QUALITY_MEDIUM, ZDF_QUALITY_HIGH -> LiveConst.Qualities.SMALL;
            case ZDF_QUALITY_VERYHIGH -> LiveConst.Qualities.NORMAL;
            case ZDF_QUALITY_HD, ZDF_QUALITY_FHD -> LiveConst.Qualities.HD;
            case ZDF_QUALITY_UHD -> LiveConst.Qualities.UHD;
            default -> {
                P2Log.errorLog(959562541, "unknown quality: {} " + zdfQuality);
                P2Log.errorLog(852141452, "ZDF: unknown quality: " + zdfQuality);
                yield LiveConst.Qualities.SMALL;
            }
        };
    }

    private class DownloadInfo {
        private String language;
        private String uri;
        private int verticalResolution;
        private LiveConst.Qualities quality;
        private String fileSize;

        DownloadInfo(String language, String uri, int verticalResolution, LiveConst.Qualities quality, String fileSize) {
            this.language = language;
            this.uri = uri;
            this.verticalResolution = verticalResolution;
            this.quality = quality;
            this.fileSize = fileSize;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getUri() {
            return this.uri;
        }

        public int getVerticalResolution() {
            return this.verticalResolution;
        }

        public LiveConst.Qualities getQuality() {
            return this.quality;
        }

        public String getFileSize() {
            return this.fileSize;
        }
    }
}

