/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchzdf;

import de.p2tools.mtplayer.controller.livesearch.tools.LiveConst;
import de.p2tools.mtplayer.controller.livesearchzdf.GeoLocations;
import java.time.Duration;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DownloadDto {
    private Optional<GeoLocations> geoLocation;
    private final Map<String, String> subTitleUrls;
    private final Map<String, Map<LiveConst.Qualities, String>> downloadUrls = new HashMap<String, Map<LiveConst.Qualities, String>>();
    private Optional<Duration> duration;

    public DownloadDto() {
        this.geoLocation = Optional.empty();
        this.subTitleUrls = new HashMap<String, String>();
    }

    public void addUrl(String language, LiveConst.Qualities quality, String url) {
        if (!this.downloadUrls.containsKey(language)) {
            this.downloadUrls.put(language, new EnumMap(LiveConst.Qualities.class));
        }
        Map<LiveConst.Qualities, String> urlMap = this.downloadUrls.get(language);
        urlMap.put(quality, url);
    }

    public Map<LiveConst.Qualities, String> getDownloadUrls(String language) {
        if (this.downloadUrls.containsKey(language)) {
            return this.downloadUrls.get(language);
        }
        return new EnumMap<LiveConst.Qualities, String>(LiveConst.Qualities.class);
    }

    public Optional<Duration> getDuration() {
        return this.duration;
    }

    public Set<String> getLanguages() {
        return this.downloadUrls.keySet();
    }

    public Optional<GeoLocations> getGeoLocation() {
        return this.geoLocation;
    }

    public Optional<String> getSubTitleUrl(String language) {
        if (this.subTitleUrls.containsKey(language)) {
            return Optional.of(this.subTitleUrls.get(language));
        }
        return Optional.empty();
    }

    public Optional<String> getUrl(String language, LiveConst.Qualities resolution) {
        Map<LiveConst.Qualities, String> urlMap;
        if (this.downloadUrls.containsKey(language) && (urlMap = this.downloadUrls.get(language)).containsKey((Object)resolution)) {
            return Optional.of(urlMap.get((Object)resolution));
        }
        return Optional.empty();
    }

    public void setDuration(Duration duration) {
        this.duration = Optional.of(duration);
    }

    public void setGeoLocation(GeoLocations aGeoLocation) {
        this.geoLocation = Optional.of(aGeoLocation);
    }

    public void addSubTitleUrl(String language, String aUrl) {
        this.subTitleUrls.put(language, aUrl);
    }
}

